package clinical.web.common.query;

import java.io.Serializable;

/**
 * Abstract Object representing a search predicate and a logical operator in the
 * operator parse tree used by the query builders.
 * 
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Operator.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public abstract class Operator implements Serializable {
   private static final long serialVersionUID = 1L;
   protected int logicalOp;
   protected SearchPredicate predicate;
   public final static int NONE = 0;
   public final static int AND = 1;
   public final static int OR = 2;
   public final static int NOT = 3;

   public Operator() {
      logicalOp = NONE;
   }

   // ---------------------- setters --------------
   public void setLogicalOp(int newLogicalOp) {
      this.logicalOp = newLogicalOp;
   }

   public void setPredicate(SearchPredicate predicate) {
      this.predicate = predicate;
   }

   // ---------------------- getters --------------
   public int getLogicalOp() {
      return this.logicalOp;
   }

   public SearchPredicate getPredicate() {
      return predicate;
   }

   public boolean isComposite() {
      return false;
   }

   /**
    * 
    * @return true if the operator tree does not have any search predicates
    */
   public abstract boolean isEmpty();

   /**
    * Accepts a visitor object. for the Visitor design pattern.
    * 
    * @param visitor
    */
   public abstract void accept(ISearchCriteriaVisitor visitor) throws Exception;
}
