package clinical.web.common.query;

import java.util.List;

import clinical.web.vo.SubjectAsScoreValueSummary;
import clinical.web.vo.SubjectDerivedDataValueSummary;

/**
 * Encapsulates clinical assessment and derived data results.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ParallelQueryResult.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class ParallelQueryResult {
	protected List<SubjectAsScoreValueSummary> summaryList;
	protected List<SubjectDerivedDataValueSummary> derivedDataSummaryList;

	public ParallelQueryResult(List<SubjectAsScoreValueSummary> summaryList,
			List<SubjectDerivedDataValueSummary> derivedDataSummaryList) {
		this.summaryList = summaryList;
		this.derivedDataSummaryList = derivedDataSummaryList;
	}

	public List<SubjectAsScoreValueSummary> getSummaryList() {
		return summaryList;
	}

	public List<SubjectDerivedDataValueSummary> getDerivedDataSummaryList() {
		return derivedDataSummaryList;
	}

}