package clinical.web.common.query;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SQLTokens.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public interface SQLTokens {
   public final static int PERIOD = 1;
   public final static int COMMA = 2;
   public final static int SEMICOLON = 3;
   public final static int STAR = 4;
   public final static int SLASH = 5;
   public final static int PLUS = 6;
   public final static int MINUS = 7;
   public final static int LEFT_PAREN = 8;
   public final static int RIGHT_PAREN = 9;
   public final static int PERCENT = 10;
   public final static int GREATER = 11;
   public final static int LESS = 12;
   public final static int EQUAL = 13;
   public final static int NOT_EQUAL = 14;
   public final static int GE = 15;
   public final static int LE = 16;
   public final static int QUOTE = 17;


   public final static int SELECT = 100;
   public final static int FROM = 101;
   public final static int WHERE = 102;
   public final static int AND = 103;
   public final static int OR = 104;
   public final static int LIKE = 105;
   public final static int ORDER = 106;
   public final static int BY = 107;
   public final static int ASC = 108;
   public final static int DESC = 109;
   public final static int GROUP = 110;
   public final static int HAVING = 111;
   public final static int NULL = 112;
   public final static int IS = 113;
   public final static int NOT = 114;
   public final static int IN = 115;
   public final static int AS = 116;
   public final static int DISTINCT = 117;
   public final static int ALL = 118;
   public final static int MAX = 119;
   public final static int MIN = 120;
   public final static int AVG = 121;
   public final static int COUNT = 122;
   public final static int SUM = 123;


   public final static int NUMBER = 1000;
   public final static int IDENTIFIER = 1001;
   public final static int KEYWORD = 1002;
   public final static int SPECIAL_CHAR = 1003;
   public final static int STRING = 1004;
   public final static int EOS = 2000;


   // string functions
   public final static int ENDSWITH = 5000;
}
