package clinical.web.common.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DBConfig.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DBConfig {
	protected String id;
	protected String dbURL;
	protected boolean forceSchemaOwnerCheck = false;
	/** database type */
	protected String dbType;
	protected Map<String, User> userMap;
	protected Map<String, User> dbUserMap;
	protected boolean defaultDB;
	protected String siteID;
	protected String siteName;
	protected String siteURL;

	public final static String ORACLE = "oracle";
	public final static String POSTGRES = "postgres";

	public DBConfig(String id, String siteName, String siteID) {
		this.id = id;
		this.siteName = siteName;
		this.siteID = siteID;
		userMap = Collections.synchronizedMap(new LinkedHashMap<String, User>(17));
		dbUserMap = Collections.synchronizedMap(new LinkedHashMap<String, User>(17));
	}

	public User findDBUser(String userName) {
		return dbUserMap.get(userName);
	}

	public User findUser(String userName) {
		return userMap.get(userName);
	}

	public void removeUser(User webUser) {
		userMap.remove(webUser.getName());
	}

	public void removeDBUser(User dbUser) {
		dbUserMap.remove(dbUser.getName());
	}

	public void setDbURL(String newDbURL) {
		this.dbURL = newDbURL;
	}

	public void setDefaultDB(boolean newDefaultDB) {
		this.defaultDB = newDefaultDB;
	}

	public void setDbType(String newDbType) {
		this.dbType = newDbType;
	}

	public void setForceSchemaOwnerCheck(boolean newForceSchemaOwnerCheck) {
		this.forceSchemaOwnerCheck = newForceSchemaOwnerCheck;
	}

	public String getId() {
		return this.id;
	}

	public String getDbURL() {
		return this.dbURL;
	}

	public boolean isDefaultDB() {
		return this.defaultDB;
	}

	public String getDbType() {
		return this.dbType;
	}

	public boolean getForceSchemaOwnerCheck() {
		return this.forceSchemaOwnerCheck;
	}

	public void addUser(User user) {
		userMap.put(user.getName(), user);
	}

	public void addDbUser(User dbUser) {
		dbUserMap.put(dbUser.getName(), dbUser);
	}

	public User getDBUser(String dbUserName) {
		return dbUserMap.get(dbUserName);
	}

	public synchronized User removeDBUser(String dbUserName) {
		User dbUser = dbUserMap.remove(dbUserName);
		if ( dbUser != null) {
			List<User> webUsers = getWebUsersForDBUser(dbUser);
			for (User webUser : webUsers) {
				userMap.remove(webUser.getName());
			}
		}
		return dbUser;
	}

	public User getUser(String userName) {
		return userMap.get(userName);
	}


	public User removeUser(String userName) {
		return userMap.remove(userName);
	}

	public Map<String, User> getUserMap() {
		return userMap;
	}

	public Map<String, User> getDBUserMap() {
		return dbUserMap;
	}

	public List<User> listWebUsers() {
		return new ArrayList<User>(userMap.values());
	}

	public List<User> listDBUsers() {
		return new ArrayList<User>(dbUserMap.values());
	}

	public Map<String, User> getDbUserMap() {
		return dbUserMap;
	}

	public List<User> getDbUsers() {
		return new ArrayList<User>( dbUserMap.values());
	}

	public List<User> getWebUsers() {
		return new ArrayList<User>( userMap.values());
	}


	public List<User> getWebUsersForDBUser(User dbUser) {
		List<User> webUsers = new ArrayList<User>(5);
		for (User user : userMap.values()) {
			User dbu = user.getDbUser();
			if ( dbu.getName().equals( dbUser.getName())) {
				webUsers.add(user);
			}
		}
		return webUsers;
	}

	public String getSiteID() {
		return siteID;
	}

	public String getSiteName() {
		return siteName;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("DBConfig::[");
		buf.append("id=").append(id);
		buf.append(",dbType=").append(dbType);
		buf.append(",siteID=").append(siteID);
		buf.append(",siteName=").append(siteName);

		buf.append(']');
		return buf.toString();
	}

	public String getSiteURL() {
		return siteURL;
	}

	public void setSiteURL(String siteURL) {
		this.siteURL = siteURL;
	}


}
