package clinical.web.common.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: User.java 873 2015-01-07 20:55:20Z jinranc $
 */

public class User {
	protected String name;
	protected String pwd;
	protected boolean useGSI = false;
	
	//JC added
	protected String firstName;
	protected String lastName;
	protected String email;

	protected User dbUser;
	protected Map<String, Privilege> fullPrivilegesMap = new LinkedHashMap<String, Privilege>(
			7);
	protected Map<String, String> availableTables = new HashMap<String, String>();
	protected Map<String, Privilege> privilegeMap = Collections
			.synchronizedMap(new LinkedHashMap<String, Privilege>(7));

	public User(String name, String pwd) {
		this.name = name;
		this.pwd = pwd;
	}
	
	public User(String name, String pwd, boolean useGSI) {
		this(name, pwd);
		this.useGSI = useGSI;
	}

	public String getName() {
		return this.name;
	}

	public String getPwd() {
		return this.pwd;
	}

	public void setPwd(String pwd) {
		this.pwd = pwd;
	}

	public User getDbUser() {
		return this.dbUser;
	}

	public void setDbUser(User dbUser) {
		this.dbUser = dbUser;
	}

	public int hashCode() {
		return name.hashCode();
	}

	public boolean equals(Object other) {
		if (other == null || !(other instanceof User))
			return false;
		return name.equals(((User) other).name);
	}

	public void addAvailableTable(String tableName) {
		availableTables.put(tableName, tableName);
	}

	public Map<String, String> getAvailableTables() {
		return availableTables;
	}

	public synchronized void addPrivilege(Privilege privilege) {
		privilegeMap.put(privilege.getName(), privilege);
	}

	public synchronized void removePrivilege(String privName) {
		privilegeMap.remove(privName);
	}

	public List<Privilege> listPrivileges() {
		return new ArrayList<Privilege>(privilegeMap.values());
	}

	public List<Privilege> getPrivileges() {
		return new ArrayList<Privilege>(privilegeMap.values());
	}

	public boolean hasPrivilege(String privName) {
		return privilegeMap.get(privName) != null;
	}

	public int getNumOfPrivileges() {
		return privilegeMap.size();
	}

	public Map<String, Privilege> getFullPrivilegesMap() {
		return fullPrivilegesMap;
	}

	public void setFullPrivilegesMap(Map<String, Privilege> fullPrivilegesMap) {
		this.fullPrivilegesMap = fullPrivilegesMap;
	}

	public List<Privilege> getMissingPrivileges() {
		if (privilegeMap.size() == fullPrivilegesMap.size()) {
			return new ArrayList<Privilege>(0);
		}
		List<Privilege> list = new ArrayList<Privilege>(fullPrivilegesMap
				.size());
		for (String privName : fullPrivilegesMap.keySet()) {
			if (!privilegeMap.containsKey(privName)) {
				list.add(fullPrivilegesMap.get(privName));
			}
		}
		return list;
	}

	public boolean isSame(User other) {
		if (other == null)
			return false;
		boolean ok = true;
		ok = name.equals(other.name) && pwd.equals(other.pwd);
		if (!ok)
			return false;
		if (dbUser != null) {
			return dbUser.isSame(other.dbUser);
		}
		return ok;
	}

	public boolean isUseGSI() {
		return useGSI;
	}
	
	public void setUseGSI(boolean useGSI) {
		this.useGSI = useGSI;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(104);
		buf.append("User::[");
		buf.append("name=").append(name);
		buf.append(", dbUser=").append(dbUser);
		buf.append(']');
		return buf.toString();
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

}
