package clinical.web.common.vo;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.jdom.Element;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.GenUtils;
import clinical.web.helpers.AssessmentSelectionInfoHelper;

/**
 * 
 * @version $Id: AsScoreInfo.java 873 2015-01-07 20:55:20Z jinranc $
 * @author I. Burak Ozyurt
 */

public class AsScoreInfo implements java.io.Serializable {
	private static final long serialVersionUID = 2045278183691962975L;
	private String name;
	private String description;
	private String type;
	private boolean selected;
	private BigDecimal assessmentID;
	/** score Level for hierarchy */
	private int level;
	private boolean collapsed;
	private int sequence;
	private String parentScore;
	private List<AsScoreInfo> children = new LinkedList<AsScoreInfo>();
	/** used by persistent queries */
	private String rhsValue;
	private Integer operatorCode;
	private String leadingtext; //Jinran added
	
	private String connector;//Jinran added
	private String lowBound;//Jinran added
	private String uppBound;//Jinran added
	private String order;//Jinran added. the order to display in webpage when load query
	
	
	public AsScoreInfo(BigDecimal assessmentID) {
		this.assessmentID = assessmentID;
	}

	public AsScoreInfo(AsScoreInfo other, boolean deepCopy) {
		this.assessmentID = other.assessmentID;
		this.name = other.name;
		this.description = other.description;
		this.type = other.type;
		this.selected = other.selected;
		this.level = other.level;
		this.collapsed = other.collapsed;
		this.sequence = other.sequence;
		this.parentScore = other.parentScore;
		for (Iterator<AsScoreInfo> iter = other.children.iterator(); iter
				.hasNext();) {
			AsScoreInfo child = iter.next();
			if (deepCopy) {
				this.addChild(new AsScoreInfo(child, deepCopy));
			} else {
				this.addChild(child);
			}
		}
	}

	// ---------------------- setters --------------
	public void setName(String newName) {
		this.name = newName;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	public void setType(String newType) {
		this.type = newType;
	}

	public void setSelected(boolean newSelected) {
		this.selected = newSelected;
	}

	public void setAssessmentID(BigDecimal newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setParentScore(String newParentScore) {
		this.parentScore = newParentScore;
	}

	public void setLevel(int newLevel) {
		this.level = newLevel;
	}

	public void setCollapsed(boolean newCollapsed) {
		this.collapsed = newCollapsed;
	}

	public void setSequence(int newSequence) {
		this.sequence = newSequence;
	}

	// ---------------------- getters --------------
	public String getName() {
		return this.name;
	}

	public String getDescription() {
		return this.description;
	}

	public String getType() {
		return this.type;
	}

	public boolean isSelected() {
		return this.selected;
	}

	public BigDecimal getAssessmentID() {
		return this.assessmentID;
	}

	public String getParentScore() {
		return this.parentScore;
	}

	public int getLevel() {
		return this.level;
	}

	public boolean getCollapsed() {
		return this.collapsed;
	}

	public int getSequence() {
		return this.sequence;
	}

	public List<AsScoreInfo> getChildren() {
		return children;
	}

	public void addChild(AsScoreInfo child) {
		children.add(child);
	}

	public String getIndent() {
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < this.level; i++) {
			buf.append("&nbsp; &nbsp; &nbsp;");
		}
		return buf.toString();
	}

	public String getButtonForJSP(int asIdx, int scoreIdx) {
		if (getChildren().isEmpty()) {
			return "";
		}
		StringBuffer buf = new StringBuffer();
		String key = asIdx + "_" + scoreIdx;
		String buttonLabel = getCollapsed() ? "Expand" : "Collapse";
		buf.append("<input type=\"submit\" value=\"").append(buttonLabel)
				.append("\" class=\"submit-button\"  onclick=\"go2(this,'");
		buf.append(buttonLabel).append("','").append(key).append("')\">");
		return buf.toString();
	}

	public void expand() {
		setCollapsedValueForAllChildren(this, false);
	}

	public void collapse() {
		setCollapsedValueForAllChildren(this, true);
	}

	protected void setCollapsedValueForAllChildren(AsScoreInfo parent,
			boolean value) {
		parent.setCollapsed(value);
		for (Iterator<AsScoreInfo> iter = parent.getChildren().iterator(); iter
				.hasNext();) {
			AsScoreInfo child = iter.next();
			setCollapsedValueForAllChildren(child, value);
		}
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {
		js.put("name", name);
		js.put("type", type);
		js.put("leadingtext", leadingtext);
		js.put("sequence", sequence);
		if (selected)
			js.put("selected", selected);
		if (description != null)
			js.put("desc", description);
		// used for persistent queries
		if (rhsValue != null)
			js.put("rhs", rhsValue);
		if ( operatorCode != null)
			js.put("operator", operatorCode);
		
		
		//Jinran added
		if(connector!=null)
			js.put("connector", connector);
		if(lowBound!=null)
			js.put("lowBound", lowBound);
		if(uppBound!=null)
			js.put("uppBound", uppBound);
		if (order!=null)
			js.put("order", order);
		
		
		return js;
	}

	public static AsScoreInfo initializeFromJSON(int assessmentID, JSONObject js)
			throws JSONException {
		AsScoreInfo si = new AsScoreInfo(new BigDecimal(assessmentID));
		si.name = js.getString("name");
		si.type = js.getString("type");
		if (js.has("selected"))
			si.selected = js.getBoolean("selected");
		
		//Jinran added
		if (js.has("order")){
			si.order = js.getString("order");
		}
		
		return si;
	}

	public Element toXML() {
		Element elem = new Element("score-info");
		elem.setAttribute("name", name);
		elem.setAttribute("type", type);
		elem.setAttribute("selected", String.valueOf(selected));
		if (description != null) {
			Element e = new Element("description");
			e.addContent(description);
			elem.addContent(e);
		}
		return elem;
	}

	public static AsScoreInfo initializeFromXML(Element elem,
			BigDecimal assessmentID) {
		AsScoreInfo asi = new AsScoreInfo(assessmentID);
		asi.setName(elem.getAttributeValue("name"));
		asi.setSelected(GenUtils.toBoolean(elem.getAttributeValue("selected"),
				false));
		return asi;
	}

	public static AsScoreInfo initializeFromXML(Element elem,
			AssessmentSelectionInfoHelper helper, AssessmentSelectionInfo asi)
			throws Exception {
		String name = elem.getAttributeValue("name");
		AsScoreInfo si = helper.findAsScoreInfo(asi.getAssessmentID(), name);
		si.setSelected(GenUtils.toBoolean(elem.getAttributeValue("selected"),
				false));

		return si;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(176);
		buf.append("AsScoreInfo::[");
		buf.append("name=").append(name);
		buf.append(", description=").append(description);
		buf.append(", type=").append(type);
		buf.append(", selected=").append(selected);
		buf.append(", assessmentID=").append(assessmentID);
		buf.append(", parentScore=").append(parentScore);
		buf.append(']');
		return buf.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((assessmentID == null) ? 0 : assessmentID.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AsScoreInfo other = (AsScoreInfo) obj;
		if (assessmentID == null) {
			if (other.assessmentID != null)
				return false;
		} else if (!assessmentID.equals(other.assessmentID))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	public String getRhsValue() {
		return rhsValue;
	}

	public void setRhsValue(String rhsValue) {
		this.rhsValue = rhsValue;
	}

	public Integer getOperatorCode() {
		return operatorCode;
	}

	public void setOperatorCode(Integer operatorCode) {
		this.operatorCode = operatorCode;
	}

	//Jinran added
	public void setConnector(String connect) {
		this.connector = connect;
	}

	public String getConnector() {
		return connector;
	}

	public void setLowBound(String lowBound) {
		this.lowBound = lowBound;
	}

	public String getLowBound() {
		return lowBound;
	}

	public void setUpBound(String upBound) {
		this.uppBound = upBound;
	}

	public String getUpBound() {
		return uppBound;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public String getOrder() {
		return order;
	}

	public void setLeadingtext(String leadingtext) {
		this.leadingtext = leadingtext;
	}

	public String getLeadingtext() {
		return leadingtext;
	}

}
