package clinical.web.download;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.utils.FileUtils;
import clinical.web.common.UserInfo;
import clinical.web.helpers.EmailHelper;
import clinical.web.scheduler.JobException;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ProjectDownloadJob.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class ProjectDownloadJob extends AbstractJob {
	protected FileBundleConfig config;
	protected EmailHelper emailHelper;

	private Log log = LogFactory.getLog(ProjectDownloadJob.class);

	public ProjectDownloadJob(String id, UserInfo ui, String description,
			FileBundleConfig config, String dbID) {
		super(id, ui, description, dbID);
		this.config = config;
	}

	public void execute() throws JobException {
		// Assumption: no srb files
		List<PathWrapper> files = new ArrayList<PathWrapper>(config
				.getFileInfoList().size());
		for (FileInfo fi : config.getFileInfoList()) {
			files.add(new PathWrapper(fi.getRelativePath(), fi
					.getSourceRootDir()));
		}
		Packager packager = new Packager(config.getCacheDir(), config
				.getBundleName(), config.getAction());
		packager.includeFiles(files);

		packager.setDoCleanup(false);
		if (isCanceled()) {
			log.info("Canceling job " + getID());
			cleanupCache(getID(), log);
			return;
		}
		packager.pack();
		if (isCanceled()) {
			log.info("Canceling job " + getID());
			cleanupCache(getID(), log);
			return;
		}
		handleEmail(".\nYou can download it at your convenience by login to the HID web application.");
	}

	protected void handleEmail(String status) {
		if (emailHelper == null)
			return;
		Map<String, String> paramMap = new HashMap<String, String>(7);
		String client = emailHelper.getToUser();
		int idx = client.indexOf('@');
		if (idx != -1) {
			client = client.substring(0, idx);
		}

		paramMap.put("subject",
				"your image download bundle is ready for download!");
		paramMap.put("client", client);
		paramMap.put("job_type", "archived image download job");
		paramMap.put("jobid", getID());
		paramMap.put("status", status);
		try {
			emailHelper.sendEmail(paramMap);
		} catch (Throwable t) {
			log.error("ProjectDownloadJob", t);
		}

	}

	public String[] getResultsFiles() {
		String filename = config.getBundleName();
		if (!filename.endsWith(".tar")) {
			filename += ".tar";
		}
		String path = FileUtils.createFullPath(config.getCacheDir(), filename);
		String[] rfArr = new String[] { path };
		return rfArr;
	}

	public String getType() {
		return "Image Download";
	}

	public void saveResults(File file) throws JobException {
		// no op
	}

	public EmailHelper getEmailHelper() {
		return emailHelper;
	}

	public void setEmailHelper(EmailHelper emailHelper) {
		this.emailHelper = emailHelper;
	}

	@Override
	public String getFileType() {
		// TODO Auto-generated method stub
		return null;
	}

}
