package clinical.web.forms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;
import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Researchgroup;
import clinical.web.helpers.StringListSelector;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AppConfigForm.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class AppConfigForm extends ActionForm {	
	private String curGroupName;

	private String fbirnDbid;
	private String mediatorMappingFile;
	private String fbirnUsersFile;
	private String connectionPoolShowStats;
	private String queryonlyOperation;
	private String mediatorSchemaName;
	private String allowMriDownload;
	private String allowFbirnImageDownload;
	private String minNeededMajorVersion;
	private String minNeededMinorVersion;
	private String maxNeededMajorVersion;
	private String maxNeededMinorVersion;
	private String schemaVersionCheck;
	private String downloadCacheroot;
	private StringListSelector objectTypesSelector;
	private List<String> objectTypes = new ArrayList<String>(2);
	private String publicModeLogin;
	private String emailHost;
	private String emailUser;
	private String emailPwd;
	private String emailFrom;
	private String storageType;
	
	private String globusMyproxyServerPrimary;
	private String globusMyproxyServerPort;
	private String globusGridftpServerPort;
	private String globusRlsServerUrlPrimary;
	private String globusSecurityEnabled;
	private String globusMasterGridftpServer;
		
	private Map<String,String> fieldHelpMap;

	private String[] groupNames = new String[] {"General","Mediation","Web Services", "Advanced", "Visit Type", "Research Group", "Protocols"};

	private static final long serialVersionUID = -8696997368897300162L;

	//added for clinical setup
	private String visitType;
	private String visitTypeDesc;
	private Collection<LabelValueBean> visitTypes = new ArrayList<LabelValueBean>();
	private BigDecimal[] selVisitTypes;
	
	private String researchGroupType;
	private String researchGroupTypeDesc;
	private Collection<LabelValueBean> researchGroupTypes = new ArrayList<LabelValueBean>();
	private BigDecimal[] selResearchGroupTypes;
	
	private ArrayList<BigDecimal> researchGroupTypeIds;
	
	// for adding new protocols
	private String protocolVersion;
	private String protocolId;
	private String protocolName;
	private String protocolDesc;
	
	public String getFbirnDbid() {
		return fbirnDbid;
	}

	public String getMediatorMappingFile() {
		return mediatorMappingFile;
	}

	public String getFbirnUsersFile() {
		return fbirnUsersFile;
	}

	public String getConnectionPoolShowStats() {
		return connectionPoolShowStats;
	}

	public String getQueryonlyOperation() {
		return queryonlyOperation;
	}

	public String getMediatorSchemaName() {
		return mediatorSchemaName;
	}

	public String getAllowMriDownload() {
		return allowMriDownload;
	}

	public String getAllowFbirnImageDownload() {
		return allowFbirnImageDownload;
	}

	public String getMinNeededMajorVersion() {
		return minNeededMajorVersion;
	}

	public String getMinNeededMinorVersion() {
		return minNeededMinorVersion;
	}

	public String getMaxNeededMajorVersion() {
		return maxNeededMajorVersion;
	}

	public String getMaxNeededMinorVersion() {
		return maxNeededMinorVersion;
	}

	public String getSchemaVersionCheck() {
		return schemaVersionCheck;
	}

	public String getDownloadCacheroot() {
		return downloadCacheroot;
	}

	public StringListSelector getObjectTypesSelector() {
		return objectTypesSelector;
	}

	public List<String> getObjectTypes() {
		return objectTypes;
	}

	public String getPublicModeLogin() {
		return publicModeLogin;
	}

	public String getEmailHost() {
		return emailHost;
	}

	public String getEmailUser() {
		return emailUser;
	}

	public String getEmailPwd() {
		return emailPwd;
	}

	public String getEmailFrom() {
		return emailFrom;
	}

	public void setFbirnDbid(String fbirnDbid) {
		this.fbirnDbid = fbirnDbid;
	}

	public void setMediatorMappingFile(String mediatorMappingFile) {
		this.mediatorMappingFile = mediatorMappingFile;
	}

	public void setFbirnUsersFile(String fbirnUsersFile) {
		this.fbirnUsersFile = fbirnUsersFile;
	}

	public void setConnectionPoolShowStats(String connectionPoolShowStats) {
		this.connectionPoolShowStats = connectionPoolShowStats;
	}

	public void setQueryonlyOperation(String queryonlyOperation) {
		this.queryonlyOperation = queryonlyOperation;
	}

	public void setMediatorSchemaName(String mediatorSchemaName) {
		this.mediatorSchemaName = mediatorSchemaName;
	}

	public void setAllowMriDownload(String allowMriDownload) {
		this.allowMriDownload = allowMriDownload;
	}

	public void setAllowFbirnImageDownload(String allowFbirnImageDownload) {
		this.allowFbirnImageDownload = allowFbirnImageDownload;
	}

	public void setMinNeededMajorVersion(String minNeededMajorVersion) {
		this.minNeededMajorVersion = minNeededMajorVersion;
	}

	public void setMinNeededMinorVersion(String minNeededMinorVersion) {
		this.minNeededMinorVersion = minNeededMinorVersion;
	}

	public void setMaxNeededMajorVersion(String maxNeededMajorVersion) {
		this.maxNeededMajorVersion = maxNeededMajorVersion;
	}

	public void setMaxNeededMinorVersion(String maxNeededMinorVersion) {
		this.maxNeededMinorVersion = maxNeededMinorVersion;
	}

	public void setSchemaVersionCheck(String schemaVersionCheck) {
		this.schemaVersionCheck = schemaVersionCheck;
	}

	public void setDownloadCacheroot(String downloadCacheroot) {
		this.downloadCacheroot = downloadCacheroot;
	}

	public void setObjectTypesSelector(StringListSelector objectTypesSelector) {
		this.objectTypesSelector = objectTypesSelector;
	}

	public void setObjectTypes(List<String> objectTypes) {
		this.objectTypes = objectTypes;
	}

	public void setPublicModeLogin(String publicModeLogin) {
		this.publicModeLogin = publicModeLogin;
	}

	public void setEmailHost(String emailHost) {
		this.emailHost = emailHost;
	}

	public void setEmailUser(String emailUser) {
		this.emailUser = emailUser;
	}

	public void setEmailPwd(String emailPwd) {
		this.emailPwd = emailPwd;
	}

	public void setEmailFrom(String emailFrom) {
		this.emailFrom = emailFrom;
	}

	public String getStorageType() {
		return storageType;
	}

	public void setStorageType(String storageType) {
		this.storageType = storageType;
	}

	public String getCurGroupName() {
		return curGroupName;
	}

	public void setCurGroupName(String curGroupName) {
		this.curGroupName = curGroupName;
	}

	public String[] getGroupNames() {
		return groupNames;
	}

	public Map<String, String> getFieldHelpMap() {
		return fieldHelpMap;
	}

	public void setFieldHelpMap(Map<String, String> fieldHelpMap) {
		this.fieldHelpMap = fieldHelpMap;
	}

	public String getGlobusMyproxyServerPrimary() {
		return globusMyproxyServerPrimary;
	}

	public void setGlobusMyproxyServerPrimary(String globusMyproxyServerPrimary) {
		this.globusMyproxyServerPrimary = globusMyproxyServerPrimary;
	}

	public String getGlobusMyproxyServerPort() {
		return globusMyproxyServerPort;
	}

	public void setGlobusMyproxyServerPort(String globusMyproxyServerPort) {
		this.globusMyproxyServerPort = globusMyproxyServerPort;
	}

	public String getGlobusGridftpServerPort() {
		return globusGridftpServerPort;
	}

	public void setGlobusGridftpServerPort(String globusGridftpServerPort) {
		this.globusGridftpServerPort = globusGridftpServerPort;
	}

	public String getGlobusRlsServerUrlPrimary() {
		return globusRlsServerUrlPrimary;
	}

	public void setGlobusRlsServerUrlPrimary(String globusRlsServerUrlPrimary) {
		this.globusRlsServerUrlPrimary = globusRlsServerUrlPrimary;
	}

	public String getGlobusSecurityEnabled() {
		return globusSecurityEnabled;
	}

	public void setGlobusSecurityEnabled(String globusSecurityEnabled) {
		this.globusSecurityEnabled = globusSecurityEnabled;
	}

	public String getGlobusMasterGridftpServer() {
		return globusMasterGridftpServer;
	}

	public void setGlobusMasterGridftpServer(String globusMasterGridftpServer) {
		this.globusMasterGridftpServer = globusMasterGridftpServer;
	}

	public void setVisitType(String visitType) {
		this.visitType = visitType;
	}

	public String getVisitType() {
		return visitType;
	}

	public void setVisitTypeDesc(String visitTypeDesc) {
		this.visitTypeDesc = visitTypeDesc;
	}

	public String getVisitTypeDesc() {
		return visitTypeDesc;
	}

	public void setVisitTypes(Collection<LabelValueBean> visitTypes) {
		this.visitTypes = visitTypes;
	}

	public Collection<LabelValueBean> getVisitTypes() {
		return visitTypes;
	}

	public void setSelVisitTypes(BigDecimal[] selVisitTypes) {
		this.selVisitTypes = selVisitTypes;
	}

	public BigDecimal[] getSelVisitTypes() {
		return selVisitTypes;
	}

	public void setResearchGroupType(String researchGroupType) {
		this.researchGroupType = researchGroupType;
	}

	public String getResearchGroupType() {
		return researchGroupType;
	}

	public void setResearchGroupTypeDesc(String researchGroupTypeDesc) {
		this.researchGroupTypeDesc = researchGroupTypeDesc;
	}

	public String getResearchGroupTypeDesc() {
		return researchGroupTypeDesc;
	}

	public void setResearchGroupTypes(Collection<LabelValueBean> researchGroupTypes) {
		this.researchGroupTypes = researchGroupTypes;
	}

	public Collection<LabelValueBean> getResearchGroupTypes() {
		return researchGroupTypes;
	}

	public void setSelResearchGroupTypes(BigDecimal[] selResearchGroupTypes) {
		this.selResearchGroupTypes = selResearchGroupTypes;
	}

	public BigDecimal[] getSelResearchGroupTypes() {
		return selResearchGroupTypes;
	}

	public void setResearchGroupTypeIds(ArrayList<BigDecimal> researchGroupTypeIds) {
		this.researchGroupTypeIds = researchGroupTypeIds;
	}

	public ArrayList<BigDecimal> getResearchGroupTypeIds() {
		return researchGroupTypeIds;
	}

	public void setProtocolVersion(String protocolVersion) {
		this.protocolVersion = protocolVersion;
	}

	public String getProtocolVersion() {
		return protocolVersion;
	}

	public void setProtocolId(String protocolId) {
		this.protocolId = protocolId;
	}

	public String getProtocolId() {
		return protocolId;
	}

	public void setProtocolName(String protocolName) {
		this.protocolName = protocolName;
	}

	public String getProtocolName() {
		return protocolName;
	}

	public void setProtocolDesc(String protocolDesc) {
		this.protocolDesc = protocolDesc;
	}

	public String getProtocolDesc() {
		return protocolDesc;
	}


}
