package clinical.web.forms;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.struts.action.ActionForm;

import clinical.web.Constants;
import clinical.web.common.vo.AssessmentSelectionInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BatchQueryForm.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class BatchQueryForm extends ActionForm {
	private static final long serialVersionUID = -8838744278768027286L;
	protected List<AssessmentSelectionInfo> asiList;
	protected String queryReminder;
	protected Set<String> jobIDSet = new HashSet<String>();

	//Jinran added
	private String longFormat = "long";	
	private String isValidated = Constants.IsValidated;
	private boolean batchQueryAll = true;
		
	public BatchQueryForm() {
		super();
	}

	public void addJobID(String jobID) {
		jobIDSet.add(jobID);
	}

	public List<AssessmentSelectionInfo> getAsiList() {
		return asiList;
	}

	public void setAsiList(List<AssessmentSelectionInfo> asiList) {
		this.asiList = asiList;
	}

	/**
	 * indexed property
	 * 
	 * @param idx
	 * @return
	 */
	public AssessmentSelectionInfo getAsi(int idx) {
		if (idx > asiList.size())
			return null;
		return asiList.get(idx);
	}

	public String getQueryReminder() {
		return queryReminder;
	}

	public void setQueryReminder(String queryReminder) {
		this.queryReminder = queryReminder;
	}


	public Set<String> getJobIDSet() {
		return jobIDSet;
	}


	//Jinran added
	public void setLongFormat(String longFormat) {
		this.longFormat = longFormat;
	}

	public String getLongFormat() {
		return longFormat;
	}

	public void setIsValidated(String isValidated) {
		this.isValidated = isValidated;
	}

	public String getIsValidated() {
		return isValidated;
	}

	public void setBatchQueryAll(boolean batchQueryAll) {
		this.batchQueryAll = batchQueryAll;
	}

	public boolean isBatchQueryAll() {
		return batchQueryAll;
	}

}
