package clinical.web.forms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;
import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Subjexperiment;
import clinical.web.helpers.StorageTypeSelector;
import clinical.web.vo.ExperimentInfo;
import clinical.web.vo.StudyGroupInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentManagementForm.java,v 1.6 2006/05/02 01:03:18 bozyurt
 *          Exp $
 */
public class ExperimentManagementForm extends ActionForm {
	private static final long serialVersionUID = 3161267175239638282L;
	/** the current experiment displayed */
	protected ExperimentInfo experimentInfo;
	protected List<String> studyGroups;
	protected List<Subjexperiment> enrolledSubjects;
	/** collection of LabelValue beans used to list the enrolled subjects */
	protected List<LabelValueBean> enrolledSubjectLVBeans = new LinkedList<LabelValueBean>();
	protected String enrolledSubjectValue;
	protected List<LabelValueBean> studyGroupLVBeans = new LinkedList<LabelValueBean>();
	/** holds the user selected study group value */
	protected String studyGroupValue;
	protected boolean addingNewSubject = false;
	/** holds the experiment label value pairs */
	protected List<LabelValueBean> experimentLVBeans;
	/** holds the user selected experiments ID */
	protected String selectedExperimentValue;
	/** holds the subjects that are not enrolled with the experiment */
	protected List<LabelValueBean> availableSubjectLVBeans;
	/** the selected subject to be enrolled with this experiment */
	protected String availableSubjectValue;
	protected List<LabelValueBean> availableStudyGroupLVBeans;
	/** */
	protected String availableStudyGroupValue;
	/** study group info object for the currently edited/added Study Group. */
	protected StudyGroupInfo studyGroupInfo;
	
	protected StorageTypeSelector storageTypeSelector;

	public ExperimentManagementForm() {
	}

	public ExperimentInfo getExperimentInfo() {
		return experimentInfo;
	}

	public void setExperimentInfo(ExperimentInfo newExp) {
		this.experimentInfo = newExp;
	}

	public void setStudyGroups(List<String> studyGroups) {
		this.studyGroups = studyGroups;
		studyGroupLVBeans = new ArrayList<LabelValueBean>(studyGroups.size());
		for (String label : studyGroups) {
			int idx = label.indexOf(' ');
			String value = label.substring(0, idx); // first token is the study
			// group id
			label = label.substring(idx + 1);
			LabelValueBean lvb = new LabelValueBean(label, value);
			studyGroupLVBeans.add(lvb);
		}
	}

	/**
	 * 
	 * @param studyGroups
	 *            a list of {@link Researchgroup} objects
	 */
	public void setStudyGroupsToSelect(List<Researchgroup> studyGroups) {
		studyGroupLVBeans.clear();
		for (Researchgroup rg : studyGroups) {
			LabelValueBean lvb = new LabelValueBean(rg.getName(), rg
					.getUniqueid().toString());
			studyGroupLVBeans.add(lvb);
		}
	}

	public List<String> getStudyGroups() {
		return studyGroups;
	}

	public List<Subjexperiment> getEnrolledSubjects() {
		return enrolledSubjects;
	}

	/**
	 * Given a list of enrolled subjects and a hash table of
	 * subject counts as <code>Integer</code> objects keyed by the
	 * <code>Researchgroup</code> object, creates the data structures for the
	 * enrolled subject list viewed on the browser.
	 * 
	 * @param enrolledSubjects
	 *            a list of {@link Subjexperiment} objects
	 * @param researchGroupMap
	 */
	public void setEnrolledSubjects(List<Subjexperiment> enrolledSubjects,
			Map<Researchgroup, Integer> researchGroupMap) {
		this.enrolledSubjects = enrolledSubjects;
		enrolledSubjectLVBeans.clear();

		Map<BigDecimal, Researchgroup> researchGroupIDMap = new HashMap<BigDecimal, Researchgroup>(
				11);
		for (Researchgroup rg : researchGroupMap.keySet()) {
			researchGroupIDMap.put(rg.getUniqueid(), rg);
		}

		for (Iterator<Subjexperiment> iter = enrolledSubjects.iterator(); iter
				.hasNext();) {
			Subjexperiment se = iter.next();
			StringBuffer buf = new StringBuffer(64);
			Researchgroup rg = researchGroupIDMap.get(se
					.getNcResearchgroupUniqueid());
			buf.append(se.getSubjectid()).append("  (").append(rg.getName())
					.append(')');
			LabelValueBean lvb = new LabelValueBean(buf.toString(), se
					.getSubjectid());
			enrolledSubjectLVBeans.add(lvb);
		}
	}

	public Collection<LabelValueBean> getEnrolledSubjectLVBeans() {
		return enrolledSubjectLVBeans;
	}

	public void setEnrolledSubjectValue(String newEnrolledSubjectValue) {
		this.enrolledSubjectValue = newEnrolledSubjectValue;
	}

	public String getEnrolledSubjectValue() {
		return this.enrolledSubjectValue;
	}

	public Collection<LabelValueBean> getStudyGroupLVBeans() {
		return studyGroupLVBeans;
	}

	public void setStudyGroupValue(String newStudyGroupValue) {
		this.studyGroupValue = newStudyGroupValue;
	}

	public String getStudyGroupValue() {
		return this.studyGroupValue;
	}

	public void setAddingNewSubject(boolean newAddingNewSubject) {
		this.addingNewSubject = newAddingNewSubject;
	}

	public boolean isAddingNewSubject() {
		return this.addingNewSubject;
	}

	public void setExperimentLVBeans(List<Experiment> experiments) {
		experimentLVBeans = new ArrayList<LabelValueBean>(experiments.size());
		for (Experiment exp : experiments) {
			LabelValueBean lvb = new LabelValueBean(exp.getName(), exp
					.getUniqueid().toString());
			experimentLVBeans.add(lvb);
		}
	}

	public Collection<LabelValueBean> getExperimentLVBeans() {
		return experimentLVBeans;
	}

	public void setSelectedExperimentValue(String newSelectedExperimentValue) {
		this.selectedExperimentValue = newSelectedExperimentValue;
	}

	public String getSelectedExperimentValue() {
		return this.selectedExperimentValue;
	}

	public void setAvailableSubjectLVBeans(List<Humansubject> subjects) {
		availableSubjectLVBeans = new ArrayList<LabelValueBean>(subjects.size());
		for (Humansubject hs : subjects) {
			LabelValueBean lvb = new LabelValueBean(hs.getSubjectid(), hs
					.getSubjectid());
			availableSubjectLVBeans.add(lvb);
		}
	}

	public Collection<LabelValueBean> getAvailableSubjectLVBeans() {
		return availableSubjectLVBeans;
	}

	public void setAvailableSubjectValue(String newAvailableSubjectValue) {
		this.availableSubjectValue = newAvailableSubjectValue;
	}

	public String getAvailableSubjectValue() {
		return this.availableSubjectValue;
	}

	public void setAvailableStudyGroupLVBeans(List<Researchgroup> rgList) {
		availableStudyGroupLVBeans = new ArrayList<LabelValueBean>(rgList
				.size());
		for (Researchgroup rg : rgList) {
			LabelValueBean lvb = new LabelValueBean(rg.getName(), rg
					.getUniqueid().toString());
			availableStudyGroupLVBeans.add(lvb);
		}
	}

	public Collection<LabelValueBean> getAvailableStudyGroupLVBeans() {
		return availableStudyGroupLVBeans;
	}

	/** @todo check if used? */
	public void setAvailableStudyGroupValue(String newAvailableStudyGroupValue) {
		this.availableStudyGroupValue = newAvailableStudyGroupValue;
	}

	public String getAvailableStudyGroupValue() {
		return this.availableStudyGroupValue;
	}

	// end-of-check

	// for study group maintenance
	public void setStudyGroupInfo(StudyGroupInfo newStudyGroupInfo) {
		this.studyGroupInfo = newStudyGroupInfo;
	}

	public StudyGroupInfo getStudyGroupInfo() {
		return this.studyGroupInfo;
	}

	public StorageTypeSelector getStorageTypeSelector() {
		return storageTypeSelector;
	}

	public void setStorageTypeSelector(StorageTypeSelector storageTypeSelector) {
		this.storageTypeSelector = storageTypeSelector;
	}

	
}
