package clinical.web.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.struts.util.LabelValueBean;
import org.apache.taglibs.standard.lang.jpath.adapter.Convert;

import clinical.web.helpers.StoredQueryInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: StoredQuerySelector.java 873 2015-01-07 20:55:20Z jinranc $
 */

public class StoredQuerySelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> storedQueries;
	protected int selectedQueryID;

	public StoredQuerySelector() {
	}

	public StoredQuerySelector(List<StoredQueryInfo> sqiList) {
		storedQueries = new ArrayList<LabelValueBean>(sqiList.size());
		boolean first = true;
		for (StoredQueryInfo sqi : sqiList) {
			LabelValueBean lvb = new LabelValueBean(sqi.getDescription(),
					String.valueOf(sqi.getQueryID()));
			storedQueries.add(lvb);
			if (first) {
				selectedQueryID = sqi.getQueryID();
				first = false;
			}
		}
	}

	public void setStoredQueries(Collection<LabelValueBean> sqList) {
		this.storedQueries = sqList;
	}

	public Collection<LabelValueBean> getStoredQueries() {
		return (Collection<LabelValueBean>) this.storedQueries;
	}

	public Collection<LabelValueBean> getSavedQueries() {
		return (Collection<LabelValueBean>) this.storedQueries;
	}

	public String getStoredQueries(int queryID) {
		String qidStr = String.valueOf(queryID);
		for (Iterator<LabelValueBean> it = storedQueries.iterator(); it
				.hasNext();) {
			LabelValueBean lvb = it.next();
			if (lvb.getValue().equals(qidStr))
				return lvb.getLabel();
		}
		return null;
	}

	public void setSelectedQueryID(int newSelectedQueryID) {
		this.selectedQueryID = newSelectedQueryID;
	}

	public int getSelectedQueryID() {
		return this.selectedQueryID;
	}

	//Jinran added. Select query in dropdown based on name
	public void setSelectedQueryID(String newSelectedQueryName){
		int qId;
		for(Iterator<LabelValueBean>it = storedQueries.iterator(); it.hasNext();){
			LabelValueBean lvb = it.next();
			if(lvb.getLabel().equals(newSelectedQueryName)){
				qId = Integer.parseInt(lvb.getValue());
				this.selectedQueryID = qId;
			}
		}
	}
}
