package clinical.web.forms;

import java.util.LinkedList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.Visit;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectVisitForm.java 873 2015-01-07 20:55:20Z jinranc $
 */

public class SubjectVisitForm extends ActionForm {
	private static final long serialVersionUID = -24076911553018923L;
	protected List<Visit> clinicalVisits = new LinkedList<Visit>();
	protected List<Visit> scanVisits = new LinkedList<Visit>();

	/** the BIRN ID of the subject */
	protected String subjectID;
	/**
	 * four-digit site ID for the subject (The site is defined as the site from
	 * which the subject data comes)
	 */
	protected String siteID;
	protected String imageName;
	protected String srbBrowserURL;
	protected boolean showDetail = false;
	protected boolean allowMRIDownload = false;

	public SubjectVisitForm() {
		super();
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		/** @todo */
		return errors;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
	}

	public void clearState() {
		clinicalVisits.clear();
		scanVisits.clear();
		showDetail = false;
	}

	public void addClinicalVisit(Visit vi) {
		clinicalVisits.add(vi);
	}

	public void addScanVisit(Visit vi) {
		scanVisits.add(vi);
	}

	public List<Visit> getScanVisits() {
		return scanVisits;
	}

	public List<Visit> getClinicalVisits() {
		return clinicalVisits;
	}

	public void setSubjectID(String newSubjectID) {
		this.subjectID = newSubjectID;
	}

	public String getSubjectID() {
		return this.subjectID;
	}

	public void setImageName(String newImageName) {
		this.imageName = newImageName;
	}

	public String getImageName() {
		return this.imageName;
	}

	public boolean isShowDetail() {
		return this.showDetail;
	}

	public void setShowDetail(boolean value) {
		this.showDetail = value;
	}

	public void setSrbBrowserURL(String newSrbBrowserURL) {
		this.srbBrowserURL = newSrbBrowserURL;
	}

	public String getSrbBrowserURL() {
		return this.srbBrowserURL;
	}

	public void setAllowMRIDownload(boolean newAllowMRIDownload) {
		this.allowMRIDownload = newAllowMRIDownload;
	}

	public boolean isAllowMRIDownload() {
		return this.allowMRIDownload;
	}

	public String getSiteID() {
		return siteID;
	}

	public void setSiteID(String siteID) {
		this.siteID = siteID;
	}

	public JSONObject toJSON(JSONObject js){		
		try {
			js.put("subjectid", subjectID);

			JSONArray jsarr = new JSONArray();
			for(Visit v : clinicalVisits)
			{
				jsarr.put(v.toJSON(new JSONObject()));
			}
			for(Visit v: scanVisits){
				jsarr.put(v.toJSON(new JSONObject()));
			}
			js.put("visit", jsarr);
			
			return js;
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
}
