package clinical.web.forms;

import org.apache.struts.action.ActionForm;

import clinical.web.common.security.DBConfig;
import clinical.web.helpers.DbUserSelector;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UserConfigForm.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class UserConfigForm extends ActionForm {
	protected String userType;
	protected String userName;
	protected String password;
	protected String passwordRepeat;
	protected String dbUserName;
	protected String dbId;
	protected boolean testConnection = true;
	protected DbUserSelector dbUserSelector;
	protected DBConfig dbConfig;
	protected String opType;
	protected String testResult = "";
	protected String useGSI = "false";

	public final static String WEBUSER = "web";
	public final static String DBUSER = "db";
	private static final long serialVersionUID = 1L;
	
	protected String firstName;
	protected String lastName;
	protected String email;
	protected String oldPwd;

	public String getUserType() {
		return userType;
	}

	public String getUserName() {
		return userName;
	}

	public String getPassword() {
		return password;
	}

	public String getPasswordRepeat() {
		return passwordRepeat;
	}

	public String getDbUserName() {
		return dbUserName;
	}

	public String getDbId() {
		return dbId;
	}

	public boolean isTestConnection() {
		return testConnection;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setPasswordRepeat(String passwordRepeat) {
		this.passwordRepeat = passwordRepeat;
	}

	public void setDbUserName(String dbUserName) {
		this.dbUserName = dbUserName;
	}

	public void setDbId(String dbId) {
		this.dbId = dbId;
	}

	public void setTestConnection(boolean testConnection) {
		this.testConnection = testConnection;
	}

	public DbUserSelector getDbUserSelector() {
		return dbUserSelector;
	}

	public void setDbUserSelector(DbUserSelector dbUserSelector) {
		this.dbUserSelector = dbUserSelector;
	}

	public DBConfig getDbConfig() {
		return dbConfig;
	}

	public void setDbConfig(DBConfig dbConfig) {
		this.dbConfig = dbConfig;
	}

	public boolean isWebUserType() {
		return userType.equals(WEBUSER);
	}

	public String getOpType() {
		return opType;
	}

	public void setOpType(String opType) {
		this.opType = opType;
	}

	public String getTestResult() {
		return testResult;
	}

	public void setTestResult(String testResult) {
		this.testResult = testResult;
	}

	public String getUseGSI() {
		return useGSI;
	}

	public void setUseGSI(String useGSI) {
		this.useGSI = useGSI;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getOldPwd() {
		return oldPwd;
	}

	public void setOldPwd(String oldPwd) {
		this.oldPwd = oldPwd;
	}

	
}
