package clinical.web.helpers;

/**
 * Represents a single missing score value information for a particular 
 * assessment entry as used in assessment double entry reconciliation to
 * display any missing values in any of the assessment entries.
 * 
 * @see clinical.web.forms.AssessmentEntriesForm
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MissingEntry.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class MissingEntry {
  protected String scoreName;
  protected int entryID;
  protected String questionText;
  protected int scoreSequence;

  public MissingEntry() {}

  public MissingEntry(String scoreName, int entryID, String questionText, int scoreSequence) {
    this.scoreName = scoreName;
    this.entryID = entryID;
    this.questionText = (questionText != null) ? questionText : "";
    this.scoreSequence = scoreSequence;
  }

 //---------------------- getters --------------
  public String getScoreName() { return this.scoreName; }
  public int getEntryID() { return this.entryID; }
  public String getQuestionText() { return this.questionText; }
  public int getScoreSequence() { return this.scoreSequence; }

}
