package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.web.vo.Study;

/**
 * Model (data) for the study dropdown
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StudySelector.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class StudySelector {
	protected Collection<LabelValueBean> studyInfos;
	protected int selectedStudyID;
	public final static int DEFAULT_STUDY = -100;

	public StudySelector(List<Study> studies) {
		studyInfos = new ArrayList<LabelValueBean>(studies.size() + 1);
		studyInfos.add(new LabelValueBean("Default Study", String
				.valueOf(DEFAULT_STUDY)));
		for (Study study : studies) {
			studyInfos.add(new LabelValueBean(study.getName(), String
					.valueOf(study.getStudyID())));
		}
		this.selectedStudyID = DEFAULT_STUDY;
	}

	public Collection<LabelValueBean> getStudyInfos() {
		return this.studyInfos;
	}

	// ---------------------- setters --------------
	public void setSelectedStudyID(int newSelectedStudyID) {
		this.selectedStudyID = newSelectedStudyID;
	}

	// ---------------------- getters --------------
	public int getSelectedStudyID() {
		return this.selectedStudyID;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(80);
		buf.append("StudySelector::[");
		buf.append("studyInfos=").append(studyInfos);
		buf.append(", selectedStudyID=").append(selectedStudyID);
		for (Iterator<LabelValueBean> iter = studyInfos.iterator(); iter
				.hasNext();) {
			LabelValueBean lvb = iter.next();
			buf.append("\n\t").append(lvb.toString());
		}
		buf.append(']');
		return buf.toString();
	}

}
