package clinical.web.scheduler;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.web.Constants;


/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: JobRunner.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class JobRunner implements Runnable {
	protected JobInfo jobInfo;
	protected JobScheduler scheduler;
	private Log log = LogFactory.getLog("JobRunner");

	public JobRunner(JobScheduler scheduler, JobInfo jobInfo) {
		this.scheduler = scheduler;
		this.jobInfo = jobInfo;
	}

	public void run() {
		IJob job = jobInfo.getJob();
		try {
			jobInfo.setStatus(JobInfo.RUNNING);

			scheduler.updateJobDB(jobInfo, job.getID());

			job.execute();
//			File f = new File(scheduler.getOutputRootDir(), job.getID()
//					+ ".csv");
			File f;
			if(job.getFileType()!=null){
				if(job.getFileType().equals(Constants.PED_FILE)){
					f = new File(scheduler.getOutputRootDir(), job.getID() + ".tar");
				}else{
					f = new File(scheduler.getOutputRootDir(), job.getID() + "." + job.getFileType().toLowerCase());
				}
			}else{
				f = new File(scheduler.getOutputRootDir(), job.getID()	+ ".csv");				
			}			

			job.saveResults(f);
		
			jobInfo.setStatus(JobInfo.FINISHED);
		} catch (JobException e) {
			log.error("", e);
			jobInfo.setStatus(JobInfo.FINISHED_WITH_ERR);
			String msg = getErrorMessage(e);
			jobInfo.setErrorMsg(msg);
		} catch (Throwable t) {
			log.error("", t);
			t.printStackTrace();
			jobInfo.setStatus(JobInfo.FINISHED_WITH_ERR);
			String msg = getErrorMessage(t);
			jobInfo.setErrorMsg(msg);
		} finally {
			synchronized (scheduler) {
				scheduler.notify();
			}
		}
	}

	protected String getErrorMessage(Throwable t) {
		String msg = t.getMessage() != null ? t.getMessage()
				: "Unspecified internal error";
		return msg;
	}

}
