package clinical.web.services;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.LabelValueBean;

import clinical.server.dao.AssessmentDAO;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.GeneList;
import clinical.web.GeneticChip;
import clinical.web.GeneticSession;
import clinical.web.IGeneticService;
import clinical.web.ISQLDialect;
import clinical.web.ISequenceHelper;
import clinical.web.ServiceFactory;
import clinical.web.SnpList;
import clinical.web.common.IDBPoolService;
import clinical.web.exception.BaseException;
import clinical.web.helpers.BatchQueryHelper;
import clinical.web.helpers.BatchQueryHelper.ClsFileDataRow;

public class GeneticServiceImpl implements IGeneticService{
	private IDBPoolService pool = null;
	private AssessmentDAO asDAO = null;
	private String theDBID;
	private ISQLDialect sqlDialect;
	private Log log = LogFactory.getLog("clinical");

	
	public GeneticServiceImpl(String dbID) throws BaseException {
		theDBID = dbID;
		pool = ServiceFactory.getPoolService(dbID);
		asDAO = DAOFactory.createAssessmentDAO(dbID);
		sqlDialect = ServiceFactory.getSQLDialect(theDBID);
	}
	
	public List<SnpList> getAllSnpList() throws Exception {
		SnpList snpList = null;
		List<SnpList> listSnpList = new ArrayList<SnpList>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select gsl.uniqueid, gsl.sessionid, gsl.snplistname, gsl.snplist, gs.sessionname " +
				" from nc_geneticsnplist gsl left join nc_geneticsession gs " +
				" on gsl.sessionid = gs.sessionid " +
				" order by gsl.snplistname";
			ResultSet rs = st.executeQuery(sql);

			while(rs.next()){
				snpList = new SnpList(rs.getBigDecimal("uniqueid"), rs.getBigDecimal("sessionid"), 
						rs.getString("snplistname"), rs.getString("snplist"), rs.getString("sessionname"));
				listSnpList.add(snpList);
			}
		
			return listSnpList;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}
	

	public void deleteSnpList(String snpName) throws Exception{
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();		
			 
			String sql = "delete from nc_geneticsnplist " + 
				"where snplistname = '" + snpName + "'";
			
			st.executeUpdate(sql);	
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}		
	}
	 
	public void addSnpList(BigDecimal sessionId, String snpName, String snpValue) throws Exception{
		Connection con = null;
		BigDecimal uid = null;
		ISequenceHelper iseq;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			
			iseq = ServiceFactory.getSequenceHelper(theDBID);
			uid = iseq.getNextUID(con, Constants.SNPLIST_DB_TABLE, "uniqueid");
			
			String sql;
			if(sessionId.equals(BigDecimal.valueOf(-1))){
				sql = "insert into nc_geneticsnplist(uniqueid, sessionid, snplistname, snplist) " + 
					"values(" + uid + ", null, '" + snpName + "', '" + snpValue + "')";
			}else{
				sql = "insert into nc_geneticsnplist(uniqueid, sessionid, snplistname, snplist) " + 
					"values(" + uid + ", " + sessionId + ", '" + snpName + "', '" + snpValue + "')";
			}
			st.executeUpdate(sql);			
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}
	
	public void updateSnpList(String oldSnpName, BigDecimal sessionId, String snpName, String snpValue) throws Exception{
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();		
			 
			String sql = "update nc_geneticsnplist " +
				"set sessionid = " + sessionId + ", snplistname = '" + snpName + "', snplist='" + snpValue + "' " +
				"where snplistname = '" + oldSnpName+ "'";
				
			st.executeUpdate(sql);			
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	/*
	 * get all session info from table nc_geneticsession
	 * @see clinical.web.IGeneticService#getAllSession()
	 */
	public Collection<GeneticSession> getAllSession() throws Exception{
		Collection<GeneticSession> geneSessions = new ArrayList<GeneticSession>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select * from nc_geneticsession order by sessionname";
			ResultSet rs = st.executeQuery(sql);
			
			while(rs.next()){
				GeneticSession gSession = new GeneticSession();
				gSession.setChipId(rs.getBigDecimal("chipid"));
				gSession.setSessionId(rs.getBigDecimal("sessionid"));
				gSession.setSessionName(rs.getString("sessionname"));				
				geneSessions.add(gSession);
			}
		
			return geneSessions;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}
	
	
	/*
	 * get session info from table nc_geneticsession on experiment
	 * @see clinical.web.IGeneticService#getSessionOnExp()
	 */
	public Collection<GeneticSession> getSessionOnExp(String expName) throws Exception{
		Collection<GeneticSession> geneSessions = new ArrayList<GeneticSession>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select * from nc_geneticsession where expname='" + expName + "' order by sessionname";
			ResultSet rs = st.executeQuery(sql);
			
			while(rs.next()){
				GeneticSession gSession = new GeneticSession();
				gSession.setChipId(rs.getBigDecimal("chipid"));
				gSession.setSessionId(rs.getBigDecimal("sessionid"));
				gSession.setSessionName(rs.getString("sessionname"));
				gSession.setExpName(rs.getString("expname"));
				geneSessions.add(gSession);
			}
		
			return geneSessions;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}
	
	
	
	public Collection<GeneticChip> getAllChips() throws Exception{
		Collection<GeneticChip> geneChips = new ArrayList<GeneticChip>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select * from nc_geneticchip order by chipname";
			ResultSet rs = st.executeQuery(sql);
			
			while(rs.next()){
				GeneticChip gChip = new GeneticChip();
				gChip.setChipId(rs.getBigDecimal("chipid"));
				gChip.setChipDesc(rs.getString("chipdescription"));								
				gChip.setChipName(rs.getString("chipname"));
				gChip.setGenomeBuild(rs.getString("genomebuild"));
				geneChips.add(gChip);
			}
		
			return geneChips;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}

	public Collection<GeneticChip> getChipsOnSession(String sessionName) throws Exception{
		Collection<GeneticChip> geneChips = new ArrayList<GeneticChip>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select * from nc_geneticsession gs, nc_geneticchip gc where gs.sessionname='" + sessionName + "' and gs.chipid=gc.chipid order by sessionname";
			ResultSet rs = st.executeQuery(sql);
			
			while(rs.next()){
				GeneticChip gChip = new GeneticChip();
				gChip.setChipId(rs.getBigDecimal("chipid"));
				gChip.setChipDesc(rs.getString("chipdescription"));								
				gChip.setChipName(rs.getString("chipname"));
				gChip.setGenomeBuild(rs.getString("genomebuild"));
				geneChips.add(gChip);
			}
		
			return geneChips;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}

	public Collection<LabelValueBean> getUniqueGenomeRelease() throws Exception{
		Collection<LabelValueBean> genomeBuilds = new ArrayList<LabelValueBean>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select distinct genomebuild from nc_geneticchip";
			ResultSet rs = st.executeQuery(sql);
			int i = 0;
			
			while(rs.next()){
				String sGenomeBuild;
				sGenomeBuild = rs.getString("genomebuild");
				LabelValueBean lvb = new LabelValueBean(sGenomeBuild, String.valueOf(i));
				genomeBuilds.add(lvb);
				i++;
			}
		
			return genomeBuilds;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}

	public Collection<LabelValueBean> getUniqueGenomeReleaseOnSession(String sessionName) throws Exception{
		Collection<LabelValueBean> genomeBuilds = new ArrayList<LabelValueBean>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select distinct gc.genomebuild from nc_geneticchip gc, nc_geneticsession gs where gc.chipid=gs.chipid and gs.sessionname='" + sessionName + "'";
			ResultSet rs = st.executeQuery(sql);
			int i = 0;
			
			while(rs.next()){
				String sGenomeBuild;
				sGenomeBuild = rs.getString("genomebuild");
				LabelValueBean lvb = new LabelValueBean(sGenomeBuild, String.valueOf(i));
				genomeBuilds.add(lvb);
				i++;
			}
		
			return genomeBuilds;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}

	
	public void addGeneSession(String sessionName, String sessionDesc, BigDecimal chipId) throws Exception{
		Connection con = null;
		BigDecimal uid = null;
		ISequenceHelper iseq;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			
			iseq = ServiceFactory.getSequenceHelper(theDBID);
			uid = iseq.getNextUID(con, Constants.SESSIOIN_DB_TABLE, "sessionid");
			 
			String sql = "insert into nc_geneticsession(sessionid, chipid, sessionname) " + 
				"values(" + uid + ", " + chipId + ", '" + sessionName + "')";
			st.executeUpdate(sql);			
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	public void deleteSession(String sessionName) throws Exception{
		Connection con = null;
		try{
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			
			String sql = "delete from nc_geneticsession " + 
						 "where sessionname = '" + sessionName + "' ";
			st.executeUpdate(sql);
		}
		catch(Exception x){
			x.printStackTrace();
			throw x;
		}
		finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}
	

	public ResultSet getDataFromGeneTables(String sql) throws Exception{
		Connection con = null;
		try{
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement(java.sql.ResultSet.TYPE_FORWARD_ONLY, java.sql.ResultSet.CONCUR_READ_ONLY);
			st.setFetchSize(1000);
			
			ResultSet rs = st.executeQuery(sql);
			
			return rs;
		}
		catch(Exception x){
			x.printStackTrace();
			throw x;
		}
		finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}
	
//	/*
//	 * divide data into small portion, then retrieve and store into list object 
//	 * @see clinical.web.IGeneticService#createDataRowListForMAPFile(java.lang.String, long)
//	 */
//	public List<ClsFileDataRow> createDataRowListForPEDFile(String sql, long recordCount) throws Exception{
//		Connection con = null;
//		List<ClsFileDataRow> dataRowList = new LinkedList<ClsFileDataRow>();
//		
//		try{
//			con = pool.getConnection(Constants.ADMIN_USER);
//			Statement st = null;
//			ResultSet rs = null;
//			
//			st = con.createStatement(java.sql.ResultSet.TYPE_FORWARD_ONLY, java.sql.ResultSet.CONCUR_READ_ONLY);
//			//st.setFetchSize(1000);
//						
//			long offSet = 0;
//			offSet = recordCount/10000;
//			if(recordCount%10000>0){
//				offSet++;
//			}
//			
//			for(long i=0; i<offSet; i++){
//				rs = st.executeQuery(sql + " offset " + i*10000);				
//				BatchQueryHelper.addPEDDataRow(rs,dataRowList);
//				if(i==340){
//					if(rs!=null) rs.close();
//				}
//				if(rs!=null){
//			    	rs.close();			    	
//			    }
//			}
//			
//		    st.close() ;
//		    		    		    
//		}
//		catch(Exception x){
//			x.printStackTrace();
//			throw x;
//		}
//		finally{
//			if (con != null)
//				pool.releaseConnection(Constants.ADMIN_USER, con);
//		}
//		return dataRowList;
//	}

	public ResultSet createRSForMAPPEDFile(String sql, long offset) throws Exception{
		Connection con = null;		
		try{
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;						
			st = con.createStatement(java.sql.ResultSet.TYPE_FORWARD_ONLY, java.sql.ResultSet.CONCUR_READ_ONLY);
			st.setFetchSize(1000);
			
			ResultSet rs = st.executeQuery(sql + " offset " + offset*Constants.QUERY_OFFSET);
		    
		    return rs;		    		    		    
		}
		catch(Exception x){
			x.printStackTrace();
			throw x;
		}
		finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}		
	}

	
	/*
	 * divide data into small portion, then retrieve and store into list object 
	 * @see clinical.web.IGeneticService#createDataRowListForMAPFile(java.lang.String, long)
	 */
	public List<ClsFileDataRow> createDataRowListForMAPFile(String sql, long recordCount) throws Exception{
		Connection con = null;
		List<ClsFileDataRow> dataRowList = new LinkedList<ClsFileDataRow>();
		
		try{
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			ResultSet rs = null;
			
			st = con.createStatement(java.sql.ResultSet.TYPE_FORWARD_ONLY, java.sql.ResultSet.CONCUR_READ_ONLY);
			//st.setFetchSize(1000);
			
			long offSet = 0;
			offSet = recordCount/10000;
			if(recordCount%10000>0){
				offSet++;
			}
			
			for(long i=0; i<offSet; i++){
				rs = st.executeQuery(sql + " offset " + i*10000);				
				BatchQueryHelper.addMapDataRow(dataRowList,rs);
			}
										
		    st.close() ;
		    if(rs!=null){
		    	rs.close();
		    }
		    
		    return dataRowList;
		}
		catch(Exception x){
			x.printStackTrace();
			throw x;
		}
		finally{
			if (con != null){
				pool.releaseConnection(Constants.ADMIN_USER, con);
			}			
		}		
	}
	
	public void exportFileDataFromGeneTables(String sql, HttpServletResponse response) throws Exception{
		Connection con = null;
		response.setContentType("application/octet-stream");
		response.setHeader("Content-Disposition",
				"attachment; filename=results.ped;");
		
		try{
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement(java.sql.ResultSet.TYPE_FORWARD_ONLY, java.sql.ResultSet.CONCUR_READ_ONLY);
			st.setFetchSize(1000);
			
			ResultSet rs = st.executeQuery(sql);

			List<ClsFileDataRow> dataRowList = new LinkedList<ClsFileDataRow>();
			int curRow = 0;
			
			while (rs.next()) {
				ClsFileDataRow pedRow = new ClsFileDataRow();
				boolean subjectExist = false;				
				
				for(ClsFileDataRow drow : dataRowList){
					if(rs.getString("subjectid").equals(drow.getIndividualId())){
						subjectExist = true;
						//add Genotypes to this existing row
						List<String> strGTypes = new LinkedList<String>();
						strGTypes = drow.getGenotypes();
						strGTypes.add(BatchQueryHelper.convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
						drow.setGenotypes(strGTypes);
						
						//dataRowList.set(curRow, drow);
						dataRowList.remove(curRow-1);
						dataRowList.add(curRow-1, drow);
						break;
					}
					
				}
				if(subjectExist==false){						
					pedRow = new ClsFileDataRow();
					pedRow.setFamilyId("0");
					pedRow.setIndividualId(rs.getString("subjectid"));
					pedRow.setFatherId(rs.getString("fatherid"));
					pedRow.setMotherId(rs.getString("motherid"));
					pedRow.setSex("-9");
					pedRow.setStatus("-9");
					List<String> strGTypes = new LinkedList<String>();
					strGTypes.add(BatchQueryHelper.convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
					pedRow.setGenotypes(strGTypes);
					dataRowList.add(pedRow);
					curRow++;
				}				
			}
							
			BufferedWriter out = null;
			out = new BufferedWriter(new OutputStreamWriter(response.getOutputStream()), 4096);
			StringBuilder buf = new StringBuilder();
			for(ClsFileDataRow drow : dataRowList){
				buf = new StringBuilder();
				buf.append(drow.getFamilyId());
				buf.append("\t");
				buf.append(drow.getIndividualId());
				buf.append("\t");
				buf.append(drow.getFatherId());
				buf.append("\t");
				buf.append(drow.getMotherId());
				buf.append("\t");
				buf.append(drow.getSex());
				buf.append("\t");
				buf.append(drow.getStatus());
				buf.append("\t");
				
				Iterator<String> itr = (Iterator<String>) drow.getGenotypes().iterator();				
				while(itr.hasNext()){									
					buf.append(itr.next());
					buf.append("\t");
				}
								
				out.write(buf.toString());
				out.newLine();
			}
						
		    st.close() ;
		    rs.close();		    
		}
		catch(Exception x){
			x.printStackTrace();
			throw x;
		}
		finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}
	
	
	public ResultSet getAllSubjectIds(String experimentName) throws Exception{
		ResultSet rs = null;
		Connection con = null;
		String sql = "";
		
		try{
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			
			StringBuilder sb = new StringBuilder();
			sb.append("select distinct subjectid from nc_subjexperiment se " +
					"inner join nc_experiment e on se.nc_experiment_uniqueid = e.uniqueid " +
					"where e.name ");
			
			if(experimentName.equals("All Experiments") || experimentName.equals("All Experiments without Regression") ){
				sb.append("in (select name from nc_experiment)");
			}else{
				sb.append("='");
				sb.append(experimentName);
				sb.append("'");
			}
			
			sql = sb.toString();
			
			rs = st.executeQuery(sql);
			
			return rs;
		}
		catch(Exception x){
			x.printStackTrace();
			throw x;
		}
		finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}		
	}

	@Override
	public List<GeneList> getAllGeneList() throws Exception {
		GeneList geneList = null;
		List<GeneList> listGeneList = new ArrayList<GeneList>();
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select gl.uniqueid, gl.sessionid, gl.genelistname, gl.genelist, gs.sessionname " +
				" from nc_geneticgenelist gl left join nc_geneticsession gs " +
				" on gl.sessionid = gs.sessionid " +
				" order by gl.genelistname";
			ResultSet rs = st.executeQuery(sql);

			while(rs.next()){
				geneList = new GeneList(rs.getBigDecimal("uniqueid"), rs.getBigDecimal("sessionid"), 
						rs.getString("genelistname"), rs.getString("genelist"), rs.getString("sessionname"));
				listGeneList.add(geneList);
			}
		
			return listGeneList;
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}

	}

	@Override
	public void deleteGeneList(String geneName) throws Exception {
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();		
			 
			String sql = "delete from nc_geneticgenelist " + 
				"where genelistname = '" + geneName + "'";
			
			st.executeUpdate(sql);	
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}		
		
	}

	@Override
	public void addGeneList(BigDecimal sessionId, String geneName,
			String geneValue) throws Exception {
		Connection con = null;
		BigDecimal uid = null;
		ISequenceHelper iseq;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			
			iseq = ServiceFactory.getSequenceHelper(theDBID);
			uid = iseq.getNextUID(con, Constants.GENELIST_DB_TABLE, "uniqueid");
			
			String sql;
			if(sessionId.equals(BigDecimal.valueOf(-1))){
				sql = "insert into nc_geneticgenelist(uniqueid, sessionid, genelistname, genelist) " + 
					"values(" + uid + ", null, '" + geneName + "', '" + geneValue + "')";
			}else{
				sql = "insert into nc_geneticgenelist(uniqueid, sessionid, genelistname, genelist) " + 
					"values(" + uid + ", " + sessionId + ", '" + geneName + "', '" + geneValue + "')";
			}
			st.executeUpdate(sql);			
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}

	@Override
	public void updateGeneList(String oldGeneName, BigDecimal sessionId,
			String geneName, String geneValue) throws Exception {
		Connection con = null;
		
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();		
			 
			String sql = "update nc_geneticgenelist " +
				"set sessionid = " + sessionId + ", genelistname = '" + geneName + "', genelist='" + geneValue + "' " +
				"where genelistname = '" + oldGeneName+ "'";
				
			st.executeUpdate(sql);			
			
		}catch(Exception x){
			x.printStackTrace();
			throw x;			
		}finally{
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
		
	}
}
