package clinical.web.services;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.cache.CacheUtils;
import clinical.cache.DBChangeEvent;
import clinical.cache.DBChangeListener;
import clinical.cache.DBChangeSupport;
import clinical.cache.NullObject;
import clinical.cache.TableChange;
import clinical.server.dao.DataobjecttypeDAO;
import clinical.server.dao.ExperimentDAO;
import clinical.server.dao.ExtendedtupleDAO;
import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentscore;
import clinical.server.vo.Dataobjecttype;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Experiment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Extendedtuple;
import clinical.server.vo.Protocol;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.IRemoteDBServices;
import clinical.web.ISQLDialect;
import clinical.web.MinimalServiceFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.vo.VisitDateQuery;

import clinical.web.SnpList;

/**
 * @author I. Burak Ozyurt
 * @version $Id: RemoteDBServicesImpl.java,v 1.5.2.2 2008/07/24 01:07:38 bozyurt
 *          Exp $
 */
public class RemoteDBServicesImpl implements IRemoteDBServices,
		DBChangeListener {
	protected CacheManager man;
	protected static RemoteDBServicesImpl instance = null;

	protected static Log log = LogFactory.getLog(RemoteDBServicesImpl.class);

	protected RemoteDBServicesImpl() {
		man = CacheManager.getInstance();
	}

	public synchronized static RemoteDBServicesImpl getInstance() {
		if (instance == null) {
			instance = new RemoteDBServicesImpl();
			DBChangeSupport.getInstance().addDBChangeListener(instance);
		}
		return instance;
	}

	@SuppressWarnings("unchecked")
	public Map<String, Dataobjecttype> getAllDataObjectTypes(String siteID)
			throws Exception {
		String key = siteID + ":dataobjecttype";
		Object o = getFromCache(key);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			return (Map<String, Dataobjecttype>) o;
		}
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
         throw new RuntimeException("No database is setup for site:" + siteID);
      }
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		Map<String, Dataobjecttype> dotMap = new HashMap<String, Dataobjecttype>(
				17);
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			DataobjecttypeDAO dao = DAOFactory.createDataobjecttypeDAO(dbID);
			List<Dataobjecttype> dotList = dao.find(con, new Dataobjecttype());
			for (Dataobjecttype dot : dotList) {
				dotMap.put(dot.getObjecttype(), dot);
			}
			put2Cache(key, dotMap);
			return dotMap;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	@SuppressWarnings("unchecked")
	public Map<String, Experiment> getAllExperiments(String siteID)
			throws Exception {
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
         throw new RuntimeException("No database is setup for site:" + siteID);
      }
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		List<Experiment> expList;
		String key = siteID + ":experiment";
		Object o = getFromCache(key);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			return (Map<String, Experiment>) o;
		}
		Map<String, Experiment> expMap = new HashMap<String, Experiment>(11);
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			ExperimentDAO dao = DAOFactory.createExperimentDAO(dbID);
			expList = dao.find(con, new Experiment());
			for (Experiment exp : expList) {
				expMap.put(exp.getUniqueid().toString(), exp);
			}
			put2Cache(key, expMap);
			return expMap;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	@SuppressWarnings("unchecked")
   public Map<String, Date> getVisitDates(String siteID,
			List<VisitDateQuery> vdqList, boolean forceRecache)
			throws Exception {

		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
         throw new RuntimeException("No database is setup for site:" + siteID);
      }
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		String key = siteID + ":visitdate";
		if (forceRecache) {
			CacheUtils.dropFromCache(key);
		}
		Object o = getFromCache(key);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			return (Map<String, Date>) o;
		}
		Map<String, Date> visitDateMap = new HashMap<String, Date>();
        if ( vdqList.isEmpty()) {
        	return visitDateMap;
        }
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			TSQLProcessor tsp = new TSQLProcessor(ServiceFactory
					.getSQLDialect(dbID));
			StringBuilder sb = new StringBuilder(512);
			sb
					.append("select v.componentid, v.subjectid, v.ncExperimentUniqueid, v.timestamp ");
			sb.append("from Expcomponent as v where v.subjectid in (");
			for (Iterator<VisitDateQuery> it = vdqList.iterator(); it.hasNext();) {
				VisitDateQuery vdq = it.next();
				sb.append("'").append(vdq.getSubjectID()).append("'");
				if (it.hasNext())
					sb.append(',');
			}
			sb.append(')');
			log.info("getVisitDates:: query:\n"
					+ GenUtils.applyWordWrapping(sb.toString()));
			Map<String, VisitDateQuery> vdqMap = new HashMap<String, VisitDateQuery>();
			for (VisitDateQuery vdq : vdqList) {
				vdqMap.put(vdq.getKey(), vdq);
			}
			List<?> results = tsp.executeQuery(con, sb.toString());
			for (Iterator<?> it = results.iterator(); it.hasNext();) {
				Expcomponent v = (Expcomponent) it.next();
				String vKey = v.getSubjectid() + "_"
						+ v.getNcExperimentUniqueid() + "_"
						+ v.getComponentid();
				if (vdqMap.containsKey(vKey)) {
					visitDateMap
							.put(vKey, new Date(v.getTimeStamp().getTime()));
				}
			}
			put2Cache(key, visitDateMap);
			return visitDateMap;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	@SuppressWarnings("unchecked")
   public List<Extendedtuple> getExtendedTuples(String siteID)
			throws Exception {
		String key = siteID + ":extendedtuple";
		Object o = getFromCache(key);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			return (List<Extendedtuple>) o;
		}
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
         throw new RuntimeException("No database is setup for site:" + siteID);
      }
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			ExtendedtupleDAO dao = DAOFactory.createExtendedtupleDAO(dbID);
			List<Extendedtuple> etList = dao.find(con, new Extendedtuple());
			put2Cache(key, etList);
			return etList;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	@SuppressWarnings("unchecked")
	public List<AssessmentSelectionInfo> getAllAssessmentsWithScores(
			String siteID) throws Exception {
		String key = siteID + ":asiScores";
		Object o = getFromCache(key);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			List<AssessmentSelectionInfo> origAsiList = (List<AssessmentSelectionInfo>) o;

			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
					origAsiList.size());
			for (AssessmentSelectionInfo asi : origAsiList) {
				AssessmentSelectionInfo newAsi = new AssessmentSelectionInfo(
						asi, true, true);
				asiList.add(newAsi);
			}
			// return a deep copy of the cached list for updates
			return asiList;
		}
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
         throw new RuntimeException("No database is setup for site:" + siteID);
      }
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		try {
			con = pool.getConnection(Constants.ADMIN_USER);

			TSQLProcessor tsql = new TSQLProcessor(ServiceFactory
					.getSQLDialect(dbID));
			StringBuilder sb = new StringBuilder(200);
			sb.append("select a.name, a.assessmentid, a.description,");
			sb.append("s.scorename, s.scoresequence, s.scoretype,");
			sb.append("s.scorelevel,s.description from Assessment as a,");
			sb.append("Assessmentscore as s where ");
			sb.append("a.assessmentid = s.assessmentid");

			List<?> results = tsql.executeQuery(con, sb.toString());
			Map<BigDecimal, AssessmentSelectionInfo> asiMap = new HashMap<BigDecimal, AssessmentSelectionInfo>();
			for (Iterator<?> it = results.iterator(); it.hasNext();) {
				Object[] row = (Object[]) it.next();
				Assessment a = (Assessment) row[0];
				Assessmentscore s = (Assessmentscore) row[1];
				AssessmentSelectionInfo asi = asiMap.get(a.getAssessmentid());
				if (asi == null) {
					asi = new AssessmentSelectionInfo(a.getName(), a
							.getAssessmentid());
					asi.setDescription(a.getDescription());
					asiMap.put(asi.getAssessmentID(), asi);
				}
				AsScoreInfo si = new AsScoreInfo(a.getAssessmentid());
				si.setName(s.getScorename());
				si.setType(s.getScoretype());
				si.setSequence(s.getScoresequence().intValue());
				si.setLevel(s.getScorelevel().intValue());
				si.setDescription(s.getDescription());
				asi.addScore(si);
			}
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
					asiMap.values());

			Collections.sort(asiList,
					new Comparator<AssessmentSelectionInfo>() {
						public int compare(AssessmentSelectionInfo asi1,
								AssessmentSelectionInfo asi2) {
							return asi1.getName().compareToIgnoreCase(
									asi2.getName());
						}
					});
			for (AssessmentSelectionInfo asi : asiList)
				QueryWizardHelper.createTree(asi);

			put2Cache(key, asiList);
			return asiList;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}

	}

	
	/*
	 * Jinran added
	 * Retrieve only assessment which subject data has
	 */
	@SuppressWarnings("unchecked")
	public List<AssessmentSelectionInfo> getAllValidAssessmentsWithScores(
			String siteID) throws Exception {
		String key = siteID + ":asiScores";
/*		Object o = getFromCache(key);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			List<AssessmentSelectionInfo> origAsiList = (List<AssessmentSelectionInfo>) o;

			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
					origAsiList.size());
			for (AssessmentSelectionInfo asi : origAsiList) {
				AssessmentSelectionInfo newAsi = new AssessmentSelectionInfo(
						asi, true, true);
				asiList.add(newAsi);
			}
			// return a deep copy of the cached list for updates
			return asiList;
		}
*/		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
			throw new RuntimeException("No database is setup for site:" + siteID);
		}
		
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			/*String sql = "select a.name, a.assessmentid, a.description, s.scorename, s.scoresequence, s.scoretype, s.scorelevel,s.description " +
						 "from nc_Assessment as a,	nc_Assessmentscore as s " +
						 "where a.assessmentid = s.assessmentid " +
						 "		and a.assessmentid in " +
						 "			( select distinct assessmentid from nc_Assessmentdata " +
						 "			  where nc_storedassessment_uniqueid in " +
						 "			(select uniqueid from nc_Storedassessment " +
						 "				 where nc_experiment_uniqueid in " +
						 "				(select uniqueid from nc_Experiment)))";*/
			//modified to add leadingtext from assessmentitem table
			String sql = " SELECT a.name, a.assessmentid, a.description, " +
						 "		 s.scorename, s.scoresequence, s.scoretype, s.scorelevel,s.description, " +
						 "		 i.itemleadingtext as leadingtext " +
						 " FROM nc_Assessment as a,	nc_Assessmentscore as s " +
						 " LEFT OUTER JOIN nc_assessmentitem as i " +
						 " ON s.assessmentid=i.assessmentid and s.scorename=i.scorename " +
						 " WHERE a.assessmentid = s.assessmentid " +
						 "		AND a.assessmentid IN " +
						 "			( SELECT DISTINCT assessmentid FROM nc_Assessmentdata " +
						 "			  WHERE nc_storedassessment_uniqueid IN " +
						 "			(SELECT uniqueid FROM nc_Storedassessment " +
						 "				 WHERE nc_experiment_uniqueid IN " +
						 "				(SELECT uniqueid FROM nc_Experiment)))";
			ResultSet rs = st.executeQuery(sql);			
			
			Map<BigDecimal, AssessmentSelectionInfo> asiMap = new HashMap<BigDecimal, AssessmentSelectionInfo>();
			
			while(rs.next()){
				AssessmentSelectionInfo asi = asiMap.get(rs.getBigDecimal(2));
				if (asi == null) {
					asi = new AssessmentSelectionInfo(rs.getString(1), rs.getBigDecimal(2));
					asi.setDescription(rs.getString(3));					
					asiMap.put(asi.getAssessmentID(), asi);
				}
				AsScoreInfo si = new AsScoreInfo(rs.getBigDecimal(2));
				si.setName(rs.getString(4));
				si.setType(rs.getString(6));
				si.setSequence(rs.getInt(5));
				si.setLevel(rs.getInt(7));
				si.setDescription(rs.getString(8));
				si.setLeadingtext(rs.getString(9));
				asi.addScore(si);
			}
			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
					asiMap.values());

			Collections.sort(asiList,
					new Comparator<AssessmentSelectionInfo>() {
						public int compare(AssessmentSelectionInfo asi1,
								AssessmentSelectionInfo asi2) {
							return asi1.getName().compareToIgnoreCase(
									asi2.getName());
						}
					});
			for (AssessmentSelectionInfo asi : asiList)
				QueryWizardHelper.createTree(asi);

			put2Cache(key, asiList);
			return asiList;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}

	}
	
	@SuppressWarnings("unchecked")
   public List<Assessment> getAllAssessments(String siteID) throws Exception {
		String key = siteID + ":assessment";
		Object o = getFromCache(key);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			return (List<Assessment>) o;
		}
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
         throw new RuntimeException("No database is setup for site:" + siteID);
      }
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		List<Assessment> asList = null;
		try {
			con = pool.getConnection(Constants.ADMIN_USER);

			TSQLProcessor tsql = new TSQLProcessor(ServiceFactory
					.getSQLDialect(dbID));
			List<?> results = tsql
					.executeQuery(con,
							"select a.name, a.assessmentid, a.description from Assessment as a");
			asList = new ArrayList<Assessment>(results.size());
			for (Iterator<?> it = results.iterator(); it.hasNext();) {
				Assessment as = (Assessment) it.next();
				asList.add(as);
			}
			put2Cache(key, asList);
			return asList;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	@SuppressWarnings("unchecked")
   public Expsegment getSegmentInfo(UserInfo ui, String siteID,
			String expName, String subjectID, Integer visitID,
			String segmentName) throws Exception {
		String cacheKey = siteID + ":expsegment";
		Map<String, Object> siteSegMap = null;
		String key = prepSegmentKey(expName, subjectID, visitID, segmentName);
		Object o = getFromCache(cacheKey);
		if (o != null) {
			if (o == NullObject.getInstance())
				return null;
			siteSegMap = (Map<String, Object>) o;
			Object item = siteSegMap.get(key);
			if (item != null)
				return (item instanceof Expsegment) ? (Expsegment) item : null;
		}

		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
		   throw new RuntimeException("No database is setup for site:" + siteID);
		}

		IDBPoolService pool = ServiceFactory.getPoolService(dbID);

		ISQLDialect sqlDialect = ServiceFactory.getSQLDialect(dbID);
		TSQLProcessor tsp = new TSQLProcessor(sqlDialect);
		StringBuffer qb = new StringBuffer(256);
		qb.append("select s.* from Expsegment as s , Experiment as e ");
		qb.append("where s.ncExperimentUniqueid = e.uniqueid and e.name = '");
		qb.append(expName).append("' and s.subjectid = '");
		qb.append(subjectID).append("' and s.componentid =");
		qb.append(visitID).append(" and s.name = '");
		qb.append(segmentName).append("'");

		Connection con = null;
		try {
			if ( siteSegMap == null) {
				siteSegMap = new HashMap<String, Object>(23);
				put2Cache(cacheKey, siteSegMap);
			}
			con = pool.getConnection(Constants.ADMIN_USER);
			List<?> results = tsp.executeQuery(con, qb.toString());
			if (results.isEmpty()) {
				siteSegMap.put(key, NullObject.getInstance());
				return null;
			}
			Assertion.assertTrue(results.size() == 1);
			Expsegment expSegment = (Expsegment) results.get(0);
			siteSegMap.put(key, expSegment);
			return expSegment;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	@SuppressWarnings("unchecked")
   public synchronized Dataobjecttype findObjectType(String objectType,
			boolean forceRecache) throws Exception {
		Map<String, Dataobjecttype> objectTypeMap = null;
		String cacheKey = "dataobjecttype";
		if (forceRecache) {
			dropFromCache(cacheKey);
		} else {
			Object o = getFromCache(cacheKey);
			if (o != null) {
				objectTypeMap = (Map<String, Dataobjecttype>) o;
				return objectTypeMap.get(objectType);
			}
		}
		try {
			objectTypeMap = new HashMap<String, Dataobjecttype>();
			String key = objectType;
			ISecurityService isec = MinimalServiceFactory.getSecurityService();
			String[] allDBIDs = isec.getAllDBIDs();
			Dataobjecttype cr = new Dataobjecttype();
			for (int i = 0; i < allDBIDs.length; i++) {
				Connection con = null;
				IDBPoolService pool = null;
				try {
					DataobjecttypeDAO dao = DAOFactory
							.createDataobjecttypeDAO(allDBIDs[i]);
					pool = MinimalServiceFactory.getPoolService(allDBIDs[i]);
					con = pool.getConnection(Constants.ADMIN_USER);
					List<Dataobjecttype> doiList = dao.find(con, cr);
					for (Dataobjecttype doi : doiList) {
						objectTypeMap.put(doi.getObjecttype(), doi);
					}
				} catch (SQLException se) {
					// ignore error and skip the database
				} finally {
					if (con != null) {
						try {
							pool.releaseConnection(Constants.ADMIN_USER, con);
						} catch (Exception x) {
						}
					}
				}
			}// i
			objectTypeMap = Collections.unmodifiableMap(objectTypeMap);
			put2Cache(cacheKey, objectTypeMap);

			return objectTypeMap.get(key);
		} catch (Exception x) {
			x.printStackTrace();
			throw x;
		}
	}

	public static String prepSegmentKey(String expName, String subjectID,
			Integer visitID, String segmentName) {
		StringBuilder buf = new StringBuilder();
		buf.append(expName).append(':');
		buf.append(subjectID).append(':');
		buf.append(visitID).append(':');
		buf.append(segmentName);

		return buf.toString();
	}

	protected Object getFromCache(String key) {
		Cache cache = man.getCache("remote");
		Element el = cache.get(key);
		if (el == null)
			return null;
		return el.getObjectValue();
	}

	protected void put2Cache(String key, Object value) {
		Cache cache = man.getCache("remote");
		Element el = new Element(key, value);
		cache.put(el);
	}

	protected void dropFromCache(String key) {
		Cache cache = man.getCache("remote");
		if (cache != null)
			cache.remove(key);
	}

	@Override
	public void dbContentChanged(DBChangeEvent event) {
		String siteID = event.getDbChange().getSiteID();
		List<TableChange> tcList = event.getDbChange().getChanges();
		for (TableChange tc : tcList) {
			String tableName = tc.getTableName();
			if (tableName.endsWith("dataobjecttype")) {
				dropFromCache("dataobjecttype");
			} else if (tableName.endsWith("experiment")) {
				dropFromCache(siteID + ":experiment");
			} else if (tableName.endsWith("expsegment")) {
				dropFromCache(siteID + ":expsegment");
			} else if (tableName.endsWith("assessment")) {
				dropFromCache(siteID + ":asiScores");
				dropFromCache(siteID + ":assessment");
			} else if (tableName.endsWith("assessmentscore")) {
				dropFromCache(siteID + ":asiScores");
			} else if (tableName.endsWith("extendedtuple")) {
				dropFromCache(siteID + ":extendedtuple");
			} else if ( tableName.endsWith("expcomponent")) {
				dropFromCache(siteID + ":visitdate");
			}
		}

	}
	
	
	/*
	 * Jinran added
	 * Retrieve only assessment which subject data has for a specified experiment
	 */
	public List<AssessmentSelectionInfo> getAssessmentsWithScoresOnExp(
			String siteID, String expName) throws Exception {
//		String key = siteID + ":asiScores";
//		Object o = getFromCache(key);
//		if (o != null) {
//			if (o == NullObject.getInstance())
//				return null;
//			List<AssessmentSelectionInfo> origAsiList = (List<AssessmentSelectionInfo>) o;
//
//			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
//					origAsiList.size());
//			for (AssessmentSelectionInfo asi : origAsiList) {
//				AssessmentSelectionInfo newAsi = new AssessmentSelectionInfo(
//						asi, true, true);
//				asiList.add(newAsi);
//			}
//			// return a deep copy of the cached list for updates
//			return asiList;
//		}
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(siteID);
		if (dbID == null) {
			throw new RuntimeException("No database is setup for site:" + siteID);
		}
		
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = " select a.name, a.assessmentid, a.description, " +
						 " s.scorename, s.scoresequence, s.scoretype, s.scorelevel,s.description, i.itemleadingtext as leadingtext " +
						 " from nc_Assessment as a,	nc_Assessmentscore as s " +
						 " LEFT OUTER JOIN nc_assessmentitem AS i " +
						 " ON s.assessmentid=i.assessmentid AND s.scorename=i.scorename " +
						 " WHERE a.assessmentid = s.assessmentid " +
						 " 		 and a.assessmentid in " +
						 "			( select distinct assessmentid " +
						 "			  from nc_Assessmentdata " +
						 "			  where nc_storedassessment_uniqueid in " +
						 "				(select uniqueid from nc_Storedassessment " +
						 "				 where nc_experiment_uniqueid in (select uniqueid from nc_Experiment where name='" + expName + "')))";
			ResultSet rs = st.executeQuery(sql);			
			
			Map<BigDecimal, AssessmentSelectionInfo> asiMap = new HashMap<BigDecimal, AssessmentSelectionInfo>();
			
			while(rs.next()){
				AssessmentSelectionInfo asi = asiMap.get(rs.getBigDecimal(2));
				if (asi == null) {
					asi = new AssessmentSelectionInfo(rs.getString(1), rs.getBigDecimal(2));
					asi.setDescription(rs.getString(3));
					asiMap.put(asi.getAssessmentID(), asi);
				}
				AsScoreInfo si = new AsScoreInfo(rs.getBigDecimal(2));
				si.setName(rs.getString(4));
				si.setType(rs.getString(6));
				si.setSequence(rs.getInt(5));
				si.setLevel(rs.getInt(7));
				si.setDescription(rs.getString(8));
				si.setLeadingtext(rs.getString(9));
				asi.addScore(si);
			}
			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
					asiMap.values());

			Collections.sort(asiList,
					new Comparator<AssessmentSelectionInfo>() {
						public int compare(AssessmentSelectionInfo asi1,
								AssessmentSelectionInfo asi2) {
							return asi1.getName().compareToIgnoreCase(
									asi2.getName());
						}
					});
			for (AssessmentSelectionInfo asi : asiList)
				QueryWizardHelper.createTree(asi);

//			put2Cache(key, asiList);
			return asiList;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}

	}
	
//	
//	public List<SnpList> getAllSnpList(String siteID) throws Exception {
//		SnpList snpList = null;
//		List<SnpList> listSnpList = new ArrayList<SnpList>();
//
//		ISecurityService ss = ServiceFactory.getSecurityService();
//		String dbID = ss.findDBForSiteID(siteID);
//		if (dbID == null) {
//			throw new RuntimeException("No database is setup for site:" + siteID);
//		}
//		
//		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
//		Connection con = null;
//		try {
//			con = pool.getConnection(Constants.ADMIN_USER);
//			Statement st = null;
//			st = con.createStatement();
//			String sql = "select uniqueid, sessionid, snplistname, snplist from nc_geneticsnplist";
//			ResultSet rs = st.executeQuery(sql);
//
//			while(rs.next()){
//				snpList = new SnpList(BigInteger.valueOf(rs.getInt("uniqueid")), BigInteger.valueOf(rs.getInt("sessionid")), 
//						rs.getString("snplistname"), rs.getString("snplist"));
//				listSnpList.add(snpList);
//			}
//		
//			return listSnpList;
//			
//		}catch(Exception x){
//			x.printStackTrace();
//			throw x;			
//		}finally{
//			if (con != null)
//				pool.releaseConnection(Constants.ADMIN_USER, con);
//		}
//		
//	}
	
	@Override
	public List<Protocol> getAllValidProtocols(String primarySiteID, boolean forceRecache) throws Exception {
		String key = primarySiteID + ":allprotocols";
		
		if (forceRecache) {
			dropFromCache(key);
		} else {
			Object o = getFromCache(key);
			if (o != null) {
				if (o == NullObject.getInstance())
					return null;
				return (List<Protocol>) o;
			}
		}		
		
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(primarySiteID);
		if (dbID == null) {
			throw new RuntimeException("No database is setup for site:" + primarySiteID);
		}
		
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select distinct protocolid, protocolversion from nc_expsegment es, nc_experiment ep " + 
						"where es.nc_experiment_uniqueid = ep.uniqueid and ep.name like '%' " +
						"order by protocolid";
			ResultSet rs = st.executeQuery(sql);			
			
			List<Protocol> protocolList = new ArrayList<Protocol>();
			Protocol pro = null;
			while(rs.next()){				
				pro = new Protocol();
				pro.setProtocolid(rs.getString("protocolid"));
				pro.setProtocolversion(rs.getBigDecimal("protocolversion"));
				protocolList.add(pro);
			}						
			
			put2Cache(key, protocolList);
			return protocolList;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}		
	}

	@Override
	public List<Protocol> getProtocols(String primarySiteID, String expName, boolean forceRecache) throws Exception {
		String key = primarySiteID + ": " + expName + ":protocols";
		
		if (forceRecache) {
			dropFromCache(key);
		} else {
			Object o = getFromCache(key);
			if (o != null) {
				if (o == NullObject.getInstance())
					return null;
				return (List<Protocol>) o;
			}
		}		
		
		ISecurityService ss = ServiceFactory.getSecurityService();
		String dbID = ss.findDBForSiteID(primarySiteID);
		if (dbID == null) {
			throw new RuntimeException("No database is setup for site:" + primarySiteID);
		}
		
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Connection con = null;
		try {
			con = pool.getConnection(Constants.ADMIN_USER);
			Statement st = null;
			st = con.createStatement();
			String sql = "select distinct protocolid, protocolversion from nc_expsegment es, nc_experiment ep " + 
						"where es.nc_experiment_uniqueid = ep.uniqueid and ep.name='" + expName + "' " +
						"order by protocolid";
			ResultSet rs = st.executeQuery(sql);			
			
			List<Protocol> protocolList = new ArrayList<Protocol>();
			Protocol pro = null;
			while(rs.next()){				
				pro = new Protocol();
				pro.setProtocolid(rs.getString("protocolid"));
				pro.setProtocolversion(rs.getBigDecimal("protocolversion"));
				protocolList.add(pro);
			}
						
			
			put2Cache(key, protocolList);
			return protocolList;
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}		
		
	}

}
