package clinical.web.tags.sec;

import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.UserContainer;
import clinical.web.common.IAuthorizationService;
import clinical.web.exception.BaseException;

/**
 * @author I. Burak Ozyurt
 * @version $Id: NotAuthorizedTag.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class NotAuthorizedTag extends TagSupport {
	protected String privileges;
	private static final long serialVersionUID = 1L;

	public int doStartTag() throws JspException {
		HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
		HttpSession session = req.getSession(false);
		if (session == null)
			return SKIP_BODY;
		// check if there is a user container in the session (set after login
		// only)
		UserContainer userCon = (UserContainer) session
				.getAttribute(Constants.CONTAINER_KEY);

		if (userCon == null)
			return SKIP_BODY;
		String[] privilege = null;
		if (privileges.indexOf(',') == -1) {
			privilege = new String[] { privileges };
		} else {
			StringTokenizer stok = new StringTokenizer(privileges, " \t,");
			privilege = new String[stok.countTokens()];
			int i = 0;
			while (stok.hasMoreTokens()) {
				privilege[i++] = stok.nextToken();
			}
		}

		try {
			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();
			boolean hasAll = true;
			for (int i = 0; i < privilege.length; i++) {
				hasAll &= authService.isAuthorized(userCon.getUserInfo(),
						userCon.getDbID(), privilege[i]);
				if (!hasAll)
					break;
			}

			if (!hasAll)
				return SKIP_BODY;
		} catch (BaseException be) {
			throw new JspTagException(be.getMessage());
		}

		return EVAL_BODY_INCLUDE;
	}

	public void setPrivileges(String privileges) {
		this.privileges = privileges;
	}

}
