package clinical.web.vo;

import java.io.Serializable;
import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.Assertion;
import clinical.web.common.query.QueryPartInfo;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.SaveQueryForm;

/**
 * A wrapper class for holding assessment and analysis query info.
 *
 * @author I. Burak Ozyurt
 * @version $Id: QueryInfo.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class QueryInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	protected AssessmentQueryInfo aqi;
	protected AnalysisResultQueryInfo arqi;
	protected String expIDStr;
	
	//Jinran added
	private String protocols;
	private String versions;
	private String types;

	private String filterANDORAssessment;
	private String filterANDORImaging;
	private String filterANDORGenetics;
	

	public QueryInfo(AnalysisResultQueryInfo arqi) {
		super();
		this.arqi = arqi;
	}

	public QueryInfo(AssessmentQueryInfo aqi) {
		super();
		this.aqi = aqi;
	}

	/**
	 * if a query information is available set the selected state of the
	 * involved assessment and scores.
	 */
	public void prepareStoredQuery() {
		if (aqi != null && aqi.hasQueryParts()) {
			aqi.resetAllSelected();
			for (QueryPartInfo qpi : aqi.getQpiList()) {
				AssessmentSelectionInfo asi = aqi.findAsi(qpi.getAsi()
						.getAssessmentID());
				asi.setSelected(true);
				AsScoreInfo si = asi
						.findScoreInfo(qpi.getScoreInfo().getName());
				si.setSelected(true);
				if (qpi.getRhs() != null)
					si.setRhsValue(qpi.getRhs());
				si.setOperatorCode( qpi.getOperator() );
				
				//Jinran added
				if(qpi.getConnector()!=null)
					si.setConnector(qpi.getConnector());
				if(qpi.getLowBound()!=null)
					si.setLowBound(qpi.getLowBound());
				if(qpi.getUppBound()!=null)
					si.setUpBound(qpi.getUppBound());
				if(qpi.getOrder()!=null)
					si.setOrder(qpi.getOrder());
			}
		}
	}

	public AssessmentQueryInfo getAqi() {
		return aqi;
	}

	public void setAqi(AssessmentQueryInfo aqi) {
		this.aqi = aqi;
	}

	public AnalysisResultQueryInfo getArqi() {
		return arqi;
	}

	public void setArqi(AnalysisResultQueryInfo arqi) {
		this.arqi = arqi;
	}

	public JSONObject queryToJSON(String expID) throws JSONException {
		JSONObject js = new JSONObject();
		if (expID != null) {
			js.put("expId", expID);
			expIDStr = expID;
		}
		if (aqi != null) {
			JSONArray jsArr = aqi.queryToJSON();
			js.put("asQPIList", jsArr);
		}
		if (arqi != null) {
			JSONArray jsArr = arqi.queryToJSON();
			js.put("mgQPIList", jsArr);
		}
		
		//Jinran added
		if(this.protocols!=null){
			js.put("protocols", this.protocols);
		}
		if(this.types!=null){
			js.put("types", this.types);
		}
		if(this.versions!=null){
			js.put("versions", this.versions); 
		}
		
		if(this.filterANDORAssessment!=null){
			js.put("filterandorassessment", filterANDORAssessment);
		}
		if(this.filterANDORImaging!=null){
			js.put("filterandorimaging", filterANDORImaging);
		}
		if(this.filterANDORGenetics!=null){
			js.put("filterandorgenetics", filterANDORGenetics);
		}
		
		return js;
	}

	public JSONObject imagingqueryToJSON(JSONObject js, String selProtocols, 
			String selVersions, String selDataTypes) throws JSONException{
		if(selProtocols!=null){
			js.put("protocols", selProtocols);
		}
		if(selVersions!=null){
			js.put("version", selVersions);
		}
		if(selDataTypes!=null){
			js.put("types", selDataTypes);
		}
		
		return js;		
	}
	
	public void jsonToQuery(JSONObject js) throws JSONException {
		expIDStr = js.getString("expId");
		if (js.has("asQPIList")) {
			Assertion.assertNotNull(aqi);
			aqi.updateQueryFromJSON(js);
		}
		if (js.has("mgQPIList")) {
			if (arqi == null) {
				arqi = AnalysisResultQueryInfo.initializeFromJSON(js);
			} else {
				arqi.updateQueryFromJSON(js);
			}
		}
		
		//Jinran added
		if(js.has("protocols")){
			protocols = js.getString("protocols");	
		}
		if(js.has("versions")){
			versions = js.getString("versions");	
		}
		if(js.has("types")){
			types = js.getString("types");	
		}
		
		if(js.has("filterandorassessment")){
			filterANDORAssessment = js.getString("filterandorassessment");
		}
		if(js.has("filterandorimaing")){
			filterANDORImaging = js.getString("filterandorimaging");
		}
		if(js.has("filterandorgenetics")){
			filterANDORGenetics = js.getString("filterandorgenetics");
		}
	}

	public String getExpIDStr() {
		return expIDStr;
	}
	
	public void setProtocols(String protocols) {
		this.protocols = protocols;
	}

	public String getProtocols() {
		return protocols;
	}

	public void setVersions(String versions) {
		this.versions = versions;
	}

	public String getVersions() {
		return versions;
	}

	public void setTypes(String types) {
		this.types = types;
	}

	public String getTypes() {
		return types;
	}

	public String getFilterANDORAssessment() {
		return filterANDORAssessment;
	}

	public void setFilterANDORAssessment(String filterANDORAssessment) {
		this.filterANDORAssessment = filterANDORAssessment;
	}

	public String getFilterANDORImaging() {
		return filterANDORImaging;
	}

	public void setFilterANDORImaging(String filterANDORImaging) {
		this.filterANDORImaging = filterANDORImaging;
	}

	public String getFilterANDORGenetics() {
		return filterANDORGenetics;
	}

	public void setFilterANDORGenetics(String filterANDORGenetics) {
		this.filterANDORGenetics = filterANDORGenetics;
	}

}
