<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
 <%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>

<style>
.acb {
  margin-bottom:0.5em;
}

#autoCompleteMenu ul {
  width: 30em;
}
</style>

<script type="text/javascript">
	window.onloadListeners=new Array();
	
	window.addOnLoadListener = function (listener) {
		window.onloadListeners[window.onloadListeners.length]=listener;
	}
	
	window.onload=function(){
		for(var i=0;i<window.onloadListeners.length;i++){
			func = window.onloadListeners[i];
			func.call();
		}
	}
	
	window.addOnLoadListener(init);
	window.addOnLoadListener(onLoadHandler);

	//to render ass,img,gen panels at init()
	function init(){		
		var assPIndex = getCookie("assPanelIndex");
		var imgPIndex = getCookie("imgPanelIndex");
		var genPIndex = getCookie("genPanelIndex");		

		for(var i=1; i<=3; i++){
			if(assPIndex==i){
				addAssessPanel($('addAssDiv'));
				continue;
			}else if(imgPIndex==i){
				addImagingPanel($('addImgDiv'));
				continue;
			}else if(genPIndex==i){
				addGeneticsPanel($('addGenDiv'));
				continue;
			}
			break;
		}		
	}

  var helpSystem = null;
  //window.addOnLoadListener(onLoadHandler);
  
  function onLoadHandler() {
    var options = []; 
    var url = '<html:rewrite page="/help.do?context=as_query"/>';
    helpSystem = new bal.AjaxHelpSystem(url, options);
    handleAssessmentQPanelPopulation();
    ResetScrollPosition(null);
    //doScroll();    
  }

  var protocolList = <c:out value="${asSelectForm.proSelector.JSONStr}" escapeXml="false" />;  
  var protocolVers = <c:out value="${asSelectForm.proSelector.JSONStrVer}" escapeXml="false" />;
  var protocolDataTypes = <c:out value="${asSelectForm.proSelector.JSONStrTypes}" escapeXml="false" />;
  
  var asiList = <c:out value="${asSelectForm.queryInfo.aqi.JSONStr}" escapeXml="false" />;
  var scoreNames = null;
  var scoreNamesDesc = null;
  var scoreType = null;
  var scoreSequence = null;

  function populateProDataTypes(controlId){
	  var pSelector = $(controlId);
	  if(!pSelector) return;
	  if(pSelector.options.length==0){
		  for(var i=0; i<protocolDataTypes.length; i++){
			  var dtypes=protocolDataTypes[i];
			  var option = new Option(dtypes.typeName, dtypes.typeId);
			  if(i==0){
				  option.selected = true;				  
			  }
			  try{
				  pSelector.add(option,null);
			  }catch(e){
				  pSelector.add(option,-1);
			  }
		  }
	  }	  
	  
  }
  
  
  function populateProVerList(controlId){
	  var pSelector = $(controlId);
	  if(!pSelector) return;
	  if(pSelector.options.length==0){
		  for(var i=0; i<protocolVers.length; i++){
			  var ver=protocolVers[i];
			  var option = new Option(ver.verName, ver.verId);
			  if(i==0){
				  option.selected = true;				  
			  }
			  try{
				  pSelector.add(option,null);
			  }catch(e){
				  pSelector.add(option,-1);
			  }
		  }
	  }	  
  }
  
  function populateProtocolList(controlId){
	  var pSelector = $(controlId);
	  if(!pSelector) return;
	  if(pSelector.options.length==0){
		  for(var i=0; i<protocolList.length; i++){
			  var protocol=protocolList[i];
			  var option = new Option(protocol.name, protocol.id);
			  if(i==0){
				  option.selected = true;				  
			  }
			  try{
				  pSelector.add(option,null);
			  }catch(e){
				  pSelector.add(option,-1);
			  }
		  }
	  }
  }
  
  function handleAssessmentQPanelPopulation(asId) {
	 var asSelector;
	 if(asId == null){
     	asSelector = $('assessmentSel');
	 }else{
		asSelector = $(asId);
	 }
	 
     if (!asSelector) return;
	  var asiSelIdx = 0;
     if (asSelector.options.length == 0) {
	     for(var i = 0; i < asiList.length; i++) {
		     var asi = asiList[i];
			  var option = new Option(asi.name, asi.asId);
			  
			  if (i == 0) {
				  option.selected = true;
				  asiSelIdx = i;
			  }
			  try {
				  asSelector.add(option,null);
			  } catch(e) {
				  asSelector.add(option,-1);
			  }
	     }
     }
	  prepScorePanel(asiSelIdx, 'scp');
	  handleLoadedQuery();
  }
  
  function handleAssessmentChange() {
	  var asiSelector = $('assessmentSel');
	  if (!asiSelector) return;
	  prepScorePanel(asiSelector.selectedIndex, 'scp');
  }
  
  function prepScorePanel(asiSelIdx, divId) {
	  	if(!asiList[asiSelIdx]) return;
		var scores = asiList[asiSelIdx].scores;
		scoreNames = new Array();
		scoreNamesDesc = new Array();
		scoreType = new Array();
		scoreSequence = new Array(); 
		for(var i = 0; i < scores.length; i++) {
			scoreNames[i] = scores[i].name;
			if(scores[i].leadingtext){
				scoreNamesDesc[i] = scores[i].leadingtext;
			}else{
				scoreNamesDesc[i] = '&nbsp;';
			}
			if(scores[i].type=="varchar" || scores[i].type=="varchar2"){
				scoreType[i] = "text";
			}else if(scores[i].type=="timestamp"){
				scoreType[i] = "date";
			}else{
				scoreType[i] = scores[i].type;
			}
			if(scores[i].sequence){
				scoreSequence[i]=scores[i].sequence;
			}else{
				scoreSequence[i]='&nbsp;';
			}
		}
		new Autocompleter.Local('scoreField', 'autoCompleteMenu', 
            scoreNames, {choices : 20} );	
  }
  
  function setScoreField(value) {
     var scoreField = $('scoreField');
     if ( scoreField) {
        scoreField.value = value;
        var div = $('scp');
        if (div && div.popupViewer)
             div.popupViewer.hide();
     }
     return false;
  }
  
  /* function showAllScores(evt, elem) {
	  if (!elem) return false;
	  if (!scoreNames) return false;
     var mx = 0, my = 0;
     if (!evt) 
       evt = window.event;
     if (evt.pageX || evt.pageY)      {
       mx = evt.pageX;
       my = evt.pageY;
     } else if (evt.clientX || evt.clientY)   {
       mx = evt.clientX + document.body.scrollLeft
         + document.documentElement.scrollLeft;
       my = evt.clientY + document.body.scrollTop
         + document.documentElement.scrollTop;
     }
	  var content = "<table border='0' cellspacing='0' cellpadding='2'>";
     var noCols = 2;
     var noRows = Math.floor(scoreNames.length / noCols);
     if ( (scoreNames.length % noCols) > 0) noRows++;
     for(var i = 0; i < noRows; i++) {
		  content += "\n<tr>";
		  for(var j = 0; j < noCols; j++) {
			  content += "<td>";
			  var idx = i * noCols + j;
			  if ( idx < scoreNames.length)  {
              content += "<a href='javascript:{}' class='selectionlink' onclick=\"return setScoreField('" + scoreNames[idx]
                        + "');\">" + scoreNames[idx] + "</a>";
              
			  } else 
				  content += "&nbsp;";
			  content += "</td>"
		  }	
		  content += "</tr>";
	  }
     content+="</table>";
     bal.Popup.showPopup(mx, my, elem.parentNode, content);
     return false;
  } */

	function showAllScores(evt, elem) {
		if (!elem) return false;
		if (!scoreNames) return false;
		var mx = 0, my = 0;
		if (!evt) 
			evt = window.event;
		if (evt.pageX || evt.pageY)      {
			mx = evt.pageX;
			my = evt.pageY;
		} else if (evt.clientX || evt.clientY)   {
			mx = evt.clientX + document.body.scrollLeft
				+ document.documentElement.scrollLeft;
			my = evt.clientY + document.body.scrollTop
				+ document.documentElement.scrollTop;
		}
		var content = "<table border='1' cellspacing='0' cellpadding='1' width='640px' colspan='4'>";
		content += "\n<tr style='font-weight: bold;'><td>VARIABLES</td>"; 
		content += "<td>ITEM #</td>";
		content += "<td>TYPE</td>";
		content += "<td>QUESTION TEXT</td></tr>";
		var noRows = scoreNames.length;
		for(var i = 0; i < noRows; i++) {
			content += "\n<tr>";
			content += "<td>";
			content += "<a href='javascript:{}' class='selectionlink' onclick=\"return setScoreField('" + scoreNames[i]
                    	    + "');\">" + scoreNames[i] + "</a>";
			content += "</td>";
			content += "<td>" + scoreSequence[i] + "</td>";
			content += "<td>" + scoreType[i] + "</td>";
			content += "<td>" + scoreNamesDesc[i] + "</td>";
			content += "</tr>";
		}
		content+= "</table>";
		bal.Popup.showPopup(mx, my, elem.parentNode, content, elem.parentNode);
		return false;
	}
	

  
  function compareOrder(a, b){
	  var orderA = a.order, orderB = b.order;
	  if(orderA < orderB)
		  return -1;
	  else if(orderA > orderB)
		  return 1;
      else
		return 0;
  }
  
  function handleLoadedQuery() {
	  var div = $('qbp');
	  for(var i = 0; i < asiList.length; i++) {
		  var asi = asiList[i];		  
		  if (asi.selected) {
			  var aqpId = asi.name.replace(/\s+/g,'_');
			  var asiQPartPanel = $(aqpId);
			  if (!asiQPartPanel) {
				  asiQPartPanel = utils.newDomNode('div', aqpId);
				  div.appendChild(asiQPartPanel);
				  new Insertion.Bottom(asiQPartPanel,
					  "<p><b>" + asi.name + "</b></p>");
			  }
			  

			  //Jinran added. Add selected score to an array and sort by order
			  var sortedScore = new Array();
			  var k = 0;
			  for(var j=0; j < asi.scores.length; j++){				  
				  if (asi.scores[j].selected){
					  sortedScore[k] = asi.scores[j];
					  k++;
				  }
			  }			 
			  if(sortedScore.length > 1){
				  sortedScore.sort(compareOrder)
			  }
				  
			  
			  //Jinran mod
			  //for(var j=0; j < asi.scores.length; j++) {				  
			  //	  if (asi.scores[j].selected) {			  
					  //var score = asi.scores[j];
				for (var j=0; j < sortedScore.length; j++){
					  var score = sortedScore[j];				
					  
					  var useConnector = isConnectorRequired();
					  var ajaxResults = new Array();
	              	  var url = '<html:rewrite page="/caquery.do?actionParam=getScorecodes"/>';
					  var idPrefix = asi.asId + "__" + score.name.replace(/\s+/g,':');
					  
					  new Ajax.Request(url,  { method:"get", asynchronous: false, 
			          encoding: 'ISO-8859-1', evalJSON : false,
			          parameters: {asID: asi.asId, scoreName: score.name},
			          onSuccess: function(response) {
				       var ro = eval('(' + response.responseText + ')');					 
					      if (ro.hasEnums)  
								ajaxResults.push( ro );					 
						 }
					  });
					 
					  addQueryPart(asiQPartPanel, idPrefix, score.name, score.type, useConnector, 
						  ajaxResults, score.operator, score.rhs, score.connector, score.lowBound, score.uppBound);//Jinran Mod
				}
		  }
	  }     
  }
  
  function handleAddQueryPart() {
	  var asiSelector = $('assessmentSel');
	  if (!asiSelector) return;
	  var scoreField = $('scoreField');
	  if (!scoreField || !scoreField.value) {
		  //TODO show validation message
		  return false;
	  }
	  var asi = asiList[ asiSelector.selectedIndex ];
	  var score = findScore(asi, scoreField.value);
	  if (!score) {
		  alert("Not a valid score:" + scoreField.value);
		  scoreField.value='';
		  return false;
	  }
	  var div = $('qbp');
	  var aqpId = asi.name.replace(/\s+/g,'_');
	  //alert('aqpId:' + aqpId);
	  var asiQPartPanel = $(aqpId);
	  if (!asiQPartPanel) {
		  asiQPartPanel = utils.newDomNode('div', aqpId);
		  div.appendChild(asiQPartPanel);
		  new Insertion.Bottom(asiQPartPanel,
			  "<p><b>" + asi.name + "</b></p>");
	  }
	  var useConnector = isConnectorRequired();
	  
	  var idPrefix = asi.asId + "__" + score.name.replace(/\s+/g,':');
	  var ajaxResults = new Array();
	  var url = '<html:rewrite page="/caquery.do?actionParam=getScorecodes"/>';
	  new Ajax.Request(url,  { method:"get", asynchronous: false, 
			  encoding: 'ISO-8859-1', evalJSON : false,
			  parameters: {asID: asi.asId, scoreName: score.name},
			  onSuccess: function(response) {
					 var ro = eval('(' + response.responseText + ')');					 
					 if (ro.hasEnums)  {
				      ajaxResults.push( ro );
					 }
			  },
			  onException: function(transport,e){
				  // no op
		     }			
		  });
	  addQueryPart(asiQPartPanel, idPrefix, score.name, score.type, useConnector, ajaxResults); 
	  
	  scoreField.value='';
	  return false;
  }
  
  function findScore(asi, scoreName) {
	  var list = asi.scores;
	  for(var i = 0; i < list.length; i++)
		  if (list[i].name == scoreName)
		     return list[i];
	  return null;
  }
  
  function isConnectorRequired() {
	  var div = $('qbp');
	  var els = div.getElementsByTagName('div');
	  if (!els) return false;
	  for(	var i = 0; i < els.length; i++) {
		  var scoreDivs = els[i].getElementsByTagName('div');
		  if ( scoreDivs && scoreDivs.length > 0) return true;		 
     }
	  return false;
  }
  
  
  function addQueryPart(container, idPrefix, colName, colType, useConnector, ajaxResults, opCode, rhsValue, andOrConnect, low, up) {
     var divId = idPrefix + "__qp";
     if ( $(divId) ) {
       return;
     }
     var div = utils.newDomNode('div', divId);
     container.appendChild(div);
     if ( useConnector) {
    	var rbDivId = idPrefix + "__connector";
        var rbDiv = utils.newDomNode('div',rbDivId);
        div.appendChild(rbDiv);
        
        //Jinran added
        var andCon=false;
        var orCon=false;        
        if (andOrConnect!=null){        	
        	if(andOrConnect=="AND"){
            	andCon=true;
            	orCon=false;
            }
            else if (andOrConnect=="OR"){
            	andCon=false;
            	orCon=true;
            }
            else if(andOrConnect=="NONE"){
            	andCon=true; 
            	orCon=false;
            }	
        }else{        	
        	andCon=true;
        	orCon=false;
        }
        
        var andButton = utils.newRadioBut(idPrefix + "__and",rbDivId, "AND","AND",andCon);//Jinran Mod
        var orButton = utils.newRadioBut(idPrefix + "__or",rbDivId, "OR","OR",orCon);//Jinran Mod
        rbDiv.appendChild(andButton);
        new Insertion.After(andButton,"&nbsp;");
        rbDiv.appendChild(orButton);        
     }
     new Insertion.Bottom(div,colName + " &nbsp;");
     if (colType != 'varchar') {
        var opts = [ {value:1, label:'='}, {value:2, label:'>'} ,
          {value:3, label:'<'}, {value:4, label:'<>'},
          {value:5, label:'>='}, {value:6, label:'<='}];
          var sel = utils.createSelect(idPrefix + "__operator", opts);          
          div.appendChild( sel );
			 if (ajaxResults && ajaxResults.length == 1) {				 
				 var enumOpts = [];
				 var enums = ajaxResults[0].sci;
				 enumOpts.push( {value: '*', label: '*'});
				 for(var i = 0; i < enums.length; i++) 
					 enumOpts.push( {value: enums[i].c, label : enums[i].l} );
				 var enumSel = utils.createSelect(idPrefix + "__enums", enumOpts);
				 new Insertion.Bottom(div, "&nbsp;");
				 div.appendChild( enumSel );
				  var html = "&nbsp;<input type='button' name='Remove' value='Remove' "
				  + "onclick=\"return qb.removeQueryPart('"+ divId + "');\"></input>";
				  new Insertion.Bottom(div,html);
				  if (rhsValue) {					   
					   for(var i = 0; i < enumSel.options.length; i++) 
						   if (enumSel.options[i].value == rhsValue) enumSel.options[i].selected = true;
						   else enumSel.options[i].selected = false;
					  
				  }
			 } else {
     
				 new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
					 + idPrefix + "__rhs' size='8' value='*'></input>");
				 var html = "<br> <span style='margin-left:50px; line-height:1.5em;' >" 
				 + "Between <input type='text' id='" + idPrefix + "__lb' size='8' value=''>"
				 + " and "	 
				 +  "<input type='text' id='" + idPrefix + "__ub' size='8' value=''>&nbsp;"
				 +  "<input type='button' name='Remove' value='Remove' onclick=\"return qb.removeQueryPart('"
				 + divId + "');\"></input>";
				 new Insertion.Bottom(div,html);
				 if (rhsValue) {
						$(idPrefix + "__rhs").value = rhsValue;						
				 }
				 if(low){
					 $(idPrefix + "__lb").value = low;
				 }
				 if(up){
					 $(idPrefix + "__ub").value = up;
				 }
					 
			 }
			 if (opCode) {
				 for(var i = 0; i < sel.options.length; i++) 
					 if (sel.options[i].value == opCode) sel.options[i].selected = true;
					 else sel.options[i].selected = false;
			 }
     } else {
		  var opts = [ {value:1, label:'='}, {value:100, label:'starts with'} ,
          {value:101, label:'ends with'}, {value:102, label:'any of'}];
        var sel = utils.createSelect(idPrefix + "__operator", opts);          
		  div.appendChild( sel );
     
        new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
        	    + idPrefix + "__rhs' size='12' value='*'></input>&nbsp;"
				 + "<input type='button' name='Remove' value='Remove' onclick=\"return qb.removeQueryPart('"
				 + divId + "');\"></input>");
      
        //Jinran added
        if (rhsValue) {
			$(idPrefix + "__rhs").value = rhsValue;						
        }
        if (opCode) {
			 for(var i = 0; i < sel.options.length; i++) 
				 if (sel.options[i].value == opCode) sel.options[i].selected = true;
				 else sel.options[i].selected = false;
     	}
     }
  }
  
  function buildQuery(verbose, fileType) {	  
     var asiSelector = $('assessmentSel');
     if ( !asiSelector) return;
     var div = $('qbp');
     var els = $A(div.getElementsByTagName('div'));
     if (!els) {
        alert("At least one criterion needs to be specified for querying!");
		  return false;
     }
     var aqJSON = "{asQPIList: [";
     var first = true;
     //var desc = "";
     //desc =els.inject(desc, function(s,value, idx) { 
     //  if (value && value.id) s += value.id + "\n"; return s; } );
     //alert("els:" + desc);
	  var count = 0;         
     for(var i = 0; i < els.length; i++) {
		   var asName = els[i].id.replace(/_/g,' ');
			var scoreDivs = els[i].getElementsByTagName('div');	
			for(var j = 0; j < scoreDivs.length; j++) {
				if (!scoreDivs[j] || !utils.strEndsWith(scoreDivs[j].id,"__qp")) continue;
				//alert("scoreDivs[" + j + "]:" + scoreDivs[j].id);
				var toks = scoreDivs[j].id.split('__');	
				if (!toks) continue;
				var asi = findAssessment(toks[0]);
				if(!asi) continue;
				var scoreName = toks[1].replace(/:/g,' ');
				var score = findScore(asi, scoreName);
				if(!score) continue;
	         var idPrefix = scoreDivs[j].id.replace(/__qp$/,'');                 
	         if (first) 
                first = false;
            else aqJSON += ", ";
	         
	         	aqJSON += "{ asi: { name: '" + asi.name + "', asId:" + asi.asId + "},"
 				+ "score:{ name: '" + score.name + "', type: '" + score.type + "'}, ";
				
 				//Jinran added
				//aqJSON += "{ asi: { name: '" + asi.name + "', asId:" + asi.asId + "},"
				//+ "score:{ name: '" + score.name + "', type: '" + score.type + "', order: '" + count + "'}, ";				
				aqJSON += "order: '" + count + "',";
				
				
				aqJSON += "connector: '";
				var andRB = $(idPrefix + "__and");
				if (andRB) {
					aqJSON += (andRB.checked) ? "AND'," : "OR',";
				} else {
					aqJSON += "NONE',";
				}
				//var selId = idPrefix + "__operator";
				//alert("selId:" + selId);
				var sel = $(idPrefix + "__operator");
				aqJSON += "operator: " + sel.options[sel.selectedIndex].value;
				var rhs = $(idPrefix + "__rhs");
				if (rhs && rhs.value) {
            	   var rhsVal = utils.trim(rhs.value);
						if ( rhsVal.length > 0) 
							aqJSON += ", rhs : '" + rhsVal + "'";		    
				} else {
					rhs = $(idPrefix + "__enums");
					if (rhs) 
						aqJSON += ", rhs : '" + rhs.options[rhs.selectedIndex].value + "'";
				}
				var lowBound = $(idPrefix + "__lb");
				if (lowBound && lowBound.value) {
					var val = utils.trim(lowBound.value);
					if ( val.length > 0)  
						aqJSON += ", lowBound: '" + val + "'";
				}		 
            var uppBound = $(idPrefix + "__ub");
				if (uppBound && uppBound.value) {
					var val = utils.trim(uppBound.value);
					if ( val.length > 0)  
						aqJSON += ", uppBound: '" + val + "'";
				}  
				aqJSON += "}\n";		
				count++;
			}// j
	  } //i
	aqJSON += "]}\n";
	  if (count == 0) {		  
		  if(fileType=="MAP" || fileType=="PED" || fileType=="Gene"){
			  return null;
		  }else{
		  	alert("At least one score is necessary for querying clinical data!");
		  	return null;			  
		  }
	  }
	  if(verbose) alert(aqJSON);
     return aqJSON;
  }
  
     

     function buildAsQuery(aqJSON){
    	 var asiSelector = $('assessmentSel');
			if ( !asiSelector) return;
			var div = $('qbp');
			var els = $A(div.getElementsByTagName('div'));
			if (!els) {
		    	alert("At least one criterion needs to be specified for querying!");
				return false;
			}		    
			
			if(aqJSON.length>1){
				aqJSON+=",";
			}
			aqJSON += "asQPIList: [";
		    var first = true;
		     //var desc = "";
		     //desc =els.inject(desc, function(s,value, idx) { 
		     //  if (value && value.id) s += value.id + "\n"; return s; } );
		     //alert("els:" + desc);
			var count = 0;         
		    for(var i = 0; i < els.length; i++) {
				var asName = els[i].id.replace(/_/g,' ');
				var scoreDivs = els[i].getElementsByTagName('div');	
				for(var j = 0; j < scoreDivs.length; j++) {
					if (!scoreDivs[j] || !utils.strEndsWith(scoreDivs[j].id,"__qp")) continue;
					//alert("scoreDivs[" + j + "]:" + scoreDivs[j].id);
					var toks = scoreDivs[j].id.split('__');	
					if (!toks) continue;
					var asi = findAssessment(toks[0]);
					if(!asi) continue;
					var scoreName = toks[1].replace(/:/g,' ');
					var score = findScore(asi, scoreName);
					if(!score) continue;
			        var idPrefix = scoreDivs[j].id.replace(/__qp$/,'');                 
			        if (first) 
		            	first = false;
		            else aqJSON += ", ";
			        aqJSON += "{ asi: { name: '" + asi.name + "', asId:" + asi.asId + "},"
		 				+ "score:{ name: '" + score.name + "', type: '" + score.type + "'}, ";
						
		 			//Jinran added
					//aqJSON += "{ asi: { name: '" + asi.name + "', asId:" + asi.asId + "},"
					//+ "score:{ name: '" + score.name + "', type: '" + score.type + "', order: '" + count + "'}, ";				
					aqJSON += "order: '" + count + "',";
					
					aqJSON += "connector: '";
					var andRB = $(idPrefix + "__and");
					if (andRB) {
						aqJSON += (andRB.checked) ? "AND'," : "OR',";
					} else {
						aqJSON += "NONE',";
					}
						//var selId = idPrefix + "__operator";
						//alert("selId:" + selId);
					var sel = $(idPrefix + "__operator");
					aqJSON += "operator: " + sel.options[sel.selectedIndex].value;
					var rhs = $(idPrefix + "__rhs");
					if (rhs && rhs.value) {
		            	var rhsVal = utils.trim(rhs.value);
						if ( rhsVal.length > 0) 
							aqJSON += ", rhs : '" + rhsVal + "'";		    
					} else {
						rhs = $(idPrefix + "__enums");
						if (rhs) 
							aqJSON += ", rhs : '" + rhs.options[rhs.selectedIndex].value + "'";
					}
					var lowBound = $(idPrefix + "__lb");
					if (lowBound && lowBound.value) {
						var val = utils.trim(lowBound.value);
						if ( val.length > 0)  
							aqJSON += ", lowBound: '" + val + "'";
					}		 
		            var uppBound = $(idPrefix + "__ub");
					if (uppBound && uppBound.value) {
						var val = utils.trim(uppBound.value);
						if ( val.length > 0)  
							aqJSON += ", uppBound: '" + val + "'";
					}  
					aqJSON += "}\n";		
					count++;
					}// j
			  } //i
		aqJSON += "]}\n";
		return aqJSON;
     }
  
	// return the value of the radio button that is checked
	// return an empty string if none are checked, or
	// there are no radio buttons
	function getCheckedValue(radioObj) {
		if(!radioObj)
			return "";
		var radioLength = radioObj.length;
		if(radioLength == undefined)
			if(radioObj.checked)
				return radioObj.value;
			else
				return "";
		for(var i = 0; i < radioLength; i++) {
			if(radioObj[i].checked) {
				return radioObj[i].value;
			}
		}
		return "";
	}
  
	function buildGeneQuery(aqJSON, elem){
		var sessionID = $('selectedSSId');
		aqJSON += "sessionid: '" + sessionID.options[sessionID.selectedIndex].text + "'";
		var expSessionStyleId = $('expSessionStyleId');
		aqJSON += "expSessionStyleId: '" + expSessionStyleId.options[expSessionStyleId.selectedIndex].text + "'";
		var chipIdStyleId = $('chipIdStyleId');
		aqJSON += "chipIdStyleId: '" + chipIdStyleId.options[chipIdStyleId.selectedIndex].text + "'";
		aqJSON += "chipIdAndOr: '" + getCheckedValue(document.getElementsByName('chipIdAND')) + "'";
			
		var inputs = elem.form.elements;
		var getCount=0;
		for (var i = 0; i < inputs.length; i++) {
			//check if any Get fields is selected
			if(inputs[i].type=="checkbox" && inputs[i].name.indexOf("results")===0){				
				if(inputs[i].checked){
					results[getCount]=true;
					aqJSON += "results[" + getCount + "]: 'true'";
					getCount++;
				}
			}
		}
				
			
		return aqJSON;
	}
	
	function buildQueryForSaveQueryFun(verbose, elem) {
		var assPIndex = getCookie("assPanelIndex");
		var imgPIndex = getCookie("imgPanelIndex");
		var genPIndex = getCookie("genPanelIndex");
		
		var aqJSON = "{";
		
		if(genPIndex>0){
			aqJSON = buildGeneQuery(aqJSON, elem);
		}
		
		if(assPIndex>0){			
			aqJSON = buildAsQuery(aqJSON);
		}else if(imgPIndex>0 && genPIndex<=0){
			if(aqJSON.length>1){
				aqSJON+=",";
			}
			aqJSON += "asQPIList: []}\n";			
		}
		
		return aqJSON;
	  }
     
     function findAssessment(asId) {
	  for(var i = 0; i < asiList.length; i++) {
			if (asiList[i].asId == asId)
				return asiList[i];
	  }
	  return null;
	 }
  
  function queryAll(elem){
	  if(filterOrder.length==1){
		  if(filterOrder[0]=="Assessment"){
			  query(elem);
		  }else if(filterOrder[0]=="Imaging"){
			  queryImage(elem);
		  }
	  }else if(filterOrder.length==2){
		  if(filterOrder.indexOf("Assessment")!=-1){
			  var andOrName = "filterANDOR"+filterOrder[1];
			  var andOrVar = document.getElementsByName(andOrName);
			  var andOrValue;
			  for(var i=0; i<andOrVar.length; i++){
				  if(andOrVar[i].checked){
					  andOrValue = andOrVar[i].value;
					  break;
				  }
			  }
			  if(andOrValue=="AND"){
				  query(elem);
			  }else{
				  queryOld(elem, "AssessmentOrImaging");
			  }
		  }
	  }
	  
  }
  
  function queryOld(elem, strQueryType){
	  var json = buildQuery();
		if (!json) return false;
		elem.form.actionParam.value='query';
		if(strQueryType!=null){
			elem.form.queryType.value=strQueryType;			
		}
			
		elem.form.queryString.value=json;
    //alert("query:" + json);
    
      var selPros = getSelectedProtocols();
    	elem.form.selProtocols.value = selPros;
    	//alert("Selected Protocols: " + selPros);
    	
    	var seltypes = getSelectedDataTypes();
    	elem.form.selDTypes.value = seltypes;      	
    	
    	var selVers = getSelectedVersions();
    	elem.form.selVersions.value = selVers;
    	//alert("Selected versions: " + selVers);
    	
    	var validateChk = $('tValid');
    	var notValidateChk = $('fValid');
    	if(validateChk.checked){
    		elem.form.validateText.value = "Validated";
    		if(notValidateChk.checked){ 
    			elem.form.validateText.value = "BothValidatedAndInvalid";
    		}
    	}else{
    		elem.form.validateText.value = "NotValidated";
    	}
    	
		elem.form.submit();
		//alert("selected data types:" + elem.form.selDTypes.value);
		return false;
  }
  
  function query(elem) {
	  queryOld(elem, null);
  }
  
  //Jinran added for query imaging data only
  function queryImage(elem){
	  elem.form.actionParam.value = 'query';
	  elem.form.queryString.value='';
	  
	  var selPros = getSelectedProtocols();
	  elem.form.selProtocols.value = selPros;
	  
	  var seltypes = getSelectedDataTypes();
	  elem.form.selDTypes.value = seltypes;
	  
	  var selVers = getSelectedVersions();
	  elem.form.selVersions.value = selVers;
	  //alert("Selected versions: " + selVers);
	  
	  elem.form.queryType.value="ImagingOnly";
	  
	  elem.form.submit();
	  //alert("selected data types:" + elem.form.selDTypes.value);
	  return false;
  }
  
  function getSelectedVersions(){
		var select = document.getElementById("selProtocolVers");
		var myvalue = "";
		if(!select){return myvalue;}
		for(var i=0; i<select.options.length;i++){
			if(select.options[i].selected){
				myvalue = myvalue + select.options[i].text + "#";				
			}
		}
		return myvalue;	  
  }
  
  function getSelectedDataTypes(){	
		var select = document.getElementById("selTypeIds");	
		var myvalue = "";
		if(!select){return myvalue;}
		for(var i=0; i<select.options.length;i++){
			if(select.options[i].selected){
				myvalue = myvalue + select.options[i].text + "#";
				//alert(myvalue);
			}
		}
		return myvalue;
	}
  
  function getSelectedProtocols(){	
	var select = document.getElementById("selProtocolIds");
	var chosen = "";
	if(!select){return chosen;}	
	for(var i=0; i<select.options.length;i++){
		if(select.options[i].selected){
			chosen = chosen + select.options[i].text + "#";
			//alert(chosen);
		}
	}
	return chosen;
  }


  //return "AND","OR" for filterANDOR Condition
  function getFilterANDOR(name){	  
	  var andOrName = "filterANDOR"+name;
	  var andOrVar = document.getElementsByName(andOrName);
	  
	  var andOrValue;
	  for(var i=0; i<andOrVar.length; i++){
		  if(andOrVar[i].checked){
			  andOrValue = andOrVar[i].value;
			  break;
		  }
	  }
	  if(typeof andOrValue === "undefined") return null;
	  return andOrValue;
  }
  
  function msQuery(elem) {
     var json = buildQuery();
     if (!json) return false;
     elem.form.actionParam.value='msQuery';
     elem.form.queryString.value=json;
     //alert("msQuery:" + json);    
     
     var selPros = getSelectedProtocols();
     elem.form.selProtocols.value = selPros;
    
     var seltypes = getSelectedDataTypes();
     elem.form.selDTypes.value = seltypes;      	
    
     var selVers = getSelectedVersions();
     elem.form.selVersions.value = selVers;

     elem.form.submit();
     return false;   
  }
  
  function saveQuery(elem) {
	  var json = buildQueryForSaveQueryFun("", elem);
	  if (!json) return false;
	  SaveScrollXY();
	  elem.form.actionParam.value='saveQuery';
	  elem.form.queryString.value=json;
	  
	  var selPros = getSelectedProtocols();
      elem.form.selProtocols.value = selPros;

      var seltypes = getSelectedDataTypes();
      elem.form.selDTypes.value = seltypes;

      var selVers = getSelectedVersions();
      elem.form.selVersions.value = selVers;
	  
      var varGenetics = getFilterANDOR("Genetics");
      elem.form.filterANDORGen.value = varGenetics;

      var filterANDORAssess = getFilterANDOR("Assessment");
      elem.form.filterANDORAssess.value = filterANDORAssess;
      
      var filterANDORImg = getFilterANDOR("Imaging");
      elem.form.filterANDORImg.value = filterANDORImg;     
      
	  elem.form.submit();
	  return false;	
  }

  function loadQuery(elem) {	  
	  SaveScrollXY();
	  elem.form.actionParam.value='loadSavedQuery';
	  elem.form.submit();
	  return false;	 
  }
  
  function changeTab(elem) {
	  var div = $('qbp');
     var els = $A(div.getElementsByTagName('div'));
	  var form = $('qtf');
     if (els && els.length > 0) {
		  var json = buildQuery();
		  if (json) {
			  form.caQueryString.value = json;
		  }
	  }
	  form.submit();		
	  return false;	   
  }
  
  function changeExperiment(selectItem){
	  var ass = $('assessmentSel');
	  if(ass) ass.options.length = 0;
	  var selOption = selectItem.options[ selectItem.selectedIndex ];
	  var form = selectItem.form;
	  
	  SaveScrollXY();
	  form.curExp.value = selOption.text;
	  form.actionParam.value = 'changeExp';
	  form.submit();
	  return false;
  }
  
  function changeExpSession(selectItem){	  
	  var selOption = selectItem.options[ selectItem.selectedIndex ];
	  var form = selectItem.form;
	  
	  SaveScrollXY();
	  form.curExpSs.value = selOption.text;
	  form.actionParam.value = 'changeExpSession';
	  form.submit();
	  return false;
  }
  
  function changeSession(selectItem){
	  var selOption = selectItem.options[ selectItem.selectedIndex ];
	  var form = selectItem.form;
	  
	  SaveScrollXY();
	  form.curSs.value = selOption.text;
	  form.actionParam.value = 'changeSession';
	  form.submit();
	  return false;
  }
  
	function del(elem){
		var selQuery = $('selectedQuery');
		var selOption = selQuery.options[selQuery.selectedIndex];
		var ans = confirm("Are you sure you want to delete the query of " + selOption.text + "?");		
		
		if(ans){
			var form=elem.form;
			//delete query			
			form.actionParam.value = 'deleteQuery';
			form.queryName.value = selOption.text;			
			form.cancelDelete.value = 'no';			
			form.submit();
			return true;
		}else{
			return false;
		}		
	}

  
	function newSession(){		
		SaveScrollXY();		
		window.location.href = '<html:rewrite page="/genenewsession.do?actionParam=show"/>';
	}

	function delSession(elem){
		SaveScrollXY();
		var selSession = $('selectedSSId');
		var selSName = selSession.options[selSession.selectedIndex];
		var ans = confirm("Are you sure you want to delete the Session of '" + selSName.text + "'?");
		
		if(ans){
			var form = elem.form;
			form.actionParam.value = 'deleteSession';
			form.sessionIdText.value = selSName.text;
			form.cancelDelete.value = 'no';	
			form.submit();
			return true;
		}else{
			return false;
		}
	}
	
	function toggleSnp(hide){		
 		if(hide==true){
			$('trSnpName').style.display = 'none';
	 		$('trSnpValue').style.display = 'none';
	 		$('trBtn').style.display = 'none';
		}else{			
			$('trSnpName').style.display = '';
 			$('trSnpValue').style.display = '';
 			$('trBtn').style.display = '';
		}
 	}
	
	function toggleGene(hide){		
 		if(hide==true){
			$('trGeneName').style.display = 'none';
	 		$('trGeneValue').style.display = 'none';
	 		$('trGeneBtn').style.display = 'none';
		}else{			
			$('trGeneName').style.display = '';
 			$('trGeneValue').style.display = '';
 			$('trGeneBtn').style.display = '';
		} 
	}

	var addOrUpdate;
	var geneAddOrUpdate;
	
	// New btn hit
	function addNewSnpList(elem){	
		var name = $('snpNameId');
		name.value = '';
		var snpList = $('snpValueId');
		snpList.value = '';
		
		addOrUpdate = "add";
		toggleSnp(false); 
	}	

	function addNewGeneList(elem){
 		var genename = $('geneNameId');
		genename.value = '';
		var geneList = $('geneValueId');
		geneList.value = '';
		
		geneAddOrUpdate = "add";
		toggleGene(false); 
	}	

	var oldSnpName;
	var oldGeneName;
	
	// Edit btn hit	
	function editSnpGeneList(elem){
 		var checkboxes;
		var rows;
		var name;
		var snpgeneList;
		
		if(elem.name=="editGene" || elem.name=="geneCheckId"){
			checkboxes = elem.form.geneCheckId;
			rows = document.getElementById('tableGeneList').rows;
			name = $('geneNameId');
			snpgeneList= $('geneValueId');
		}else if(elem.name=="editSnp" || elem.name=="checkId"){
			checkboxes = elem.form.checkId;
			rows = document.getElementById('tableSnpList').rows;
			name = $('snpNameId');
			snpgeneList = $('snpValueId');
		}
		
   		var selectSnpGeneName;
   		var selectSnpGeneList;  		
		 		
   		if(checkboxes.length!=undefined){
	  		for (i=0; i<checkboxes.length; i++) {  		
	 			if(checkboxes[i].checked == true){	 				
	 				if(elem.name=="editGene"|| elem.name=="geneCheckId"){
	 					toggleGene(false);
	 				}else if(elem.name=="editSnp" || elem.name=="checkId"){
	 					toggleSnp(false);
	 				}
	 				selectSnpGeneName = rows[i+1].cells[1].innerHTML;
	 				selectSnpGeneList = rows[i+1].cells[2].innerHTML;	 				
	 				name.value = selectSnpGeneName;
	 				
	 				if(elem.name=="editGene"|| elem.name=="geneCheckId"){
	 					oldGeneName = selectSnpGeneName;
	 				}else if(elem.name=="editSnp" || elem.name=="checkId"){
	 					oldSnpName = selectSnpGeneName;
	 				}
	 				snpgeneList.value = selectSnpGeneList;
	 				
	 				if(elem.name=="editGene"|| elem.name=="geneCheckId"){
	 					geneAddOrUpdate = "update";	
	 				}else if(elem.name=="editSnp" || elem.name=="checkId"){
	 					addOrUpdate = "update";
	 				}
	 				
	 				return false;
	 			}
	 		}
   		}else{
   			if(checkboxes.checked == true){
   				if(elem.name=="editGene"|| elem.name=="geneCheckId"){
 					toggleGene(false);
 				}else if(elem.name=="editSnp" || elem.name=="checkId"){
 					toggleSnp(false);
 				}
 				selectSnpGeneName = rows[1].cells[1].innerHTML;
 				selectSnpGeneList = rows[1].cells[2].innerHTML; 				
 				name.value = selectSnpGeneName;
 				if(elem.name=="editGene"|| elem.name=="geneCheckId"){
 					oldGeneName = selectSnpGeneName;
 				}else if(elem.name=="editSnp" || elem.name=="checkId"){
 					oldSnpName = selectSnpGeneName;
 				} 				
 				snpgeneList.value = selectSnpGeneList;
 				
 				if(elem.name=="editGene"|| elem.name=="geneCheckId"){
 					geneAddOrUpdate = "update";	
 				}else if(elem.name=="editSnp" || elem.name=="checkId"){
 					addOrUpdate = "update";
 				}
 				return false;
 			}
   		}
  		
  		alert("Please select a row to edit!");
  		if(elem.name=="editGene"|| elem.name=="geneCheckId"){
  			toggleGene(true);	
		}else if(elem.name=="editSnp" || elem.name=="checkId"){
			toggleSnp(true);
		} 
  		
	}
	
	// Delete btn hit	 	
 	function deleteSnpGeneList(elem){
 		var checkboxes;
 		var selectSessionName;
 		var rows;
 		var elemName;
 		var paraValue;
 		
 		if(elem.name=="deleteGene"){
 			checkboxes = elem.form.geneCheckId;
 			rows = document.getElementById('tableGeneList').rows;
 			elemName = "gene list";
 			paraValue = 'deleteGeneList'
 		}else if(elem.name=="deleteSnp"){
 			checkboxes = elem.form.checkId;
 			rows = document.getElementById('tableSnpList').rows;
 			elemName = "snp list";
 			paraValue = 'deleteSnpList'
 		}
 				
		var selectSnpGeneName;
		var selectSnpGeneList;		

		if(checkboxes.length!=undefined){
			for (i=0; i<checkboxes.length; i++) {  		
	 			if(checkboxes[i].checked == true){ 				
	 				selectSnpGeneName = rows[i+1].cells[1].innerHTML;
	 				selectSnpGeneList = rows[i+1].cells[2].innerHTML;
	 				var ans = confirm("Are you sure you want to delete " + elemName + " of '" + selectSnpGeneName + "'?");
	 				
	 				if(ans){
	 					var form=elem.form; 					
	 					form.actionParam.value = paraValue;
	 					form.snpgeneNameText.value = selectSnpGeneName;
	 					form.cancelDelete.value = 'no';
	 	
	 					SaveScrollXY();   	 				
	 					form.submit();
	 				
	 					return true;
	 				}else{
	 					return false;
	 				}
	 			}
	 		}	
		}else{
			if(checkboxes.checked == true){ 				
				selectSnpGeneName = rows[1].cells[1].innerHTML;
				selectSnpGeneList = rows[1].cells[2].innerHTML;
				var ans = confirm("Are you sure you want to delete " + elemName + " of '" + selectSnpGeneName + "'?");
				
				if(ans){
					var form=elem.form; 					
					form.actionParam.value = paraValue; 					
					form.snpgeneNameText.value = selectSnpGeneName;
					form.cancelDelete.value = 'no';
					
					SaveScrollXY();
					
					form.submit();
					return true;
				}else{
					return false;
				}
 			}
		}  		
		
		alert("Please select a row to delete!");   		
	}

 	
	// Ok btn hit
	function okSnpGeneList(elem){		
 		if(elem.name == "snpOK"){
			if(addOrUpdate=="add"){
				addSnpGeneList(elem);
			}else if(addOrUpdate=="update"){
				updateSnpGeneList(elem);
			}		
		}else if(elem.name=="geneOK"){			
			if(geneAddOrUpdate=="add"){				
				addSnpGeneList(elem);
			}else if(geneAddOrUpdate=="update"){
				updateSnpGeneList(elem);
			}
		}
	}

	var snpNamesList = <c:out value="${asSelectForm.SNPListColsJSONStr}" escapeXml="false" />;
	var geneNamesList = <c:out value="${asSelectForm.GENEListColsJSONStr}" escapeXml="false" />;
	
 	function addSnpGeneList(elem){
 		var name;
		var snpgeneList;
		var strElemName;
		var snpGeneNamesList; 
				
		var snpNamesList = <c:out value="${asSelectForm.SNPListColsJSONStr}" escapeXml="false" />;
		var geneNamesList = <c:out value="${asSelectForm.GENEListColsJSONStr}" escapeXml="false" />;
		
		if(elem.name=="snpOK"){
			name = $('snpNameId');
			snpgeneList = $('snpValueId');
			strElemName = "SNP";
			snpGeneNamesList = snpNamesList;
		}else if(elem.name=="geneOK"){			
			name = $('geneNameId');
			snpgeneList = $('geneValueId');
			strElemName = "Gene";
			snpGeneNamesList = geneNamesList;
		}
		
		if(name.value.length<=0){
			alert("Please enter a " + strElemName + " list name!");
			name.focus();
			name.select();
			return false;
		}
		
		if(snpgeneList.value.length<=0){
			alert("Please enter a " + strElemName + " list value!");
			snpgeneList.focus();
			snpgeneList.select();
			return false;
		}
		
		for(var i=0; i<snpGeneNamesList.length; i++){			
			if(name.value==snpGeneNamesList[i]){
				alert("The " + strElemName + " list name '" + name.value + "' already exists. Please enter a different one.");
				name.focus();
				name.select();
				return false;
			}
		}
		
		if(elem.name == "snpOK"){
			elem.form.actionParam.value = 'addSnp';	
		}else if(elem.name=="geneOK"){
			elem.form.actionParam.value = 'addGeneList';
		}
		
		elem.form.snpgeneNameText.value = name.value.toString();
		elem.form.snpgeneValueText.value = snpgeneList.value.toString();		
		elem.form.sessionIdText.value = 0;
		
		SaveScrollXY();		
		elem.form.submit();
		if(elem.name=="snpOK"){
			toggleSnp(true);	
		}else if(elem.name=="geneOK"){
			toggleGene(true);
		}
				
		return true;
	}
	
	function updateSnpGeneList(elem){		
		var name;
		var snpgeneList;
		var strElemName;
		var snpGeneNamesList; 
		var oldSnpGeneName;
		var upSnpGene;
		
		if(elem.name=="snpOK"){
			name = $('snpNameId');
			snpgeneList = $('snpValueId');
			strElemName = "SNP";
			snpGeneNamesList = snpNamesList;
			oldSnpGeneName = oldSnpName;
			upSnpGene = 'updateSnp';
		}else if(elem.name=="geneOK"){
			name = $('geneNameId');
			snpgeneList = $('geneValueId');
			strElemName = "Gene";
			snpGeneNamesList = geneNamesList;
			oldSnpGeneName = oldGeneName;
			upSnpGene = 'updateGeneList';
		}
		
		if(name.value.length<=0){
			alert("Please enter a " + strElemName + " list name!");
			name.focus();
			name.select();
			return false;
		}
		
		if(snpgeneList.value.length<=0){
			alert("Please enter a " + strElemName + " list value!");
			snpgeneList.focus();
			snpgeneList.select();
			return false;
		}
		
		for(var i=0; i<snpGeneNamesList.length; i++){			
			if(name.value != oldSnpGeneName && name.value==snpGeneNamesList[i]){
				alert("The " + strElemName + " list name '" + name.value + "' already exists. Please enter a different one.");
				name.focus();
				name.select();
				return false;
			}
		}
		
		elem.form.actionParam.value = upSnpGene;
		elem.form.snpgeneNameText.value = name.value;		
		elem.form.snpgeneValueText.value = snpgeneList.value;		
		elem.form.oldSnpGeneNameText.value = oldSnpGeneName;
		elem.form.sessionIdText.value = 0;
		
		SaveScrollXY();
		
		elem.form.submit();
		toggleSnp(true);
		return true; 
	}
	
	// Cancel btn hit
	function cancelSnpGeneList(elem){
 		if(elem.name=="snpCancel"){
			var name = $('snpNameId');
			name.value = '';
			var snpList = $('snpValueId');
			snpList.value = '';
			toggleSnp(true);
			addOrUpdate = '';
		}else if(elem.name == "geneCancel"){
			var name = $('geneNameId');
			name.value = '';
			var geneList = $('geneValueId');
			geneList.value = '';
			toggleGene(true);
			geneAddOrUpdate = '';
		} 
	}

	function radio(clicked){		
		var form = clicked.form;
		//var checkboxes = form.elements[clicked.name];
		var checkboxes;
		if(clicked.name=="checkId"){
			checkboxes = form.checkId;
		}else if(clicked.name=="geneCheckId"){
			checkboxes = form.geneCheckId;
		}
		
	    if (!clicked.checked ) {	    		    	
	    	var dRow = clicked.parentNode.parentNode;  
            
	        if(dRow.rowIndex%2 == 0){
	        	clicked.parentNode.parentNode.className="even";
	        }else{
	        	clicked.parentNode.parentNode.className="odd";
	        }
	        return false;
	    }
	    
	    for (i=0; i<checkboxes.length; i++) {
	        if (checkboxes[i] != clicked) {
	            checkboxes[i].checked=false;	            	            	            
	        }
	        if(i%2 == 1){		        	
	        	checkboxes[i].parentNode.parentNode.className="even";
	        }else{		        	
	        	checkboxes[i].parentNode.parentNode.className="odd";
	        }
	    }
	
	    // highlight the row    
	    clicked.parentNode.parentNode.className="overRow";
	
	    if(clicked.name=="checkId"){
		    if(addOrUpdate=="update"){
		    	editSnpGeneList(clicked);	    	
		    }
	    }else if(clicked.name="geneCheckId"){	    	
	    	if(geneAddOrUpdate=="update"){	    		
	    		editSnpGeneList(clicked);
	    	}
	    }
 	}

	function SaveScrollXY() {
		var form = document.getElementById('cqForm');
		var hidx = document.getElementById('ScrollX');		
		hidx.value = document.body.scrollLeft;		
		var hidy = document.getElementById('ScrollY');
		hidy.value = document.body.scrollTop;
		
		//set cookie for scroll position
		setCookie("ScrollXPos", hidx.value, 1);
		setCookie("ScrollYPos", hidy.value, 1);
	}

	function ResetScrollPosition(){		
		var hidx, hidy;		
		var form = document.getElementById('cqForm');		
		hidx = document.getElementById('ScrollX');		
		hidy = document.getElementById('ScrollY');
				
		if((typeof(hidx.value) !== 'undefined' && hidx.value != null && hidx.value!='null') && 
				(typeof(hidy.value) !== 'undefined' && hidy.value != null && hidy.value!='null')){
			window.scrollTo(hidx.value, hidy.value);
		}else{			
			hidx.value = getCookie("ScrollXPos");
			hidy.value = getCookie("ScrollYPos");
			window.scrollTo(hidx.value, hidy.value);
		}
	}
	
	function detectScrollbar(){
	    if (navigator.appName == "Microsoft Internet Explorer"){
	         window.name=document.body.scrollTop;
	     }else{
	         window.name=window.pageYOffset;
	    }
	}
	  
	function doScroll(){
		if (window.name) window.scrollTo(0, window.name);
	}

	function chkAll(elem){
		var form = elem.form;	
		var inputs = form.elements;  
		var cbs = []; //will contain all checkboxes  
		var checked = []; //will contain all checked checkboxes  
		var chrAll = $('checkAll');
		if(chrAll.checked){
			//check all chromsomes			
			for (var i = 0; i < inputs.length; i++) {  
			  if (inputs[i].type == "checkbox" && inputs[i].id.indexOf("chr")===0) {
				  inputs[i].checked = true;
			  }  
			}  
		}else{
			for (var i = 0; i < inputs.length; i++) {  
				  if (inputs[i].type == "checkbox" && inputs[i].id.indexOf("chr")===0) {
					  inputs[i].checked = false;
				  }  
			}	
		}
	}
	
	function chkChr(elem){
		var form = elem.form;	
		var inputs = form.elements;  
		var cbs = []; //will contain all checkboxes
		var checked = []; //will contain all checked checkboxes  
		var chrAll = $('checkAll');
		var allChecked = true;
		
		if(elem.checked){
			//check all chromsomes			
			for (var i = 0; i < inputs.length; i++) {  
				if (inputs[i].type == "checkbox" && inputs[i].id.indexOf("chr")===0) {
					cbs.push(inputs[i]);  
					if (inputs[i].checked) {  
						checked.push(inputs[i]);  
					}
			  	}  
			}
			if(cbs.length!=checked.length){				
				allChecked = false;
			}
			
			if(allChecked==true){				
				chrAll.checked = true;
			}else{
				chrAll.checked = false;
			}
			
		}else{
			chrAll.checked = false;	
		}		
	}

	function queryGene(elem){
		var queryType;
		if(filterOrder.length==1){
			if(filterOrder[0]=="Genetics"){
				queryType="GeneticsOnly";
			}
		}else if(filterOrder.length==2){
			var andOrName = "filterANDOR"+filterOrder[1];
			var andOrVar = document.getElementsByName(andOrName);
			var andOrValue;
			for(var i=0; i<andOrVar.length; i++){
				if(andOrVar[i].checked){
					andOrValue = andOrVar[i].value;
					break;
				}
			}			
			if(filterOrder.indexOf("Assessment")==-1){				
				if(andOrValue=="AND"){
					queryType="ImagingAndGenetics";
				}else{
					queryType="ImagingOrGenetics";
				}				
			}else{
				if(andOrValue=="OR"){
					queryType = "AssessmentOrGenetics";
				}else{
					queryType = "AssessmentAndGenetics";
				}
			}
		}else if(filterOrder.length==3){
			var andOrValue = new Array();
			for(var j=0; j<2; j++){
				var andOrName = "filterANDOR"+filterOrder[j+1];
				var andOrVar = document.getElementsByName(andOrName);				
				for(var i=0; i<andOrVar.length; i++){
					if(andOrVar[i].checked){
						andOrValue[j] = andOrVar[i].value;
						break;
					}
				}
			}
			if(filterOrder[2]=="Genetics" && andOrValue[0]=="AND" && andOrValue[1]=="AND"){
				queryType="AssessAndImagingAndGenetics"; // ass & img & gene OR img & ass & gene
			}else if(filterOrder[2]=="Genetics" && andOrValue[0]=="OR" && andOrValue[1]=="AND"){
				if(filterOrder[1]=="Imaging"){
					queryType="ImagingAndGenetics";      // ass|img & gene
				}else if(filterOrder[1]=="Assessment"){
					queryType="AssessmentAndGenetics";   // img|ass & gene
				}
			}else if(filterOrder[1]=="Genetics" && andOrValue[0]=="AND"){
				if(filterOrder[0]=="Imaging"){
					queryType="ImagingAndGenetics";      // img&gene|ass OR img&gene&ass
				}else if(filterOrder[0]=="Assessment"){
					queryType="AssessmentAndGenetics";   // ass&gene|img OR ass&gene&img
				}
			}else{
				queryType="GeneticsOnly";
			}
		}
		
		var json = buildQuery("", "Gene");		
		var form = elem.form;
		var inputs = form.elements;
		var bGet = false;
		
		for (var i = 0; i < inputs.length; i++) {  
			if (inputs[i].type == "checkbox"){				
				if(inputs[i].checked){
					inputs[i].value = true;					
				}else{
					inputs[i].value = false;
				}				
			}
			
			//check if any Get fields is selected
			if(inputs[i].type=="checkbox" && inputs[i].name.indexOf("results")===0){				
				if(inputs[i].checked){
					bGet = true;
				}
			}
		}
		
		if(bGet==false){
			alert("No \x22Get\x22 field has been selected yet! Please check at least one!");
			return false;
		}

		SaveScrollXY();
		
		form.actionParam.value = 'queryGenetics';
		form.queryString.value=json;
		form.queryType.value=queryType;
		form.submit();
		return false;
	}
	
	function exportMap(elem){
		var json = buildQuery("","MAP");		
		var form = elem.form;
		var inputs = form.elements;
		var bGet = false;
		
		var queryType;
		if(filterOrder.length==1){
			if(filterOrder[0]=="Genetics"){
				queryType="GeneticsOnly";
			}
		}
		
		for (var i = 0; i < inputs.length; i++) {  
			if (inputs[i].type == "checkbox"){				
				if(inputs[i].checked){
					inputs[i].value = true;					
				}else{
					inputs[i].value = false;
				}				
			}
			
			//check if any Get fields is selected
			if(inputs[i].type=="checkbox" && inputs[i].name.indexOf("results")===0){				
				if(inputs[i].checked){
					bGet = true;
				}
			}
		}
		
		if(bGet==false){
			//alert("No \x22Get\x22 field has been selected yet! Please check at least one!");
			//return false;
		}

		var bNone = true; //all "none" fields are checked		
		for(var i=0; i<inputs.length; i++){			
			if(inputs[i].type=="radio"){				
				if(inputs[i].value=="none" && inputs[i].checked==false){
					bNone = false;
					break;
				}
			}
		}		
		if(bNone==true){
			alert("None of the genetic field has been selected yet! Please choose at least one!");
			return false;
		}
		
		SaveScrollXY();
		
		form.actionParam.value = 'exportMap';
		form.queryString.value=json;
		form.queryType.value= queryType;
		form.submit();
		return false;
	}
	
	
	function exportPed(elem){
		var json = buildQuery("","PED");		
		var form = elem.form;
		var inputs = form.elements;
		var bGet = false;
		
		var queryType;
		if(filterOrder.length==1){
			if(filterOrder[0]=="Genetics"){
				queryType="GeneticsOnly";
			}
		}
				
		for (var i = 0; i < inputs.length; i++) {  
			if (inputs[i].type == "checkbox"){				
				if(inputs[i].checked){
					inputs[i].value = true;					
				}else{
					inputs[i].value = false;
				}				
			}
			
			//check if any Get fields is selected
			if(inputs[i].type=="checkbox" && inputs[i].name.indexOf("results")===0){				
				if(inputs[i].checked){
					bGet = true;
				}
			}
		}
		
		if(bGet==false){
			//alert("No \x22Get\x22 field has been selected yet! Please check at least one!");
			//return false;
		}

		SaveScrollXY();
		
		form.actionParam.value = 'exportPed';
		form.queryString.value=json;
		form.queryType.value= queryType;
		form.submit();
		return false;
	}
	
	var panelIndex=1;
	var filterOrder=new Array();
	
	function clickValidated(){
		var isValid = $('tValid');
		var notValid = $('fValid');
		if(!notValid.checked){ isValid.checked = true;}
	}

	function clickInvalidated(){
		var isValid = $('tValid');
		var notValid = $('fValid');
		if(!isValid.checked){ notValid.checked = true;}
	}
	
	function addAssessPanel(elem) {		

		jQuery.noConflict();

		if (typeof jQuery == 'undefined') {  
		    alert("not loaded");  
		} else {	    
		    jQuery(function(){
		    	jQuery("#contentHolder")
		    	.append( jQuery('<div id="assessDiv" style="padding: 5px; margin-top: 6px;" ></div>')
		    			.append( jQuery("<div></div>").addClass("squarebox")
		    					.append( jQuery('<div class="squareboxgradientcaption" style="height:20px; cursor:pointer; " id="assessCapDiv"></div>')		    					
		    							.append( jQuery('<div style="float:left;">Assessment &nbsp;&nbsp;</div>'))
		    							.append( jQuery('<div style="text-align:left; "></div>')
												.append( jQuery('<img src="images/collapse.gif" align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; padding-bottom:2px"></img>'))									
												)
		    							)		    				
		    					.append( jQuery("<div></div>").addClass("squareboxcontent").attr({id:"contentAssDiv"})
				    					.append( jQuery("<div></div>").attr({style:"margin:1em; line-height:1.6em; vertical-align:middle;text-align: left;"})
				    							.append( jQuery("<table></table>").attr({style:"border-collapse:collapse;width:94%;"})
				    									.append( jQuery("<tr></tr>")
				    											.append( jQuery("<td></td>")
				    													.append( jQuery("<label>Assessment </label>").addClass("lbl"))
				    													.append( jQuery("<select></select>").attr({id:"assessmentSel"}).on("change",handleAssessmentChange))
				    													) 
				    											)
				    									.append( jQuery("<tr></tr>")
				    											.append( jQuery("<td></td>")
				    													.append( jQuery("<label>Return Assessments</label>").addClass("lbl"))
				    													.append( jQuery("<input type='checkbox' name='Validated' value='validated' checked='true' id='tValid'>Validated</input>").on("click", clickValidated)	)
				    													.append( jQuery("<input type='checkbox' name='Validated' value='Invalidated' id='fValid'>Not Validated</input>").on("click", clickInvalidated) )
				    													)
				    											)
				    									.append(jQuery("#showAllScoreRow").clone().show()
				    											)
				    									.append( jQuery("<tr></tr>")
				    											.append( jQuery("<td></td>")
				    													.append( jQuery('<div id="qbp" style="border:solid #00659c 2px; padding:5px; margin-top:6px;"></div>'))
				    													)
				    											)
				    									.append( jQuery("<tr></tr>")
				    											.append( jQuery("<td></td>")
				    													.append( jQuery('<c:if test="${stateCoordinator.hasMultipleDatabases}"></c:if>')
				    															.append('<input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>')
				    															)
				    													.append( jQuery('<input type="button" class="submit-button" onclick="return query(this)" value="Assessment Query Only"></input>'))
				    													)
				    											)
				    									)
				    							
		 		    							)
		 		    					.append( jQuery('<div align="left"></div>')
		 		    							.append( jQuery("<input type='button' class='link-button' value='Remove Assessment Query' onclick='removeAssPanel();return false;'>"))
		 		    							)
		 		    					
		 		    					) 		    					
		    					)
		    		);
		    	});
		    
		    jQuery("#assessCapDiv").on("click", function(){return(togglePannelAnimatedStatus($('contentAssDiv'), 50,50))});
		    handleAssessmentQPanelPopulation("assessmentSel");
		    jQuery("#addAssDiv").attr("disabled","disabled").css("color","gray");		    
		    jQuery("#removeAssDiv").removeAttr("disabled").css("color","white");
		 	
		    filterOrder[panelIndex-1] = "Assessment";
		    createFilterDiv("Assessment", panelIndex);
		    delAndAddQueryBtn(filterOrder);
		    
		    setCookie("assPanelIndex", panelIndex++, 1);
		    }

	}
	
	function createFilterDiv(order, i){
		if(i==1){
			jQuery("#AddPanelsCell").after(jQuery('<td id="filterVerticalLine" width="1em" bgcolor="#00659c"><BR></td>'));
	    	jQuery("#filterConditionCell")
	    	.append(jQuery('<table id="filterConditionTable" width="100%"></table>')
	    			.append(jQuery('<tr></tr>')
							.append(jQuery('<td align="center" class="lblLargest">Query Filter Conditions:</td>'))
							)
	    			.append(jQuery('<tr></tr>')
	    					.append(jQuery('<td align="center"></td>')
	    							.append(jQuery('<div id="filterConditionDiv"></div>')
	    									.append(jQuery('<label class="lblLarger">&nbsp;' + order + '&nbsp;</label>'))
	    									)
	    							)
	    					)
	    			);
		}else{
			if(!jQuery("#filterConditionDiv")){
				if(!jQuery("#filterConditionTable")){
					jQuery("#filterConditionCell").append(jQuery('<div id="filterConditionTable" width="100%"></div>'));
				}				
				jQuery("#filterConditionTable").append(jQuery('<tr></tr>')
						.append(jQuery('<td align="center"></td>')
								.append(jQuery('<div id="filterConditionDiv"></div>'))
								)
						);
			}
			jQuery("#filterConditionDiv").append(jQuery('<input height="8px" type="radio" id="filterAnd' + order + '" value="AND" name="filterANDOR' + order + '" checked="checked">AND</input>'))
										 .append(jQuery('<input height="8px" type="radio" id="filterOr' + order + '" value="OR" name="filterANDOR' + order + '">OR </input>'));
	    	jQuery("#filterConditionDiv").append(jQuery('<label class="lblLarger" id="filterLbl' + order +'"> &nbsp;' + order + '&nbsp;</label>'));
		}
	}

	function delAndAddFilterDiv(orderArr){	
		jQuery("#filterConditionTable").remove();
		jQuery("#filterVerticalLine").remove();
		
		var i;
		
		for(i=0; i<orderArr.length; i++){
			createFilterDiv(orderArr[i],i+1);
		}
	}
	
	function delAndAddQueryBtn(orderArr){		
		var elem = $('combQueryId');	
		if(elem) elem.parentNode.removeChild(elem);

		if(orderArr.length>0){			
			jQuery("#queryDivId").append('<input type="button" id="combQueryId" class="submit-button" onclick="return queryAll(this);" value="Query"></input>');
		}		
	}


	function addImagingPanel(elem) {
		jQuery(function() {
			jQuery("#contentHolder")
					.append(
							jQuery('<div id="imagingDiv" style="padding: 5px; margin-top: 6px;"></div>')
							.append(
									jQuery('<div class="squarebox"></div>')
									.append(
											jQuery('<div class="squareboxgradientcaption" style="height:20px; cursor:pointer; " id="capImgingDiv"></div>')
											.append(jQuery('<div style="float:left;">Imaging &nbsp;&nbsp;</div>'))
											.append(
													jQuery('<div style="text-align:left"></div')
													.append(jQuery('<img src="images/collapse.gif" align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; padding-bottom:2px"></img>'))
													)
											)
											.append(
													jQuery('<div class="squareboxcontent" id="contentImgingDiv"></div>')
													.append(jQuery('<div style="margin:1em; line-height:1.6em; vertical-align:middle;">')
															.append(jQuery('<table style="border-collapse:collapse; width: 94%; ">')
																	.append(jQuery("#protocolsRow").clone().show())
																			.append(jQuery('<tr height="10px"></tr>'))
																			.append(jQuery("#versionRow").clone().show())
																			.append(jQuery('<tr height="10px"></tr>'))
																			.append(jQuery("#typeRow").clone().show())
																			.append(jQuery('<tr height="10px"></tr>'))
																			.append( jQuery("<tr></tr>")
								    											.append( jQuery("<td></td>")
								    													.append( jQuery('<c:if test="${stateCoordinator.hasMultipleDatabases}"></c:if>')
								    															.append('<input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>')
								    															)
								    													.append( jQuery('<input type="button" class="submit-button" onclick="return queryImage(this)" value="Imaging Query Only"></input>'))
								    													)
								    												)
																	)
															)
															.append(jQuery('<div align="left"></div>')
																	.append(jQuery("<input type='button' class='link-button' value='Remove Imaging Query' onclick='removeImgPanel();return false;'>"))
																	)
													)
									)
							)

		});

		populateProtocolList("selProtocolIds");
		populateProVerList("selProtocolVers");
		populateProDataTypes("selTypeIds");

		jQuery("#capImgingDiv").on("click", function() {
			return (togglePannelAnimatedStatus($('contentImgingDiv'), 50, 50))
		});

		jQuery("#addImgDiv").attr("disabled", "disabled").css("color", "gray");
		jQuery("#removeImgDiv").removeAttr("disabled").css("color", "white");
		
		filterOrder[panelIndex-1] = "Imaging";
	    createFilterDiv("Imaging", panelIndex);
	    delAndAddQueryBtn(filterOrder);
		
		setCookie("imgPanelIndex", panelIndex++, 1);
	}

	function addGeneticsPanel(elem) {
		jQuery(function() {
			jQuery("#contentHolder")
			.append(jQuery('<div style="padding:5px; margin-top:6px;" id="geneticsDiv"></div>')
					.append(jQuery('<div class="squarebox"></div>')
							.append(jQuery('<div class="squareboxgradientcaption" style="height:20px; cursor:pointer; " id="genCaptionDiv"></div>')
									.append(jQuery('<div style="float:left;">Genetics &nbsp;&nbsp;</div>'))
									.append(jQuery('<div style="text-align:left"></div')
											.append(jQuery('<img src="images/collapse.gif" align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; padding-bottom:2px"></img>'))
											)
									)
							.append(jQuery('<div class="squareboxcontent" id="genContentDiv"></div>')
									.append(jQuery('<div style="margin:1em; line-height:1.6em; vertical-align:middle;"></div>')
											.append(jQuery('<table style="border-collapse:collapse; width:94%"></table>')
													.append(jQuery("#expSessionRow").clone().show())
													.append(jQuery("#seesionIdRow").clone().show())
													.append(jQuery("#chipIdRow").clone().show())
													.append(jQuery("#genomeRow").clone().show())
													.append(jQuery('<tr></tr>')
															.append(jQuery('<td align="right"></td>')
																	.append(jQuery('<label class="lbl">Chromosome:</label>'))
																	)
															.append(jQuery('<td></td>')
																	.append(jQuery('<table cellpadding="-1" cellspacing="-1" width="100%"></table>')
																			.append(jQuery('<tr id="chrRow"></tr>'))
																			.append(jQuery('<tr id="chrChkRow"></tr>'))
																			)
																	)
															)
													.append(jQuery("#chrom2ndRow").clone().show())
													.append(jQuery('<tr height="8px"></tr>'))
													.append(jQuery("#snpListRow").clone().show())
													.append(jQuery('<tr height="8px"></tr>').append('<td></td>').append('<td></td>'))													
													.append(jQuery('<tr></tr>')
															.append(jQuery('<td class="bottomborder"></td>'))
															.append(jQuery('<td class="bottomborder"></td>')
																	.append(jQuery('<div class="squarebox"></div>')
																			.append(jQuery('<div style="cursor:pointer; height:20px" id="snpListCaptionDiv"></div>')
																					.append(jQuery('<div style="float:left">Manage SNP List</div>'))
																					.append(jQuery('<div style="text-align:left"></div>')
																							.append(jQuery('<img src="images/expand1.gif" align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; padding-bottom:2px"></img>'))
																							)
																					)
																			.append(jQuery('<div class="squareboxcontent" id="sbox"></div>')
																					.append(jQuery('<div style="margin:1em; line-height:1em; vertical-align:middle;"></div>')
																							)
																					)
																			)
																	)
															)
													.append(jQuery('<tr height="8px"></tr>').append('<td></td>').append('<td></td>'))
													.append(jQuery("#geneListRow").clone().show())
													.append(jQuery('<tr height="8px"></tr>').append('<td></td>').append('<td></td>'))													
													.append(jQuery('<tr></tr>')
															.append(jQuery('<td class="bottomborder"></td>'))
															.append(jQuery('<td class="bottomborder"></td>')
																	.append(jQuery('<div class="squarebox"></div>')
																			.append(jQuery('<div style="cursor:pointer; height:20px" id="geneListCaptionDiv"></div>')
																					.append(jQuery('<div style="float:left">Manage Gene List</div>'))
																					.append(jQuery('<div style="text-align:left"></div>')
																							.append(jQuery('<img src="images/expand1.gif" align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; padding-bottom:2px"></img>'))
																							)
																					)
																			.append(jQuery('<div class="squareboxcontent" id="genesbox"></div>')
																					.append(jQuery('<div style="margin:1em; line-height:1em; vertical-align:middle;"></div>')
																							)
																					)
																			)
																	)
															)
													.append(jQuery("#refSeqRow").clone().show())
													.append(jQuery("#gcScoreRow").clone().show())
													.append(jQuery("#gcScore2ndRow").clone().show())
													.append(jQuery("#positionRow").clone().show())
													.append(jQuery("#position2ndRow").clone().show())
													.append(jQuery("#exportRow").clone().show())
													.append(jQuery("#resultRow").clone().show())
													)
											)
									.append(jQuery('<div align="left"></div>')
											.append(jQuery("<input type='button' class='link-button' value='Remove Genetics Query' onclick='removeGenPanel();return false;'>"))
											)
									)
							)
					)
			});

		// add checkboxes to genome row
		var gnomeArr=['All','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','M','X','Y','XY'];
		for(indx=0; indx<gnomeArr.length; indx++){
			jQuery("#chrRow").append(jQuery('<td align="center"></td>').text(gnomeArr[indx]));
		}
		var gnomeArr1=['00','01','02', '03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25'];
		jQuery("#chrChkRow")
		.append(jQuery('<td align="center"></td>')
				.append(jQuery('<input type="checkbox"></input>').attr({id:"checkAll"}).on("click",function(){chkAll(this);}))
				);		
		for(indx=0; indx<gnomeArr1.length; indx++){
			jQuery("#chrChkRow")
			.append(jQuery('<td align="center"></td>')
					.append(jQuery('<input type="checkbox"></input>').attr({id:"chr"+gnomeArr1[indx]}).on("click",function(){chkChr(this);}))
					);			
		}

		
		jQuery("#genCaptionDiv").on("click", function() {
			return (togglePannelAnimatedStatus($('genContentDiv'), 50, 50))
		});
		jQuery("#addGenDiv").attr("disabled", "disabled").css("color", "gray");
		jQuery("#removeGenDiv").removeAttr("disabled").css("color", "white");
		
		jQuery("#snpListCaptionDiv").on("click", function(){
			return(togglePannelAnimatedStatus1($('sbox'),50,50))
		});
		jQuery("#geneListCaptionDiv").on("click", function(){
			return(togglePannelAnimatedStatus1($('genesbox'),50,50))
		});
		
		jQuery("#snpListTableDiv").clone().show().appendTo(jQuery("#sbox"));
		jQuery("#snpListTable")
			.append(jQuery('<tr style="display:none"><tr>')
					.append(jQuery('<td colspan="2"></td>')
							.append(jQuery('<input type="button" name="newSnp" value="New" class="submit-button" style="width:40px"></input>')
									.on("click", function(){addNewSnpList(this);}))
							.append(jQuery('<input type="button" name="editSnp" value="Edit" class="submit-button" style="width:40px"></input>')
									.on("click", function(){editSnpGeneList(this);}))
							.append(jQuery('<input type="button" name="deleteSnp" value="Delete" class="submit-button" style="width:40px"></input>')
									.on("click", function(){deleteSnpGeneList(this);}))
							)				
					)
			.append(jQuery('<tr id="trSnpName" style="display:none;"></tr>')				
					.append(jQuery('<td align="right">SNP List Name:</td>'))
					.append(jQuery('<td align="left"></td>')
							.append(jQuery('<input type="text" id="snpNameId" style="width:300px" name="snpName"></input>'))
							)
					)
			.append(jQuery('<tr id="trSnpValue" style="display:none;"></tr>')				
					.append(jQuery('<td align="right">SNP List Value:</td>'))
					.append(jQuery('<td align="left"></td>')
							.append(jQuery('<textarea id="snpValueId" style="width:300px; height:80px" name="snpValue"></textarea>'))
							)
					)
			.append(jQuery('<tr id="trBtn" style="display:none;"></tr>')				
					.append(jQuery('<td></td>'))
					.append(jQuery('<td></td>')
							.append(jQuery('<input type="button" value="OK" name="snpOK" class="submit-button" style="width:50px"></input>')
									.on("click",function(){okSnpGeneList(this);}))
							.append(jQuery('<input type="button" value="Cancel" name="snpCancel" class="submit-button" style="width:50px"></input>')
									.on("click", function(){cancelSnpGeneList(this);}))
							)
					);
		
		jQuery("#geneListTableDiv").clone().show().appendTo(jQuery("#genesbox"));
		jQuery("#geneListTable")
			.append(jQuery('<tr style="display:none"><tr>')
					.append(jQuery('<td colspan="2"></td>')
							.append(jQuery('<input type="button" name="newGene" value="New" class="submit-button" style="width:40px"></input>')
									.on("click", function(){addNewGeneList(this);}))
							.append(jQuery('<input type="button" name="editGene" value="Edit" class="submit-button" style="width:40px"></input>')
									.on("click", function(){editSnpGeneList(this);}))
							.append(jQuery('<input type="button" name="deleteGene" value="Delete" class="submit-button" style="width:40px"></input>')
									.on("click", function(){deleteSnpGeneList(this);}))
							)				
					)
			.append(jQuery('<tr id="trGeneName" style="display:none;"></tr>')				
					.append(jQuery('<td align="right">Gene List Name:</td>'))
					.append(jQuery('<td align="left"></td>')
							.append(jQuery('<input type="text" id="geneNameId" style="width:300px" name="geneName"></input>'))
							)
					)
			.append(jQuery('<tr id="trGeneValue" style="display:none;"></tr>')				
					.append(jQuery('<td align="right">Gene List Value:</td>'))
					.append(jQuery('<td align="left"></td>')
							.append(jQuery('<textarea id="geneValueId" style="width:300px; height:80px" name="geneValue"></textarea>'))
							)
					)
			.append(jQuery('<tr id="trGeneBtn" style="display:none;"></tr>')				
					.append(jQuery('<td></td>'))
					.append(jQuery('<td></td>')
							.append(jQuery('<input type="button" value="OK" name="geneOK" class="submit-button" style="width:50px"></input>')
									.on("click",function(){okSnpGeneList(this);}))
							.append(jQuery('<input type="button" value="Cancel" name="geneCancel" class="submit-button" style="width:50px"></input>')
									.on("click", function(){cancelSnpGeneList(this);}))
							)
					);
		
		filterOrder[panelIndex-1] = "Genetics";
	    createFilterDiv("Genetics", panelIndex);
	    delAndAddQueryBtn(filterOrder);
		
		setCookie("genPanelIndex", panelIndex++, 1);
		
	}

	function removeAssPanel() {
		(elem = $('assessDiv')).parentNode.removeChild(elem);
		jQuery("#addAssDiv").removeAttr("disabled").css("color", "white");
		jQuery("#removeAssDiv").attr("disabled", "disabled").css("color","gray");
		
		setCookie("assPanelIndex", 0, 1);		
		panelIndex--;
		
		for(var i=0; i<filterOrder.length; i++){
			if(filterOrder[i]=="Assessment"){
				filterOrder.splice(i,1);	
			}
		}		
			
		delAndAddFilterDiv(filterOrder);
		
		delAndAddQueryBtn(filterOrder);
	}

	function removeImgPanel() {
		(elem = $('imagingDiv')).parentNode.removeChild(elem);
		jQuery("#addImgDiv").removeAttr("disabled").css("color", "white");
		jQuery("#removeImgDiv").attr("disabled", "disabled").css("color","gray");
		
		setCookie("imgPanelIndex", 0, 1);
		panelIndex--;
		
		for(var i=0; i<filterOrder.length; i++){
			if(filterOrder[i]=="Imaging"){
				filterOrder.splice(i,1);	
			}
		}		
			
		delAndAddFilterDiv(filterOrder);	
		
		delAndAddQueryBtn(filterOrder);
	}

	function removeGenPanel() {
		(elem = $('geneticsDiv')).parentNode.removeChild(elem);
		jQuery("#addGenDiv").removeAttr("disabled").css("color", "white");
		jQuery("#removeGenDiv").attr("disabled", "disabled").css("color","gray");
		
		setCookie("genPanelIndex", 0, 1);
		panelIndex--;
		
		for(var i=0; i<filterOrder.length; i++){
			if(filterOrder[i]=="Genetics"){
				filterOrder.splice(i,1);	
			}
		}
		
		delAndAddFilterDiv(filterOrder);
		
		delAndAddQueryBtn(filterOrder);
	}
	
	function batchQueryAll(elem){
		elem.form.actionParam.value='Batch Query';
		elem.form.submit();
		return false;	 		
	}
	
</script>

<div class="error">
<html:errors/>
</div>

<br>
<html:form action="/analysisresultquery" styleId="qtf">
<input type="hidden" name="actionParam" value="Show"/>
<input type="hidden" name="caQueryString" value=""/>         
<div id="tabpanel" style="display: none;">
   <ul id="tabs">      
        <li class="activelink"><a href="#" >Assessment</a></li>   
        <c:if test="${asSelectForm.supportAnalysisQuery}">
		   <li><a href='javascript:{}' onclick="changeTab(this);">Analysis</a></li>
        </c:if>
<!--         <li><a href="GeneticsQuery_full.jsp">Genetics</a></li> -->
<!--         <li><a href="#">Raw Imaging</a></li> -->
<!-- 		<li><a href="#">Derived Data</a></li>                  -->
   </ul>
</div>
</html:form>

<html:form action="/caquery" styleId="cqForm" onsubmit="SaveScrollXY()">
<input type="hidden" name="actionParam" value=""/>
<input type="hidden" name="queryString" value=""/>
<input type="hidden" name="queryType" value="" />
<input type="hidden" name="curExp" value=""/>
<input type="hidden" name="curExpSs" value="" />
<input type="hidden" name="curSs" value="" />
<input type="hidden" name="queryName" value="" />
<input type="hidden" name="cancelDelete" value=""/>
<input type="hidden" name="oldSnpGeneNameText" value="" />
<input type="hidden" name="sessionIdText" value="" />
<input type="hidden" name="snpgeneNameText" value="" />
<input type="hidden" name="snpgeneValueText" value="" />
<input name="ScrollX" id="ScrollX" type="hidden" value="<%= request.getParameter("ScrollX") %>"/>
<input name="ScrollY" id="ScrollY" type="hidden" value="<%= request.getParameter("ScrollY") %>" />
<input type="hidden" name="selProtocols" value=""/>
<input type="hidden" name="selDTypes" value=""/>
<input type="hidden" name="selVersions" value=""/>

<input type="hidden" name="assPanel" value='<%= request.getParameter("assPanelIndex") %>' id="hdnAssPanel"/>
<input type="hidden" name="imgPanel" value='<%= request.getParameter("imgPanelIndex") %>' id="hdnImgPanel" />
<input type="hidden" name="genPanel" value='<%= request.getParameter("genPanelIndex") %>' id="hdnGenPanel" />

<input type="hidden" name="filterANDORGen" value="" />
<input type="hidden" name="filterANDORAssess" value="" />
<input type="hidden" name="filterANDORImg" value="" />

<input type="hidden" name="validateText" value="" />


<div id="qb_wizard" >
 
   <div style="text-align:left; padding:0; margin:0; background-color:#ffcc33;  line-height:1.8em; ">
     <span class="mlarge" style="margin:5px;">Query Builder</span><br>
   </div>
   <c:if test="${not asSelectForm.supportAssessmentQuery}">
     <div>
        <span style="color:red; font-weight:bold; padding:5px;">No assessment metadata can be found. 
          Use CALM to add assessment metadata.</span>
     </div>
   </c:if>
   
	<div style="margin:1em; line-height:1.6em; vertical-align:middle;">
	        <c:if test="${stateCoordinator.hasMultipleDatabases == true}">
			</c:if>         

		<table>
			<tr>
				<td id="AddPanelsCell">
					<div style="margin: 1em; line-height: 1.6em; vertical-align: middle;" >
						<div>
							<span class="msmall">
							<input type="button" class="link-button" value="Query for Assessment Data" id="addAssDiv" onclick="addAssessPanel(this)">
							<input type='button' class='link-button' value='Remove Assessment Query' id='removeAssDiv' onclick='removeAssPanel();return false;' disabled="disabled" style="color: gray">
							<br> 
							<input type="button" class="link-button" value="Query for Imaging Data" id="addImgDiv"	onclick="addImagingPanel(this)"> 
							<input type='button' class='link-button' value='Remove Imaging Query' id='removeImgDiv' onclick='removeImgPanel();return false;' disabled="disabled" style="color: gray">
							<br>
							<input type="button" class="link-button" value="Query for Genetics Data" id="addGenDiv"	onclick="addGeneticsPanel(this)"> 
							<input type='button' class='link-button' value='Remove Genetics Query' id='removeGenDiv' onclick='removeGenPanel();return false;' disabled="disabled" style="color: gray">
							</span>							
						</div>						
					</div>
				</td>				
				<td id="filterConditionCell" width="50%">
				</td>
			</tr>
		</table>
		<hr>

		<div style="text-align:left; padding-left:3px;">
			<c:if test="${not empty asSelectForm.savedQuerySelector.savedQueries}" >		    
		       <span class="msmall">Saved Queries:</span>&nbsp;
			    <bean:define id="sqList" name="asSelectForm" property="savedQuerySelector.savedQueries"
		                  type="java.util.Collection"/>
		
		        <html:select styleId="selectedQuery" name="asSelectForm" property="savedQuerySelector.selectedQueryID">
		           <html:options collection="sqList" property="value"
		                labelProperty="label"/>
		        </html:select>
			     &nbsp;
			    <input type="button" value="Load Query" class="submit-button" onclick="return loadQuery(this);"></input>
			    
			    <input type="button" value="Delete Query" class="submit-button" onclick="del(this);"></input>	         
		   </c:if>
		   <input type="button" class="submit-button" value="Save Query" onclick="return saveQuery(this);"></input>
		</div>		
	   <hr> 
	</div> 
	
	<div style="margin:1em; line-height:1.6em; vertical-align:middle;" id="contentHolder">
	   <bean:define id="expIDList" name="asSelectForm" property="expSelector.experimentInfos"
          type="java.util.Collection"/>
		<div style="padding: 5px; margin-top: 6px;" id="exdiv">
			<div style="border: solid #00659c 2px; margin-bottom:5px; padding-bottom:3px; padding-top:3px;"> 	 
		      <div style="padding-bottom:5px;">
		        <span class="msmall" style="margin-left:5px;" >Experiment(s):</span>&nbsp;
		        <html:select name="asSelectForm" property="expSelector.selectedExpID" onchange="changeExperiment(this)">
		             <html:options collection="expIDList" property="value" labelProperty="label"/>
		        </html:select>
		      </div>
		      <div>
		       <bean:define id="qsList" name="asSelectForm" property="queryScopeSelector.queryScopeList"
		            type="java.util.Collection"/>
		       <span class="msmall" style="margin-left:5px;" >Query Matching Scope:</span>&nbsp;
		       <html:select name="asSelectForm" property="queryScopeSelector.queryScope">
		             <html:options collection="qsList" property="value" labelProperty="label"/>
		       </html:select>
		       <span id="help_21"> <button onclick="return helpHandler('help_21')">
		          <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
		         </button>
		       </span>  
		      </div>
		      <div>
		      	<input type="button" class="submit-button" value="Batch Query All" onclick="return batchQueryAll(this);"></input>		      	
				<span id="help_27"> 
					<button onclick="return helpHandler('help_27')">
			    		<img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
			        </button>
				</span>			    
			  </div>
			</div>
		</div>
	   	
	    <!-- Jinran modified assessment portion --> <!-- Jinran commented this part. Add assessment panel dynamically -->	     
	    <%-- <div style="padding: 5px; margin-top: 6px;" id="asdiv">
	    	<div class="squarebox"><div class="squareboxgradientcaption" style="height:20px; cursor: pointer;"
		            	onclick="togglePannelAnimatedStatus(this.nextSibling,50,50)"><div style="float: left; ">
		            	Assessment &nbsp;&nbsp;</div><div style="text-align: left; "><img src="images/collapse.gif" 
		            		align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; 
		            		padding-bottom: 2px">&nbsp;</div></div><div class="squareboxcontent"><div style="margin:1em; 
		            		line-height:1.6em; vertical-align:middle;">
				<table style="border-collapse:collapse; width: 100% ">
 					<tr>				
	       				<td><label class="lbl">Assessment:</label> &nbsp;<select id="assessmentSel" onchange="handleAssessmentChange()"> </select></td>
					</tr>
	      			<tr>
	      				<td>
		      				<div id="scp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;" >
						       <a href="#" onclick="return showAllScores(event,this);">Show All Scores</a>
					          <p>Start typing to see matching scores for the selected assessment</p>
					          <label>Score:</label>
					          <input type="text" id="scoreField"></input>          
					          &nbsp; <input type="button" name="Add to Query" value="Add to Query" 
						     onclick="return handleAddQueryPart();"></input>
							  <div id="autoCompleteMenu"></div>
					      	</div>
	      				</td>      			
	      			</tr>
 	      			<tr>
	      				<td>
	      					<div id="qbp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;"></div>
	      				</td>      			
	      			</tr>	      			
	      			<tr>
	      				<td>
	      					<c:if test="${stateCoordinator.hasMultipleDatabases}">		     	
						    	<input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>&nbsp;            
						    </c:if>
						    <input type="button" class="submit-button" onclick="return query(this);" value="Query"></input>
	      				</td>
	      			</tr>
	      			
	      		</table></div></div>
	      	</div>
	    </div> --%>
    	
        <!-- Jinran added imaging portion -->
<%--
		<div style="padding: 5px; margin-top: 6px;" id="asdiv">
	    	<div class="squarebox"><div class="squareboxgradientcaption" style="height:20px; cursor: pointer;"
		            	onclick="togglePannelAnimatedStatus(this.nextSibling,50,50)"><div style="float: left; ">
		            	Imaging &nbsp;&nbsp;</div><div style="text-align: left; "><img src="images/collapse.gif" 
		            		align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; 
		            		padding-bottom: 2px">&nbsp;</div></div><div class="squareboxcontent"><div style="margin:1em; 
		            		line-height:1.6em; vertical-align:middle;">
				<table style="border-collapse:collapse; width: 100%; ">
 					<tr>
 						<td align="right" width="15%" valign="top" ><label class="lbl">Protocol Type:&nbsp;&nbsp;</label></td>
	       				<td align="left">
  	       					<bean:define id="allProtocols" name="asSelectForm" property="proSelector.protocolCols" 
	       						type="java.util.Collection"/> 							
 							<html:select styleId="selProtocolIds"  name="asSelectForm" property="proSelector.selProtocolIds" size="10" multiple="multiple">
								<html:options collection="allProtocols" property="value" labelProperty="label"/>
					        </html:select>
	       				</td>
					</tr>
 					<tr height="10px"></tr>
					<tr>
						<td align="right" width="15%" valign="top" ><label class="lbl">Version:&nbsp;&nbsp;</label></td>
						<td align="left">
							<bean:define id="allProVers" name="asSelectForm" property="proSelector.protocolVers" 
	       						type="java.util.Collection"/>
							<html:select styleId="selProtocolVers"  name="asSelectForm" property="proSelector.selProtocolVers" size="3" multiple="multiple">
								<html:options collection="allProVers" property="value" labelProperty="label"/>
					        </html:select>
						</td>
					</tr>

					<tr height="10px"></tr>
					<tr>
						<td align="right" width="15%" valign="top"><label class="lbl">Data Type: &nbsp;&nbsp;</label></td>						
						<td align="left">
							<bean:define id="allFormats" name="asSelectForm" property="proSelector.dataTypes" type="java.util.Collection"></bean:define>
							<html:select styleId="selTypeIds" name="asSelectForm" property="proSelector.selDataTypes" size="4" multiple="multiple">
								<html:options collection="allFormats" property="value" labelProperty="label" ></html:options>
							</html:select>
						</td>
					</tr>
	      		</table></div></div>
	      	</div>
	    </div>
--%>
    
		<!-- Jinran added. Genetics Interface -->
<%-- 		<div style="padding: 5px; margin-top: 6px;" id="gdiv">
			<div class="squarebox"><div class="squareboxgradientcaption" style="height:20px; cursor: pointer;"
	            	onclick="togglePannelAnimatedStatus(this.nextSibling,50,50)"><div style="float: left; ">
	            	Genetics &nbsp;&nbsp;</div><div style="text-align: left; "><img src="images/collapse.gif" 
	            		align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; 
	            		padding-bottom: 2px">&nbsp;</div></div><div class="squareboxcontent"><div style="margin:1em; 
	            		line-height:1.6em; vertical-align:middle;">
						<table style="border-collapse:collapse">
							<tr>
								<td align="right" class="bottomborder"><label class="lbl">Experiment Sessions:</label></td>
								<td class="bottomborder">									
									<bean:define id="expSessionIDList" name="asSelectForm" property="expSessionSel.experimentInfos" />
									<html:select name="asSelectForm" property="expSessionSel.selectedExpSessionID" onchange="changeExpSession(this)">
							             <html:options collection="expSessionIDList" property="value" labelProperty="label"/>
							        </html:select>
								</td>
							</tr>
							<tr>
								<td align="right" class="bottomborder"><label class="lbl">Session:</label></td>
	                            <td class="bottomborder">
	                            	<bean:define id="sslistid" name="asSelectForm" property="geneticObj.ssList" type="java.util.Collection"></bean:define>
									<html:select styleId="selectedSSId" name="asSelectForm" property="geneticObj.selectedSS" onchange="changeSession(this)" >
	                                	<html:options collection="sslistid" property="sessionId" labelProperty="sessionName"/>
	                                </html:select>&nbsp;		                            		                            
<!-- 		                            <input type="button" value="New Session" class="submit-button" onclick="newSession()"></input> -->
<!-- 		                            <input type="button" value="Delete Session" class="submit-button" onclick="delSession(this)"></input> -->
	                            </td>
							</tr>
							<bean:define id="chiplistid" name="asSelectForm" property="geneticObj.geneChip" type="java.util.Collection"></bean:define>
							<tr>
								<td align="right" class="bottomborder"><label class="lbl">Chip ID:</label></td>
	                            <td class="bottomborder">
	                            	<html:select name="asSelectForm" property="geneticObj.selectedGeneChipId" >
	                                	<html:options collection="chiplistid" property="chipId" labelProperty="chipName"/>
	                                </html:select>
	                                <html:radio name="asSelectForm" property="chipIdAND" value="and" disabled="false" >AND</html:radio>
	                                <html:radio name="asSelectForm" property="chipIdAND" value="or" disabled="false">OR</html:radio>
	                                <html:checkbox name="asSelectForm" property="results[0]" disabled="false"  >Get</html:checkbox>                                                
	                            </td>
	                        </tr>
	                        <tr>
	                        	<td align="right" class="bottomborder"><label class="lbl">Genome Release:</label></td>
	                            <td class="bottomborder">
	                            	<bean:define id="genomeReleaseId" name="asSelectForm" property="geneticObj.uniqueGenomeRelease" type="java.util.Collection"></bean:define>
	                            	<html:select name="asSelectForm" property="geneticObj.selectedGenomeBuildId" >
										<html:options collection="genomeReleaseId" property="value" labelProperty="label"/>
	                                </html:select>
	                                <html:radio name="asSelectForm" property="genomeAND" value="and" disabled="false" >AND</html:radio>
	                                <html:radio name="asSelectForm" property="genomeAND" value="or" disabled="false">OR</html:radio>
	    							<html:checkbox name="asSelectForm" property="results[1]">Get</html:checkbox>                                                
	                            </td>
	                        </tr>
	                        <tr>
		                        <td align="right"><label class="lbl">Chromosome:</label></td>
		                        <td>
									<table cellpadding="-1" cellspacing="-1" width="100%" >
		                               	<tr>
		                                   <td align="center" width="9px" >All</td>		                                   
		                                   <td align="center">1</td>
		                                   <td align="center">2</td>
		                                   <td align="center">3</td>
		                                   <td align="center">4</td>
		                                   <td align="center">5</td>
		                                   <td align="center">6</td>
		                                   <td align="center">7</td>
		                                   <td align="center">8</td>
		                                   <td align="center">9</td>
		                                   <td align="center">10</td>
		                                   <td align="center">11</td>
		                                   <td align="center">12</td>
		                                   <td align="center">13</td>
		                                   <td align="center">14</td>
		                                    <td align="center">15</td>
		                                    <td align="center">16</td>
		                                    <td align="center">17</td>
		                                    <td align="center">18</td>
		                                    <td align="center">19</td>
		                                    <td align="center">20</td>
		                                    <td align="center">21</td>
		                                    <td align="center">22</td>
		                                    <td align="center">M</td>
		                                    <td align="center">X</td>
		                                    <td align="center">XY</td>
		                                    <td align="center">Y</td>
		                                </tr>
		                                <tr>
											<td align="center"><html:checkbox styleId="checkAll" name="asSelectForm" property="chromAll" onclick="chkAll(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr00" name="asSelectForm" property="chromArr[0]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr01" name="asSelectForm" property="chromArr[1]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr02" name="asSelectForm" property="chromArr[2]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr03" name="asSelectForm" property="chromArr[3]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr04" name="asSelectForm" property="chromArr[4]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr05" name="asSelectForm" property="chromArr[5]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr06" name="asSelectForm" property="chromArr[6]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr07" name="asSelectForm" property="chromArr[7]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr08" name="asSelectForm" property="chromArr[8]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr09" name="asSelectForm" property="chromArr[9]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr10" name="asSelectForm" property="chromArr[10]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr11" name="asSelectForm" property="chromArr[11]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr12" name="asSelectForm" property="chromArr[12]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr13" name="asSelectForm" property="chromArr[13]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr14" name="asSelectForm" property="chromArr[14]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr15" name="asSelectForm" property="chromArr[15]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr16" name="asSelectForm" property="chromArr[16]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr17" name="asSelectForm" property="chromArr[17]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr18" name="asSelectForm" property="chromArr[18]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr19" name="asSelectForm" property="chromArr[19]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr20" name="asSelectForm" property="chromArr[20]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr21" name="asSelectForm" property="chromArr[21]" onclick="chkChr(this)"></html:checkbox></td>                
		                                    <td align="center"><html:checkbox styleId="chr22" name="asSelectForm" property="chromArr[22]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr23" name="asSelectForm" property="chromArr[23]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr24" name="asSelectForm" property="chromArr[24]" onclick="chkChr(this)"></html:checkbox></td>
		                                    <td align="center"><html:checkbox styleId="chr25" name="asSelectForm" property="chromArr[25]" onclick="chkChr(this)"></html:checkbox></td>
										</tr>
		                        	</table>
								</td>
				            </tr>
				            <tr>
								<td class="bottomborder"></td>
								<td  class="bottomborder">
									<html:radio name="asSelectForm" property="chromAND" value="none" disabled="false" >None</html:radio>
				                	<html:radio name="asSelectForm" property="chromAND" value="and" disabled="false" >AND</html:radio>
				                    <html:radio name="asSelectForm" property="chromAND" value="or" disabled="false">OR</html:radio>
									<html:checkbox name="asSelectForm" property="results[4]" >Get</html:checkbox>                                                 
				                </td>
				            </tr>
				            <tr height="8px"><td></td><td></td></tr>                       
	                    	<tr>
	                            <td align="right"><label class="lbl">SNP List:</label></td>
	                            <td>
	                            	<bean:define id="snpnameslists" name="asSelectForm" property="geneticObj.snpListCols" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="geneticObj.selectedSNPListId" styleId="selectSnpListId">
	                                	<html:options collection="snpnameslists" property="uniqueId" labelProperty="name"/>
									</html:select> 
									<html:radio name="asSelectForm" property="snpAND" value="none" disabled="false">None</html:radio>
	                                <html:radio name="asSelectForm" property="snpAND" value="and" disabled="false" >AND</html:radio>
	                                <html:radio name="asSelectForm" property="snpAND" value="or" disabled="false">OR</html:radio>
	                                <html:checkbox name="asSelectForm" property="results[2]">Get</html:checkbox>
	                            </td>
	                        </tr>
	                        <tr height="8px"><td></td><td></td></tr>
	                        <tr>
	                        	<td class="bottomborder"></td>
	                        	<td class="bottomborder">
	                                <div class="squarebox"><div style="cursor: pointer;"
						            	onclick="togglePannelAnimatedStatus1(this.nextSibling,50,50)"><div style="float: left;"><a 
						            	href="#" onclick="close(); return false">
						            	Manage SNP list</a></div><div style="text-align: left; "><img src="images/expand1.gif" 
						            		align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; 
						            		padding-bottom: 2px">&nbsp;</div></div><div class="squareboxcontent" 
						            		style="display: '';" id="sbox"><div style="margin:1em; 
						            		line-height:1.6em; vertical-align:middle; ">
									<table width="100%">								
										<tr>
											<td colspan="2">																						
												<display:table id='tableSnpList' name="sessionScope.snpList" pagesize="5"
														export="false" sort="list" class="displayTagTable" >
													<display:column style="width: 5%" title="">
													    <input type="checkbox" name="checkId" style="margin: 0 0 0 4px" onclick="radio(this)" />
													</display:column>
													
													<display:column property="sessionName" title="Session" sortable="true"  
														headerClass="sortable" style="width: 15%" />
													<display:column property="name" title="SNP List Name" sortable="true"
														headerClass="sortable" style="width: 20%"/>
													<display:column property="list" title="Value" sortable="true"
														headerClass="sortable" style="width: 60%"/>
												</display:table>																												
											</td>
										</tr>
										<tr>
											<td colspan="2">
												<input type="button" name="newSnp" value="New" class="submit-button" style="width: 40px" onclick="addNewSnpList(this)"></input>
												<input type="button" name="editSnp" value="Edit" class="submit-button" style="width: 40px" onclick="editSnpGeneList(this)"></input>
												<input type="button" name="deleteSnp" value="Delete" class="submit-button" style="width: 40px" onclick="deleteSnpGeneList(this)"></input>
											</td>
										</tr>
										<tr id="trSnpName" style="display: none;">
											<td align="right">
												SNP List Name:
											</td>
											<td align="left">
												<html:text property="snpName" style="width:300px" styleId="snpNameId"></html:text>
											</td>
										</tr>
										<tr id="trSnpValue" style="display: none;">
											<td align="right">
												SNP List Value:
											</td>
											<td align="left">
												<html:textarea property="snpValue" style="width: 300px; height:80px" styleId="snpValueId"></html:textarea>
											</td>
										</tr>
										<tr id="trSessionId" style="display: none;">
											<td align="right">
												Session Name:
											</td>
											<td align="left">
												<bean:define id="snpSessionListId" name="asSelectForm" property="geneticObj.snpSessionList"></bean:define>
												<html:select styleId="selectSessionId" name="asSelectForm" property="geneticObj.selectedSnpSession" >
				                                	<html:options collection="snpSessionListId" property="sessionId" labelProperty="sessionName"/>
				                                </html:select>
											</td>
										</tr>								
										<tr id="trBtn" style="display: none;">
											<td>
											</td>
											<td>
												<input type="button" name="snpOK" value="OK" class="submit-button" style="width: 50px" onclick="okSnpGeneList(this)"></input>												
												<input type="button" name="snpCancel" value="Cancel" class="submit-button" style="width: 50px" onclick="cancelSnpGeneList(this)"></input>
											</td>
										</tr>
									</table>									
									</div>
									</div>
									</div>
									<br>									                               
	                            </td>	                            
				            </tr>				            
				            <tr height="8px"><td></td><td></td></tr>
				            <tr>				            	
			                    <td align="right"><label class="lbl">Gene List:</label></td>
			                    <td>
			                        <bean:define id="genenameslists" name="asSelectForm" property="geneticObj.geneListCols" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="geneticObj.selectedGeneListId" styleId="selectGeneListId">
	                                	<html:options collection="genenameslists" property="uniqueId" labelProperty="name"/>
									</html:select>
									<html:radio name="asSelectForm" property="geneAND" value="none" disabled="false">None</html:radio>
	                                <html:radio name="asSelectForm" property="geneAND" value="and" disabled="false" >AND</html:radio>
                                    <html:radio name="asSelectForm" property="geneAND" value="or" disabled="false">OR</html:radio>
                                    <html:checkbox name="asSelectForm" property="results[3]">Get</html:checkbox>                                                  
								</td>
							</tr>
							<tr height="8px"><td></td><td></td></tr>
 	                        <tr>
	                        	<td class="bottomborder"></td>
	                        	<td class="bottomborder">
	                                <div class="squarebox"><div style="cursor: pointer;"
						            	onclick="togglePannelAnimatedStatus1(this.nextSibling,50,50)"><div style="float: left;"><a 
						            	href="#" onclick="close(); return false">
						            	Manage Gene list</a></div><div style="text-align: left; "><img src="images/expand1.gif" 
						            		align="bottom" alt="Show/Hide" title="Show/Hide" style="vertical-align:middle; 
						            		padding-bottom: 2px">&nbsp;</div></div><div class="squareboxcontent" 
						            		style="display: '';" id="sbox"><div style="margin:1em; 
						            		line-height:1.6em; vertical-align:middle; ">
									<table width="100%">								
										<tr>
											<td colspan="2">																						
												<display:table id='tableGeneList' name="sessionScope.geneListCols" pagesize="5"
														export="false" sort="list" class="displayTagTable" >
													<display:column style="width: 5%" title="">
													    <input type="checkbox" name="geneCheckId" style="margin: 0 0 0 4px" onclick="radio(this)" />
													</display:column>
													
													<display:column property="sessionName" title="Session" sortable="true"  
														headerClass="sortable" style="width: 15%" />
													<display:column property="name" title="Gene List Name" sortable="true"
														headerClass="sortable" style="width: 20%"/>
													<display:column property="list" title="Value" sortable="true"
														headerClass="sortable" style="width: 60%"/>
												</display:table>																												
											</td>
										</tr>
										<tr>
											<td colspan="2">
												<input type="button" name="newGene" value="New" class="submit-button" style="width: 40px" onclick="addNewGeneList(this)"></input>
												<input type="button" name="editGene" value="Edit" class="submit-button" style="width: 40px" onclick="editSnpGeneList(this)"></input>
												<input type="button" name="deleteGene" value="Delete" class="submit-button" style="width: 40px" onclick="deleteSnpGeneList(this)"></input>
											</td>
										</tr>
										<tr id="trGeneName" style="display: none;">
											<td align="right">
												Gene List Name:
											</td>
											<td align="left">
												<html:text property="geneName" style="width:300px" styleId="geneNameId"></html:text>
											</td>
										</tr>
										<tr id="trGeneValue" style="display: none;">
											<td align="right">
												Gene List Value:
											</td>
											<td align="left">
												<html:textarea property="geneValue" style="width: 300px; height:80px" styleId="geneValueId"></html:textarea>
											</td>
										</tr>
										<tr id="trGeneSessionId" style="display: none;">
											<td align="right">
												Session Name:
											</td>
											<td align="left">
												<bean:define id="geneSessionListId" name="asSelectForm" property="geneticObj.geneSessionList"></bean:define>
												<html:select styleId="selectGeneSessionId" name="asSelectForm" property="geneticObj.selectedGeneSession" >
				                                	<html:options collection="geneSessionListId" property="sessionId" labelProperty="sessionName"/>
				                                </html:select>
											</td>
										</tr>								
										<tr id="trGeneBtn" style="display: none;">
											<td>
											</td>
											<td>
												<input type="button" name="geneOK" value="OK" class="submit-button" style="width: 50px" onclick="okSnpGeneList(this)"></input>												
												<input type="button" name="geneCancel" value="Cancel" class="submit-button" style="width: 50px" onclick="cancelSnpGeneList(this)"></input>
											</td>
										</tr>
									</table>									
									</div>
									</div>
									</div>
									<br>									                               
	                            </td>	                            
				            </tr>				            

				            <tr>
								<td align="right" class="bottomborder"><label class="lbl">Ref Sequence:</label></td>
				                <td class="bottomborder">
		                        	<bean:define id="refseqoplist" name="asSelectForm" property="refSeqOpList" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="selectedRefSeqOp" styleId="selectRefSeqOpId">
	                                	<html:options collection="refseqoplist" property="value" labelProperty="label"/>
									</html:select>
		                        	<html:text name="asSelectForm" property="refSeq" disabled="false" style="width:150px" ></html:text>
		                        	<html:radio name="asSelectForm" property="refseqAND" value="none" disabled="false" >None</html:radio>
		                        	<html:radio name="asSelectForm" property="refseqAND" value="and" disabled="false" >AND</html:radio>
		                        	<html:radio name="asSelectForm" property="refseqAND" value="or" disabled="false">OR</html:radio>
		                        	<html:checkbox name="asSelectForm" property="results[5]">Get</html:checkbox>                                                
								</td>
				            </tr>
				            <tr>
								<td align="right"><label class="lbl">GC Score:</label></td>
								<td>
		                            <bean:define id="gcscoreoplist" name="asSelectForm" property="gcscoreOpList" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="selectedGcscoreOp" styleId="selectGcscoreOpId">
	                                	<html:options collection="gcscoreoplist" property="value" labelProperty="label"/>
									</html:select>
		                            <html:text style="width:80px" name="asSelectForm" property="gcScore" disabled="false"></html:text>                                                                                                                                                                                                                                   
		                        </td>
				            </tr>
				            <tr>
			                    <td class="bottomborder"></td>
			                    <td class="bottomborder">Between<html:text style="width:85px" name="asSelectForm" property="gcScoreLB" disabled="false"></html:text>
			                            and&nbsp;<html:text style="width:85px" name="asSelectForm" property="gcScoreUB" disabled="false"></html:text>
			                            <html:radio name="asSelectForm" property="gcScoreAND" value="none" disabled="false" >None</html:radio>
			                            <html:radio name="asSelectForm" property="gcScoreAND" value="and" disabled="false" >AND</html:radio>
			                            <html:radio name="asSelectForm" property="gcScoreAND" value="or" disabled="false">OR</html:radio>
			                            <html:checkbox name="asSelectForm" property="results[6]">Get</html:checkbox>
			                    </td>
				            </tr>
				            <tr>
			                    <td align="right"><label class="lbl">Position:</label></td>
			                    <td>
		                            <bean:define id="posoplist" name="asSelectForm" property="posOpList" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="selectedPosOp" styleId="selectPosOpId">
	                                	<html:options collection="posoplist" property="value" labelProperty="label"/>
									</html:select>
		                            <html:text style="width:80px" name="asSelectForm" property="position" disabled="false"></html:text>                                
								</td>
				            </tr>
				            <tr>
				                <td class="bottomborder"></td>
				                <td class="bottomborder">Between<html:text style="width:85px" name="asSelectForm" property="positionLB" disabled="false"></html:text>
				                            and&nbsp;<html:text style="width:85px" name="asSelectForm" property="positionUB" disabled="false"></html:text>
				                            <html:radio name="asSelectForm" property="positionAND" value="none" disabled="false" >None</html:radio>
				                            <html:radio name="asSelectForm" property="positionAND" value="and" disabled="false" >AND</html:radio>
				                            <html:radio name="asSelectForm" property="positionAND" value="or" disabled="false">OR</html:radio>
				                            <html:checkbox name="asSelectForm" property="results[7]">Get</html:checkbox>
				                </td>
				            </tr>
				            
				            <tr>
				            	<td></td>
				            	<td>
 				            		<input type="button" class="submit-button" value="View Query Results" onclick="queryGene(this)" ></input>
				            		<input type="button" class="submit-button" value="Export to MAP File" onclick="exportMap(this)"></input>
				            		<input type="button" class="submit-button" value="Export to PED File" onclick="exportPed(this)"></input>
				            	</td>
				            </tr>
				            
				            <tr>
				            	<td colspan="2">				            		 				            		
									<display:table id="tableGene" name="sessionScope.listResults" pagesize="25"
											export="false" sort="list" class="displayTagTable">
										<c:forEach var="item" items="${tableGene.geneResults}">
											<bean:define id="iname" ><c:out value="${item.colName}"></c:out></bean:define>												
											<% String itemName = iname ; %>												
											<display:column title="<%= itemName %>"><c:out value='${item.colValue}'/></display:column>																								
										</c:forEach>
										<display:setProperty name="export.pdf" value="true"></display:setProperty>
										<display:setProperty name="export.pdf.filename" value="GeneticsQuery.pdf"></display:setProperty>
										<display:setProperty name="export.xml" value="true"></display:setProperty>
										<display:setProperty name="export.xml.filename" value="GeneticsQuery.xml"></display:setProperty>
										<display:setProperty name="export.excel" value="true"></display:setProperty>
										<display:setProperty name="export.excel.filename" value="GeneticsQuery.xls"></display:setProperty>
										<display:setProperty name="export.csv" value="true"></display:setProperty>
										<display:setProperty name="export.csv.filename" value="GeneticsQuery.csv"></display:setProperty>
									</display:table>																												
				            	</td>
				            </tr>
				    	</table>
					</div>
				</div>
			</div>
		</div>
 --%>	
 </div>
 
				<table style="display: none;">
					<tr id="showAllScoreRow">
						<td>
							<div id="scp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;" >
								<a href="#" onclick="return showAllScores(event,this);">Show All Scores</a>
								<p>Start typing to see matching scores for the selected assessment</p>
								<label>Score:</label>
								<input type="text" id="scoreField"></input>&nbsp;
								<input type="button" name="Add to Query" value="Add to Query" 
										onclick="return handleAddQueryPart();"></input>
								<div id="autoCompleteMenu"></div>
							</div>
						</td>      			
					</tr>
				</table>

				<table style="display:none;">
 					<tr id="protocolsRow">
 						<td align="right" width="15%" valign="top" ><label class="lbl">Protocol Type:&nbsp;&nbsp;</label></td>
	       				<td align="left">
  	       					<bean:define id="allProtocols" name="asSelectForm" property="proSelector.protocolCols" 
	       						type="java.util.Collection"/> 							
 							<html:select styleId="selProtocolIds"  name="asSelectForm" property="proSelector.selProtocolIds" size="10" multiple="multiple">
								<html:options collection="allProtocols" property="value" labelProperty="label"/>
					        </html:select>
	       				</td>
					</tr>
 					
					<tr id="versionRow">
						<td align="right" width="15%" valign="top" ><label class="lbl">Version:&nbsp;&nbsp;</label></td>
						<td align="left">
							<bean:define id="allProVers" name="asSelectForm" property="proSelector.protocolVers" 
	       						type="java.util.Collection"/>
							<html:select styleId="selProtocolVers"  name="asSelectForm" property="proSelector.selProtocolVers" size="3" multiple="multiple">
								<html:options collection="allProVers" property="value" labelProperty="label"/>
					        </html:select>
						</td>
					</tr>

					<tr id="typeRow">
						<td align="right" width="15%" valign="top"><label class="lbl">Data Type: &nbsp;&nbsp;</label></td>						
						<td align="left">
							<bean:define id="allFormats" name="asSelectForm" property="proSelector.dataTypes" type="java.util.Collection"></bean:define>
							<html:select styleId="selTypeIds" name="asSelectForm" property="proSelector.selDataTypes" size="4" multiple="multiple">
								<html:options collection="allFormats" property="value" labelProperty="label" ></html:options>
							</html:select>
						</td>
					</tr>
	      		</table>
	      		
	      		

			<div style="display:none" id="snpListTableDiv" >
			<table width="100%" id="snpListTable">
				<tr>
					<td colspan="2">	
						<display:table id='tableSnpList' name="sessionScope.snpList" pagesize="5" export="false" sort="list" class="displayTagTable" >
							<display:column style="width: 5%" title="">
								<input type="checkbox" name="checkId" style="margin: 0 0 0 4px" onclick="radio(this)" />
							</display:column>
							<%-- <display:column property="sessionName" title="Session" sortable="true" headerClass="sortable" style="width: 15%" /> --%>
							<display:column property="name" title="SNP List Name" sortable="true" headerClass="sortable" style="width: 20%"/>
							<display:column property="list" title="Value" sortable="true" headerClass="sortable" style="width: 60%"/>
						</display:table>
					</td>
				</tr>
			</table>
			</div>
			
			<div style="display:none" id="geneListTableDiv" >
			<table width="100%" id="geneListTable">
				<tr>
					<td colspan="2">	
						<display:table id='tableGeneList' name="sessionScope.geneListCols" pagesize="5"	export="false" sort="list" class="displayTagTable" >
							<display:column style="width: 5%" title="">
								<input type="checkbox" name="geneCheckId" style="margin: 0 0 0 4px" onclick="radio(this)" />
							</display:column>
							<%-- <display:column property="sessionName" title="Session" sortable="true" headerClass="sortable" style="width: 15%" /> --%>
							<display:column property="name" title="Gene List Name" sortable="true" headerClass="sortable" style="width: 20%"/>
							<display:column property="list" title="Value" sortable="true" headerClass="sortable" style="width: 60%"/>
						</display:table>
					</td>
				</tr>
			</table>
			</div>

					
						<table style="display:none;">
							<tr id="expSessionRow">
								<td align="right" class="bottomborder"><label class="lbl">Experiment Sessions:</label></td>
								<td class="bottomborder">									
									<bean:define id="expSessionIDList" name="asSelectForm" property="expSessionSel.experimentInfos" />
									<html:select styleId="expSessionStyleId" name="asSelectForm" property="expSessionSel.selectedExpSessionID" onchange="changeExpSession(this)">
							             <html:options collection="expSessionIDList" property="value" labelProperty="label"/>
							        </html:select>
								</td>
							</tr>
							<tr id="seesionIdRow">
								<td align="right" class="bottomborder"><label class="lbl">Session:</label></td>
	                            <td class="bottomborder">
	                            	<bean:define id="sslistid" name="asSelectForm" property="geneticObj.ssList" type="java.util.Collection"></bean:define>
									<html:select styleId="selectedSSId" name="asSelectForm" property="geneticObj.selectedSS" onchange="changeSession(this)" >
	                                	<html:options collection="sslistid" property="sessionId" labelProperty="sessionName"/>
	                                </html:select>&nbsp;		                            		                            
	                            </td>
							</tr>
							<bean:define id="chiplistid" name="asSelectForm" property="geneticObj.geneChip" type="java.util.Collection"></bean:define>
							<tr id="chipIdRow">
								<td align="right" class="bottomborder"><label class="lbl">Chip ID:</label></td>
	                            <td class="bottomborder">
	                            	<html:select styleId="chipIdStyleId" name="asSelectForm" property="geneticObj.selectedGeneChipId" >
	                                	<html:options collection="chiplistid" property="chipId" labelProperty="chipName"/>
	                                </html:select>
	                                <html:radio name="asSelectForm" property="chipIdAND" value="and" disabled="false" >AND</html:radio>
	                                <html:radio name="asSelectForm" property="chipIdAND" value="or" disabled="false">OR</html:radio>
	                                <html:checkbox name="asSelectForm" property="results[0]" disabled="false"  >Get</html:checkbox>                                                
	                            </td>
	                        </tr>
	                        <tr id="genomeRow">
	                        	<td align="right" class="bottomborder"><label class="lbl">Genome Release:</label></td>
	                            <td class="bottomborder">
	                            	<bean:define id="genomeReleaseId" name="asSelectForm" property="geneticObj.uniqueGenomeRelease" type="java.util.Collection"></bean:define>
	                            	<html:select name="asSelectForm" property="geneticObj.selectedGenomeBuildId" >
										<html:options collection="genomeReleaseId" property="value" labelProperty="label"/>
	                                </html:select>
	                                <html:radio name="asSelectForm" property="genomeAND" value="and" disabled="false" >AND</html:radio>
	                                <html:radio name="asSelectForm" property="genomeAND" value="or" disabled="false">OR</html:radio>
	    							<html:checkbox name="asSelectForm" property="results[1]">Get</html:checkbox>                                                
	                            </td>
	                        </tr>
	                        <tr id="chrom2ndRow">
								<td class="bottomborder"></td>
								<td  class="bottomborder">
									<html:radio name="asSelectForm" property="chromAND" value="none" disabled="false" >None</html:radio>
				                	<html:radio name="asSelectForm" property="chromAND" value="and" disabled="false" >AND</html:radio>
				                    <html:radio name="asSelectForm" property="chromAND" value="or" disabled="false">OR</html:radio>
									<html:checkbox name="asSelectForm" property="results[4]" >Get</html:checkbox>                                                 
				                </td>
				            </tr>
				            <tr id="snpListRow">
	                            <td align="right"><label class="lbl">SNP List:</label></td>
	                            <td>
	                            	<bean:define id="snpnameslists" name="asSelectForm" property="geneticObj.allSnpListCols" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="geneticObj.selectedAllSNPListId" styleId="selectSnpListId">
	                                	<html:options collection="snpnameslists" property="uniqueId" labelProperty="name"/>
									</html:select> 
									<html:radio name="asSelectForm" property="snpAND" value="none" disabled="false">None</html:radio>
	                                <html:radio name="asSelectForm" property="snpAND" value="and" disabled="false" >AND</html:radio>
	                                <html:radio name="asSelectForm" property="snpAND" value="or" disabled="false">OR</html:radio>
	                                <html:checkbox name="asSelectForm" property="results[2]">Get</html:checkbox>
	                            </td>
	                        </tr> 
	                        <tr id="geneListRow">				            	
			                    <td align="right"><label class="lbl">Gene List:</label></td>
			                    <td>
			                        <bean:define id="genenameslists" name="asSelectForm" property="geneticObj.allGeneListCols" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="geneticObj.selectedAllGeneListId" styleId="selectGeneListId">
	                                	<html:options collection="genenameslists" property="uniqueId" labelProperty="name"/>
									</html:select>
									<html:radio name="asSelectForm" property="geneAND" value="none" disabled="false">None</html:radio>
	                                <html:radio name="asSelectForm" property="geneAND" value="and" disabled="false" >AND</html:radio>
                                    <html:radio name="asSelectForm" property="geneAND" value="or" disabled="false">OR</html:radio>
                                    <html:checkbox name="asSelectForm" property="results[3]">Get</html:checkbox>                                                  
								</td>
							</tr>
				            <tr id="refSeqRow">
								<td align="right" class="bottomborder"><label class="lbl">Ref Sequence:</label></td>
				                <td class="bottomborder">
		                        	<bean:define id="refseqoplist" name="asSelectForm" property="refSeqOpList" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="selectedRefSeqOp" styleId="selectRefSeqOpId">
	                                	<html:options collection="refseqoplist" property="value" labelProperty="label"/>
									</html:select>
		                        	<html:text name="asSelectForm" property="refSeq" disabled="false" style="width:150px" ></html:text>
		                        	<html:radio name="asSelectForm" property="refseqAND" value="none" disabled="false" >None</html:radio>
		                        	<html:radio name="asSelectForm" property="refseqAND" value="and" disabled="false" >AND</html:radio>
		                        	<html:radio name="asSelectForm" property="refseqAND" value="or" disabled="false">OR</html:radio>
		                        	<html:checkbox name="asSelectForm" property="results[5]">Get</html:checkbox>                                                
								</td>
				            </tr>
				            <tr id="gcScoreRow">
								<td align="right"><label class="lbl">GC Score:</label></td>
								<td>
		                            <bean:define id="gcscoreoplist" name="asSelectForm" property="gcscoreOpList" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="selectedGcscoreOp" styleId="selectGcscoreOpId">
	                                	<html:options collection="gcscoreoplist" property="value" labelProperty="label"/>
									</html:select>
		                            <html:text style="width:80px" name="asSelectForm" property="gcScore" disabled="false"></html:text>                                                                                                                                                                                                                                   
		                        </td>
				            </tr>
				            <tr id="gcScore2ndRow">
			                    <td class="bottomborder"></td>
			                    <td class="bottomborder">Between<html:text style="width:85px" name="asSelectForm" property="gcScoreLB" disabled="false"></html:text>
			                            and&nbsp;<html:text style="width:85px" name="asSelectForm" property="gcScoreUB" disabled="false"></html:text>
			                            <html:radio name="asSelectForm" property="gcScoreAND" value="none" disabled="false" >None</html:radio>
			                            <html:radio name="asSelectForm" property="gcScoreAND" value="and" disabled="false" >AND</html:radio>
			                            <html:radio name="asSelectForm" property="gcScoreAND" value="or" disabled="false">OR</html:radio>
			                            <html:checkbox name="asSelectForm" property="results[6]">Get</html:checkbox>
			                    </td>
				            </tr>
				            <tr id="positionRow">
			                    <td align="right"><label class="lbl">Position:</label></td>
			                    <td>
		                            <bean:define id="posoplist" name="asSelectForm" property="posOpList" type="java.util.Collection" ></bean:define>
	                            	<html:select name="asSelectForm" property="selectedPosOp" styleId="selectPosOpId">
	                                	<html:options collection="posoplist" property="value" labelProperty="label"/>
									</html:select>
		                            <html:text style="width:80px" name="asSelectForm" property="position" disabled="false"></html:text>                                
								</td>
				            </tr>
				            <tr id="position2ndRow">
				                <td class="bottomborder"></td>
				                <td class="bottomborder">Between<html:text style="width:85px" name="asSelectForm" property="positionLB" disabled="false"></html:text>
				                            and&nbsp;<html:text style="width:85px" name="asSelectForm" property="positionUB" disabled="false"></html:text>
				                            <html:radio name="asSelectForm" property="positionAND" value="none" disabled="false" >None</html:radio>
				                            <html:radio name="asSelectForm" property="positionAND" value="and" disabled="false" >AND</html:radio>
				                            <html:radio name="asSelectForm" property="positionAND" value="or" disabled="false">OR</html:radio>
				                            <html:checkbox name="asSelectForm" property="results[7]">Get</html:checkbox>
				                </td>
				            </tr>				            
				            <tr id="exportRow">
				            	<td></td>
				            	<td>
 				            		<input type="button" class="submit-button" value="View Query Results" onclick="queryGene(this)" ></input>
				            		<input type="button" class="submit-button" value="Export to MAP File" onclick="exportMap(this)"></input>
				            		<input type="button" class="submit-button" value="Export to PED File" onclick="exportPed(this)"></input>
				            	</td>
				            </tr>				            
				            <tr id="resultRow">
				            	<td colspan="2">				            		 				            		
									<display:table id="tableGene" name="sessionScope.listResults" pagesize="25"
											export="false" sort="list" class="displayTagTable">
										<c:forEach var="item" items="${tableGene.geneResults}">
											<bean:define id="iname" ><c:out value="${item.colName}"></c:out></bean:define>												
											<% String itemName = iname ; %>												
											<display:column title="<%= itemName %>"><c:out value='${item.colValue}'/></display:column>																								
										</c:forEach>
										<display:setProperty name="export.pdf" value="true"></display:setProperty>
										<display:setProperty name="export.pdf.filename" value="GeneticsQuery.pdf"></display:setProperty>
										<display:setProperty name="export.xml" value="true"></display:setProperty>
										<display:setProperty name="export.xml.filename" value="GeneticsQuery.xml"></display:setProperty>
										<display:setProperty name="export.excel" value="true"></display:setProperty>
										<display:setProperty name="export.excel.filename" value="GeneticsQuery.xls"></display:setProperty>
										<display:setProperty name="export.csv" value="true"></display:setProperty>
										<display:setProperty name="export.csv.filename" value="GeneticsQuery.csv"></display:setProperty>
									</display:table>																												
				            	</td>
				            </tr>
						</table>
					

	<div style="margin:1em; line-height:1.6em; vertical-align:middle;">      
		<div id="queryDivId">
			<c:if test="${stateCoordinator.hasMultipleDatabases}">
		     	
<!-- 		    <input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>&nbsp;             -->
		    </c:if>
<!--  		    <input type="button" class="submit-button" onclick="return query(this);" value="Query"></input> -->
		</div>
	</div>
	
	<!-- Jinran added for testing dnd feature -->
		
</div>
</html:form>

<script>
     var divElem = $('qb_wizard');
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
     var tabs = $$('#tabs li');
     tabs.each(
         function(el) { 
            Rico.Corner.round( el,  {color: "#00659c", corners: 'top'}); }
      ); 

 
</script>
