<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>

<style>

 #userView {
   float:left;
   padding:0px;
   padding-bottom: 1em;
   margin-left:10px;
   background-color: #d3d3d3;
   width: 70%;
 }

 .input_div {
   padding-top:5px;
   padding-left:5px;
 }
 
 .divMainSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    font-size: larger;
    margin: 0px;
    padding: 0px;
 }
 
 .divSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    margin: 0px;
    padding: 0px;
 }

div .label {
    float: left;
    font-weight:bold;
    width: 15em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}

div .label2 {
    float: left;
    font-weight:bold;
    width: 20em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}
</style>

<script type="text/javascript">
  var err0 = "Please enter your current password!";
  var err1 = "Please enter the new password!";
  var err2 = "Please confirm the new password!";
  var err3 = "The New Password and New Password(confirm) must match. Please re-enter your new password!";

  function go1(elem,actionValue, userType) {
	  var oldPwd = document.getElementById("txtOldPwd");
	  var newPwd = document.getElementById("txtPwd");
	  var newPwdAgain = document.getElementById("txtPwdAgain");
	  var err = document.getElementById("lblError");
	  err.style.color = "red";
	  if(oldPwd.value==""){
		  err.innerHTML=err0;
		  return false;
	  }else if(newPwd.value==""){
		  err.innerHTML=err1;
		  return false;
	  }else if(newPwdAgain.value==""){
		  err.innerHTML=err2;
		  return false;
	  }else if(newPwd.value!=newPwdAgain.value){
		  err.innerHTML = err3;
		  return false;
	  }
	  
      elem.form.action.value = actionValue;
      elem.form.userType.value = userType;
      elem.form.submit();
      return false;
  } 
  
  function validateEmail(emailField){
      var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
      if (reg.test(emailField.value) == false) {
          //alert('Invalid Email Address');
          return false;
      }
      return true;
  }
  
  window.onload=function(){
	  var oldPwd = document.getElementById("txtOldPwd");
	  oldPwd.focus();
  };
  
</script>
<div class="error">
  <html:errors/>
</div>

<form method="post" action="<c:url value="/uconf.do"/>" >
	<input type="hidden" name="action" value=""></input>
	<input type="hidden" name="userType" value=""></input>
	
	<div id="userView">
	<div class="divMainSectionTitle">
    	Change Your Password
    </div>

    <div style="border-left: 2px #00659c solid; border-right: 2px #00659c solid;" >
		<table>
			<tr>
				<td>
					<span class="label">Current Password:</span>
				</td>
				<td>
					<html:password styleId="txtOldPwd" name="usercForm" property="oldPwd" size="20" maxlength="30" />
				</td>
			</tr>
			<tr>
				<td>
					<span class="label">New Password:</span>
				</td>
				<td>
					<html:password styleId="txtPwd" name="usercForm" property="password" size="20" maxlength="30" />
				</td>
			</tr>
			<tr>
				<td>
					<span class="label">New Password (Confirm):</span>
				</td>
				<td>
					<html:password styleId="txtPwdAgain" name="usercForm" property="passwordRepeat" size="20" maxlength="30" />
				</td>
			</tr>
			<tr>
				<td></td>
				<td>
					<input type="submit" class="submit-button" value="Change" onclick="return go1(this,'ChangePwd','web')"></input>
				</td>
			</tr>
		</table>
		<div>
	    	<label id="lblError"></label>
		</div>
	</div>

</form>

<script>
     var divElem = $('userView');
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});
</script>
