<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>

<style>

 #userView {
   float:left;
   padding:0px;
   padding-bottom: 1em;
   margin-left:10px;
   background-color: #d3d3d3;
   width: 70%;
 }

 .input_div {
   padding-top:5px;
   padding-left:5px;
 }
 
 .divMainSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    font-size: larger;
    margin: 0px;
    padding: 0px;
 }
 
 .divSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    margin: 0px;
    padding: 0px;
 }

div .label {
    float: left;
    font-weight:bold;
    width: 15em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}

div .label2 {
    float: left;
    font-weight:bold;
    width: 20em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}
</style>

<script type="text/javascript">
  var err0 = "Please enter your first name!";
  var err1 = "Please enter your last name!";
  var err2 = "Please enter your email!";

  function go1(elem,actionValue, userType) {
	  var fn = document.getElementById("txtFirstName");
	  var ln = document.getElementById("txtLastName");
	  var email = document.getElementById("txtEmail");
	  var err = document.getElementById("lblError");
	  err.style.color = "red";
	  if(fn.value==""){
		  err.innerHTML=err0;
		  return false;
	  }else if(ln.value==""){
		  err.innerHTML=err1;
		  return false;
	  }else if(email.value==""){
		  err.innerHTML=err2;
		  return false;
	  }else if(validateEmail(email)==false){
		  err.innerHTML="Invalid email address!";
		  return false;
	  }
	  
      elem.form.action.value = actionValue;
      elem.form.userType.value = userType;
      elem.form.submit();
      return false;
  } 
  
  function validateEmail(emailField){
      var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
      if (reg.test(emailField.value) == false) {
          //alert('Invalid Email Address');
          return false;
      }
      return true;
  }
  
</script>
<div class="error">
  <html:errors/>
</div>

<form method="post" action="<c:url value="/uconf.do"/>" >
	<input type="hidden" name="action" value=""></input>
	<input type="hidden" name="userType" value=""></input>
	
	<div id="userView">
	<div class="divMainSectionTitle">
    	User Configuration
    </div> 
	<div style="border-left: 2px #00659c solid; border-right: 2px #00659c solid;" > 
    	<div >
        <c:if test="${usercForm.userType == 'web'}" >
		  <c:if test="${usercForm.opType == 'add'}" >
	          <div class="input_div">
	            <span class="label">Web User Name:</span> 
	            <html:text name="usercForm" property="userName" size="20" maxlength="30" /> 
	          </div>
	          <div class="input_div">
	            <span class="label">Web User Password:</span> 
	            <html:password name="usercForm" property="password" size="20" maxlength="30" /> 
	          </div>
	          <div class="input_div">
	            <span class="label">Web User Password (Confirm):</span> 
	            <html:password name="usercForm" property="passwordRepeat" size="20" maxlength="30" /> 
	          </div>
	          <div class="input_div">
	          	<span class="label">First Name:</span>
	          	<html:text styleId="txtFirstName" name="usercForm" property="firstName" size="20" maxlength="100" />
	          </div>
	          <div class="input_div">
	            <span class="label">Last Name:</span> 
	            <html:text styleId="txtLastName" name="usercForm" property="lastName" size="20" maxlength="100" /> 
	          </div>
	          <div class="input_div">
	            <span class="label">Email:</span> 
	            <html:text styleId="txtEmail" name="usercForm" property="email" size="20" maxlength="100" /> 
	          </div>
	          <div class="input_div">
	            <c:if test="${usercForm.useGSI  == 'true'}" >
	               <input type="checkbox" name="useGSI" checked><span>Use Globus Security Infrastructure</span>
	            </c:if>
	            <c:if test="${usercForm.useGSI  == 'false'}" >
	               <input type="checkbox" name="useGSI"><span>Use Globus Security Infrastructure</span>
	            </c:if> 
	          </div>
			  <div class="input_div">
		            <bean:define id="dbUserList" name="usercForm" property="dbUserSelector.dbUserList"
		                   type="java.util.Collection"/>
			     <span class="label">Database User: </span>
			     <html:select name="usercForm" property="dbUserSelector.selectedDBUserName">
			        <html:options collection="dbUserList" property="value" labelProperty="label" />
			     </html:select>
			  </div>
			  <div>	
		            <input type="submit" class="submit-button" value="Add"	                  
			            onclick="return go1(this,'Add Web User','web')"></input>
			  </div>
		  </c:if>
		  <c:if test="${usercForm.opType == 'edit'}" >
	           <div class="input_div">
	             <span class="label">Web User Name:</span> 
	             <html:text name="usercForm" property="userName" size="20" maxlength="30" disabled="true" /> 
	           </div>
	           <div class="input_div">
	             <span class="label">Web User Password:</span> 
	             <html:password name="usercForm" property="password" size="20" maxlength="30" /> 
	           </div>
	           <div class="input_div">
	             <span class="label">Web User Password (Confirm):</span> 
	             <html:password name="usercForm" property="passwordRepeat" size="20" maxlength="30" /> 
	           </div>
	           <div class="input_div">
	          	<span class="label">First Name:</span>
	          	<html:text styleId="txtFirstName" name="usercForm" property="firstName" size="20" maxlength="100" />
	          </div>
	          <div class="input_div">
	            <span class="label">Last Name:</span> 
	            <html:text styleId="txtLastName" name="usercForm" property="lastName" size="20" maxlength="100" /> 
	          </div>
	          <div class="input_div">
	            <span class="label">Email:</span> 
	            <html:text styleId="txtEmail" name="usercForm" property="email" size="20" maxlength="100" /> 
	          </div>
	           <div class="input_div">
	            <c:if test="${usercForm.useGSI  == 'true'}" >
	               <input type="checkbox" name="useGSI" checked><span>Use Globus Security Infrastructure</span>
	            </c:if>
	            <c:if test="${usercForm.useGSI  == 'false'}" >
	               <input type="checkbox" name="useGSI"><span>Use Globus Security Infrastructure</span>
	            </c:if> 
	          </div>
		   <div>
	             <input type="submit" class="submit-button" value="Save"	                  
		             onclick="return go1(this,'Edit Web User','web')"></input>
		     </div>
		  </c:if>
        </c:if>

		<c:if test="${not usercForm.webUserType}" >
		  <c:if test="${usercForm.opType == 'add'}" >
	           <div class="input_div">
	             <span class="label2">Database User Name:</span> 
	             <html:text name="usercForm" property="dbUserName" size="20" maxlength="30" /> 
	           </div>
	           <div class="input_div">
	             <span class="label2">Database User Password:</span> 
	             <html:password name="usercForm" property="password" size="20" maxlength="30" /> 
	           </div>
	           <div class="input_div">
	             <span class="label2">Database User Password (Confirm):</span> 
	             <html:password name="usercForm" property="passwordRepeat" size="20" maxlength="30" /> 
	           </div>
	           <div class="input_div">
	          	<span class="label">First Name:</span>
	          	<html:text styleId="txtFirstName" name="usercForm" property="firstName" size="20" maxlength="100" />
	          </div>
	          <div class="input_div">
	            <span class="label">Last Name:</span> 
	            <html:text styleId="txtLastName" name="usercForm" property="lastName" size="20" maxlength="100" /> 
	          </div>
	          <div class="input_div">
	            <span class="label">Email:</span> 
	            <html:text styleId="txtEmail" name="usercForm" property="email" size="20" maxlength="100" /> 
	          </div>
		   <div class="input_div">
	             <input type="submit" class="submit-button" value="Test Connection"	                  
		            onclick="return go1(this,'Test Connection','db')"></input>
	             <c:if test="${not empty usercForm.testResult}">
	                &nbsp; 
		        <c:out value="${usercForm.testResult}" />
		     </c:if>
		   </div>
		   <div class="input_div">
	             <input type="submit" class="submit-button" value="Add"	                  
		            onclick="return go1(this,'Add DB User','db')"></input>
		   </div>
		  </c:if>
	
		  <c:if test="${usercForm.opType == 'edit'}" >
	           <div class="input_div">
	             <span class="label2">Database User Name:</span> 
	             <html:text name="usercForm" property="dbUserName" size="20" maxlength="30" disabled="true"/> 
	           </div>
	           <div class="input_div">
	             <span class="label2">Database User Password:</span> 
	             <html:password name="usercForm" property="password" size="20" maxlength="30" /> 
	           </div>
	           <div class="input_div">
	             <span class="label2">Database User Password (Confirm):</span> 
	             <html:password name="usercForm" property="passwordRepeat" size="20" maxlength="30" /> 
	           </div>
	           <div class="input_div">
	          	<span class="label">First Name:</span>
	          	<html:text styleId="txtFirstName" name="usercForm" property="firstName" size="20" maxlength="100" />
	          </div>
	          <div class="input_div">
	            <span class="label">Last Name:</span> 
	            <html:text styleId="txtLastName" name="usercForm" property="lastName" size="20" maxlength="100" /> 
	          </div>
	          <div class="input_div">
	            <span class="label">Email:</span> 
	            <html:text styleId="txtEmail" name="usercForm" property="email" size="20" maxlength="100" /> 
	          </div>
		   <div class="input_div">
	             <input type="submit" class="submit-button" value="Test Connection"	                  
		            onclick="return go1(this,'Test Connection','db')"></input>
	             <c:if test="${not empty usercForm.testResult}">
	                &nbsp; 
		        <c:out value="${usercForm.testResult}" />
		     </c:if>
		   </div>
		   <div class="input_div">
	             <input type="submit" class="submit-button" value="Save"	                  
		            onclick="return go1(this,'Edit DB User','db')"></input>
		   </div>
		  </c:if>
	
		</c:if>
	</div>
	<div>		
		<label id="lblError"></label>
	</div>
   <%-- userView end --%>
  </div>


</form>

<script>
     var divElem = $('userView');
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});
</script>
