/*
 * Utility functions
 *
 */

// namespace
var utils = new Object();

utils.trim = function(val) { // bl_trim
	if (val.length == 0) {
		return val;
	}
	var leftIdx = 0;
	for ( var i = 0; i < val.length; i++) {
		var c = val.charAt(i);
		if (c != ' ') {
			break;
		} else {
			leftIdx++;
		}
	}
	var rightIdx = val.length;
	for ( var i = val.length - 1; i >= leftIdx; i--) {
		if (val.charAt(i) != ' ') {
			break;
		} else {
			rightIdx--;
		}
	}
	return val.substring(leftIdx, rightIdx);
}

/* Hash table class */

utils.Hash = function() {
	this.length = 0;
	this.items = new Array();
	for ( var i = 0; i < arguments.length; i += 2) {
		if (typeof (arguments[i + 1]) != 'undefined') {
			this.items[arguments[i]] = arguments[i + 1];
			this.length++;
		}
	}

	this.removeItem = function(in_key) {
		var tmp_value;
		if (typeof (this.items[in_key]) != 'undefined') {
			this.length--;
			var tmp_value = this.items[in_key];
			delete this.items[in_key];
		}

		return tmp_value;
	}

	this.getItem = function(in_key) {
		return this.items[in_key];
	}

	this.setItem = function(in_key, in_value) {
		if (typeof (in_value) != 'undefined') {
			if (typeof (this.items[in_key]) == 'undefined') {
				this.length++;
			}
			this.items[in_key] = in_value;
		}
		return in_value;
	}

	this.hasItem = function(in_key) {
		return typeof (this.items[in_key]) != 'undefined';
	}
}

utils.xGetElementById = function(e) {
	if (typeof (e) == 'string') {
		if (document.getElementById)
			e = document.getElementById(e);
		else if (document.all)
			e = document.all[e];
		else
			e = null;
	}
	return e;
}

utils.xHasClass = function(e, c) {
	e = utils.xGetElementById(e);
	if (!e || e.className == '')
		return false;
	var re = new RegExp("(^|\\s)" + c + "(\\s|$)");
	return re.test(e.className);
}

utils.xAddClass = function(e, c) {
	if ((e = utils.xGetElementById(e)) != null) {
		var s = '';
		if (e.className.length
				&& e.className.charAt(e.className.length - 1) != ' ') {
			s = ' ';
		}
		if (!utils.xHasClass(e, c)) {
			e.className += s + c;
			return true;
		}
	}
	return false;
}

utils.dumpProperties = function(anObj, bShow) {
	if (!anObj)
		return null;
	var descr = "";
	for ( var i in anObj) {
		var prop = anObj[i];
		descr += i + "=" + prop + "\n";
	}
	if (bShow)
		alert(descr);
	return descr;
}

utils.strEndsWith = function(src, suffix) {
	var d = src.length - suffix.length;
	return d >= 0 && src.indexOf(suffix) == d;
}

// for expand/collapse table rows

utils.collapseExpand = function(parentElem, asIdx) {
	var elemId = "as_" + asIdx + "_t0";
	var elem = $(elemId);
	if (elem) {
		var children = parentElem.descendants();
		if (children && children.length > 0) {
			imgElem = children[0];
			if (utils.strEndsWith(imgElem.src, "images/collapse.gif")) {
				imgElem.src = "images/expand.gif";
			} else {
				imgElem.src = "images/collapse.gif";
			}
		}
		elem.toggle();
		utils.toggleAll("as_" + asIdx + "_t", 1);
		utils.toggleAll("as_" + asIdx + "_v", 0);
		var id = 'as_ms' + asIdx + "_1";
		var msElem = $(id);
		if (msElem) {
			msElem.toggle();
			msElem = $('as_ms' + asIdx + "_2");
			if (msElem) {
				msElem.toggle();
			}
		}
	}
	return false;
}

utils.toggleAll = function(prefix, startIdx) {
	var elemId = prefix + startIdx;
	var elem = null;
	var count = 0;
	while ((elem = $(elemId))) {
		elem.toggle();
		startIdx++;
		elemId = prefix + startIdx;
		++count;
		if (count > 1000)
			break;
	}
}

/*
 * formats file size in bytes in human readable shorthand format
 */
utils.formatFileSize = function(fileSize) {
	var s = '';
	if (fileSize < 1024) {
		s = fileSize + 'B';
	} else if (fileSize >= 1024 && fileSize < 1048576) {
		s = Math.round(fileSize / 1024.0) + 'Kb';
	} else if (fileSize >= 1048576 && fileSize < 1073741824) {
		s = Math.round(fileSize / 1048576.0) + 'Mb';
	} else if (fileSize >= 1073741824) {
		var value = fileSize / 1073741824.0;
		s = Math.round(value * 100) / 100 + 'Gb';
	}
	return s;
}

// DOM creation utilities

utils.createSelect = function(id, opts) {
	var nd = document.createElement('select');
	if (id)
		nd.setAttribute("id", id);
	if (opts) {
		for ( var i = 0; i < opts.length; i++) {
			var option = new Option(opts[i].label, opts[i].value);
			try {
				nd.add(option, null);
			} catch (e) {
				nd.add(option, -1);
			}
		}
	}
	return nd;
}

utils.styledText = function(text, style) {
	var nd = document.createElement('span');
	var txtNode = document.createTextNode(text);
	nd.appendChild(txtNode);
	nd = $(nd);
	if (style)
		nd.setStyle(style);
	return nd;
}

utils.newDomNode = function(tag, id, content) {
	var nd = document.createElement(tag);
	if (id)
		nd.setAttribute("id", id);
	if (content) {
		var txtNode = document.createTextNode(content);
		nd.appendChild(txtNode);
	}
	return $(nd);
}

utils.newRadioBut = function(id, name, label, value, checked) {
	return utils.newCheckable('radio', id, name, label, value, checked);
}

utils.newCheckBox = function(id, name, label, value, checked) {
	return utils.newCheckable('checkbox', id, name, label, value, checked);
}

utils.newCheckable = function(type, id, name, label, value, checked) {
	var nd = document.createElement('input');
	nd.setAttribute('type', type);
	if (id)
		nd.setAttribute('id', id);
	if (name)
		nd.setAttribute('name', name);
	if (value)
		nd.setAttribute('value', value);
	if (checked)
		nd.checked = true;
	labelEl = document.createElement("label");
	labelEl.appendChild(nd);
	var txtNd = document.createTextNode(label ? label : value);
	labelEl.appendChild(txtNd);
	return $(labelEl);
}

utils.createHiddenField = function(name, value) {
	var he = document.createElement('input');
	he.type = 'hidden';
	he.name = name;
	he.value = value;
	return he;
}

utils.openRemote = function(aURL, aName, aHeight, aWidth, features, orgName) {
	if (aHeight) {
		aHeight = screen.availHeight - 80;
	}
	if (aWidth) {
		aWidth = screen.availWidth - 30;
	}
	var newFeatures = "height=" + aHeight + ",innerHeight=" + aHeight;
	newFeatures += ",width=" + aWidth + ",innerWidth=" + aWidth;
	if (window.screen) {
		var ah = screen.availHeight - 30;
		var aw = screen.availWidth - 10;
		var xc = (aw - aWidth) / 2;
		var yc = (ah - aHeight) / 2;
		newFeatures += ",left=" + xc + ",screenX=" + xc;
		newFeatures += ",top=" + yc + ",screenY=" + yc;
		newFeatures += "," + features;
	}
	var newWin = openWindow(aURL, aName, newFeatures, orgName);
	newWin.focus();
	return newWin;
}

utils.openWindow = function(aURL, aName, features, orgName) {
	var aWin = open(aURL, aName, features);
	if (aWin.opener == null) {
		aWin.opener = window;
	}
	aWin.opener.name = orgName;
	return aWin;
}

/*
 * given a form name and element name returns the corresponding element from the
 * form or null if there is no such element.
 */
utils.findElement = function(form, elemName) {
	var i;
	for (i = 0; i < form.elements.length; ++i) {
		if (form.elements[i].name == elemName)
			return form.elements[i];
	}
	return null;
}

utils.scrollX = function() {
	var de = document.documentElement;
	return self.pageXOffset || (de & de.scrollLeft) || document.body.scrollLeft;
}

utils.scrollY = function() {
	var de = document.documentElement;
	return self.pageYOffset || (de && de.scrollTop) || document.body.scrollTop;
}

utils.windowHeight = function() {
	var de = document.documentElement;
	return self.innerHeight || (de && de.clientHeight)
			|| document.body.clientHeight;
}

utils.windowWidth = function() {
	var de = document.documentElement;
	return self.innerWidth || (de && de.clientWidth)
			|| document.body.clientWidth;
}

utils.getStyle = function(elem, name) {
	if (elem.style[name]) {
		return elem.style[name];
	} else if (elem.currentStyle) {
		return elem.currentStyle[name];
	} else if (document.defaultView && document.defaultView.getComputedStyle) {
		name = name.replace(/([A-Z])/g, "-$1");
		name = name.toLowerCase();
		var s = document.defaultView.getComputedStyle(elem, "");
		return s && s.getPropertyValue(name);
	}
	return null;
}

utils.hide = function(elem) {
	var curStyle = utils.getStyle(elem, 'display');
	if (curStyle != 'none')
		elem.$oldDisplay = curStyle;
	elem.style.display = 'none';
	elem.style.visibility = 'hidden';
}

utils.show = function(elem) {
	elem.style.display = elem.$oldDisplay || '';
	elem.style.visibility = 'visible';
}
