package clinical.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DBChangeNotifySupport.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class DBChangeNotifySupport {
	protected static DBChangeNotifySupport instance = null;
	protected DBChangeSupport dcs;
	protected List<DBChangeNotifyListener> listeners = Collections
			.synchronizedList(new ArrayList<DBChangeNotifyListener>());

	protected DBChangeNotifySupport() {
		dcs = DBChangeSupport.getInstance();
	}

	public static synchronized DBChangeNotifySupport getInstance() {
		if (instance == null) {
			instance = new DBChangeNotifySupport();
		}
		return instance;
	}

	public void addDBChangeNotifyListener(DBChangeNotifyListener listener) {
		listeners.add(listener);
	}

	public void fireDBChangeNotifyEvent(String siteID, String tableName) {
		fireDBChangeNotifyEvent(siteID, new String[] { tableName });
	}

	public void fireDBChangeNotifyEvent(String siteID, String[] tableNames) {
		List<String> tbNames = new ArrayList<String>(tableNames.length);
		for (String tn : tableNames) {
			tn = tn.toLowerCase().replaceFirst("^nc_", "");
			tbNames.add(tn);
		}
		DBChange dbChange = new DBChange(siteID);
		for (String tn : tbNames) {
			TableChange tc = new TableChange(tn, TableChange.TABLE_CHANGED);
			dbChange.add(tc);
		}
		DBChangeEvent ev = new DBChangeEvent(dbChange);
		List<DBChangeNotifyListener> lsnrs = new ArrayList<DBChangeNotifyListener>(
				listeners);
		for (DBChangeNotifyListener lsnr : lsnrs) {
			lsnr.dbChanged(ev);
		}

		// notify local listeners
		dcs.fireDBChangeEvent(ev);

	}
}
