package clinical.comm;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

/**
 * @author I. Burak Ozyurt
 * @version $Id: Association.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class Association implements IXMLSerializer {
  protected Map<String, IXMLSerializer> map = new LinkedHashMap<String, IXMLSerializer>();

  public Association() {}


  public void put(String key, IXMLSerializer value) {
    map.put(key, value);
  }

  public IXMLSerializer get(String key) {
    return map.get(key);
  }

  public Element toXML() {
    Element e = new Element("association");
    for (Map.Entry<String,IXMLSerializer> entry : map.entrySet()) {
      Element ee = new Element("elem");
      ee.setAttribute("key", (String) entry.getKey());
      IXMLSerializer ixs = (IXMLSerializer) entry.getValue();
      Element ve = ixs.toXML();
      ee.addContent(ve);
      e.addContent(ee);
    }
    return e;
  }

  public void initializeFromXML(Element e) {
    List<?> children = e.getChildren("elem");
    for (Iterator<?> iter = children.iterator(); iter.hasNext(); ) {
      Element ee = (Element)iter.next();
      String key = ee.getAttributeValue("key");
      List<?> cl = ee.getChildren();
      if ( cl != null && !cl.isEmpty() ) {
        Element ve = (Element) cl.get(0);
        IXMLSerializer value = Utils.initFromXML(ve);
        put(key, value);
      }
    }
  }
}

