package clinical.comm;

import org.jdom.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Response.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class Response implements IXMLSerializer {
  protected Parameter param;

  public Response() {}

//---------------------- setters --------------
  public void setParam(Parameter newParam) { this.param = newParam; }
//---------------------- getters --------------
  public Parameter getParam() { return this.param; }

  public boolean hasFault() {
    return (param != null && param.getValue() instanceof Fault);
  }

  public Fault getFault() {
    if ( param == null) return null;
    if (param.getValue() instanceof Fault) {
      return (Fault) param.getValue();
    }
    return null;
  }

  public Element toXML() {
    Element e = new Element("response");
    if (param != null) {
      Element pe = param.toXML();
      e.addContent(pe);
    }
    return e;
  }


  public void initializeFromXML(Element e) {
    Element pe = e.getChild("param");
    if (pe != null) {
      Parameter p = new Parameter();
      p.initializeFromXML(pe);
      setParam(p);
    }
  }

}
