package clinical.comm;

import java.io.*;

import org.jdom.*;
import org.jdom.input.*;
import org.jdom.output.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: TransportHandler.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class TransportHandler {
  protected BufferedReader reader;
  protected Writer writer;
  protected boolean debugMode = false;


  public TransportHandler(BufferedReader reader, Writer writer) {
    this.reader = reader;
    this.writer = writer;
  }

  //---------------------- setters --------------
  public void setDebugMode(boolean newDebugMode) { this.debugMode = newDebugMode; }
  //---------------------- getters --------------
  public boolean getDebugMode() { return this.debugMode; }


  protected void logMessage(Element e, String title) throws IOException{
    XMLOutputter xmlOut = new XMLOutputter();
    StringWriter sw = new StringWriter();
    xmlOut.output(e, sw);
    System.out.println(title + " " + sw.toString());
  }

  public Response sendRequest(Request request) throws XMLMessagingException {
    try {
      writer.write("BEGIN"); writer.write("\n");
      Element e = request.toXML();
      XMLOutputter xmlOut = new XMLOutputter();
      xmlOut.output(e, writer);
      if ( debugMode) {
       logMessage(e, "request=");
      } else {
        System.out.println("not in debug mode!");
      }
      writer.write("\n");
      writer.write("END"); writer.write("\n");
      writer.flush();
      // get response
      String line = reader.readLine();
      if ( line.equals("BEGIN") ) {
        line = reader.readLine();
        StringBuffer buf = new StringBuffer(1000);
        while ( !line.equals("END") ) {
          buf.append( line).append("\n");
          line = reader.readLine();
        }
        if (debugMode) {
          System.out.println("response=" + buf.toString());
        }
        Element re = toDOM(buf);
        Response rs = new Response();
        rs.initializeFromXML(re);
        return rs;
      } else {
        /** @todo return fault response */
        return new Response();
      }
    } catch(Throwable t) {
      throw new XMLMessagingException(t);
    }
  }


  public Request receiveRequest() throws XMLMessagingException {
    try {
      String line = reader.readLine();
      if (line == null)
        return null;
      if ( line.equals("BEGIN") ) {
        line = reader.readLine();
        StringBuffer buf = new StringBuffer(1000);
        while ( !line.equals("END") ) {
          buf.append( line).append("\n");
          line = reader.readLine();
        }
        if ( debugMode) {
          System.out.println("received request=" + buf.toString());
        }

        Element re = toDOM(buf);
        Request rq = new Request();
        rq.initializeFromXML(re);
        return rq;
      } else {
        return null;
      }
    } catch(Exception x) {
      throw new XMLMessagingException(x);
    }
  }

  public void sendResponse(Response response) throws XMLMessagingException {
    try {
      writer.write("BEGIN"); writer.write("\n");
      Element e = response.toXML();
      if ( debugMode) {
        logMessage(e," response to be send =");
      }

      XMLOutputter xmlOut = new XMLOutputter();
      xmlOut.output(e, writer);
      writer.write("\n");
      writer.write("END"); writer.write("\n");
      writer.flush();
    } catch(Exception x) {
      throw new XMLMessagingException(x);
    }
  }

  /**
   * if response contains a <code>Fault</code> returns that fault,
   * otherwise returns null.
   *
   * @param response
   * @return
   */
  public Fault getFault(Response response)  {
    if ( response == null)
      return null;
    Parameter p = response.getParam();
    if ( p == null || !(p.getValue() instanceof Fault))
      return null;
    return (Fault) p.getValue();
  }

  protected Element toDOM(StringBuffer buf ) throws Exception {
    SAXBuilder builder = null;

    builder = new SAXBuilder(false);
    StringReader sr = new StringReader( buf.toString() );
    org.jdom.Document doc = builder.build( sr );
    Element e = doc.getRootElement();
    return e;
  }

  public BufferedReader getReader() { return this.reader; }
  public Writer getWriter() { return this.writer; }

}

