package clinical.comm;

import org.jdom.*;
import java.util.Date;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Utils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class Utils {

  protected Utils() {}

  public static IXMLSerializer initFromXML(Element e) {
    if ( e.getName().equals("simple-var") ) {
      SimpleDataType sdt = new SimpleDataType();
      sdt.initializeFromXML(e);
      return sdt;
    } else if ( e.getName().equals("struct") ) {
      Struct s = new Struct();
      s.initializeFromXML(e);
      return s;
    } else if ( e.getName().equals("collection") ) {
      Collection c = new Collection();
      c.initializeFromXML(e);
      return c;
    } else if ( e.getName().equals("association") ) {
      Association a= new Association();
      a.initializeFromXML(e);
      return a;
    } else if ( e.getName().equals("fault") ) {
      Fault f = new Fault();
      f.initializeFromXML(e);
      return f;
    } else if ( e.getName().equals("envelope") ) {
      Envelope env = new Envelope();
      env.initializeFromXML(e);
      return env;
    } else {
      throw new RuntimeException("Unknown type:" + e.getName() );
    }
  }

  public static Object getSimpleDataType(SimpleDataType sdt) {
    if ( sdt == null)
      return null;
    String cl = sdt.getClassName();
    if ( cl.equalsIgnoreCase("java.lang.String") || cl.equalsIgnoreCase("string") ) {
      return sdt.getValue();
    } else if ( cl.equalsIgnoreCase("java.lang.Boolean") || cl.equalsIgnoreCase("boolean") ) {
      return new Boolean( sdt.getValue() );
    } else if ( cl.equalsIgnoreCase("java.lang.Integer") || cl.equalsIgnoreCase("int") ) {
      return new Integer( sdt.getValue() );
    } else if ( cl.equalsIgnoreCase("java.lang.Double") || cl.equalsIgnoreCase("double") ) {
      return new Double( sdt.getValue() );
    } else if ( cl.equalsIgnoreCase("java.util.Date") || cl.equalsIgnoreCase("date") ) {
      return new Date( Long.parseLong( sdt.getValue() ) );
    } else {
       throw new RuntimeException("Not a supported data type: "+ cl);
    }
  }

}

