package clinical.server;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentscore;

/**
 * 
 * @version $Id: ScoreInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 * @author I. Burak Ozyurt
 */

public class ScoreInfo implements java.io.Serializable {
	private static final long serialVersionUID = 60238729329893010L;
	protected Assessment assessment;
	protected Assessmentscore asScore;
	protected List<AssessmentValue> values = new LinkedList<AssessmentValue>();
	protected int type;
	public final static int INT = 1;
	public final static int FLOAT = 2;
	public final static int STRING = 3;
	public final static int BOOL = 4;

	public ScoreInfo(Assessment assessment, Assessmentscore asScore) {
		type = INT;
		this.assessment = assessment;
		this.asScore = asScore;
	}

	protected void findType(Object value) {
		if (value instanceof Integer) {
			type = INT;
		} else if (value instanceof Float) {
			type = FLOAT;
		} else if (value instanceof Boolean) {
			type = BOOL;
		} else if (value instanceof String) {
			type = STRING;
		} else
			throw new RuntimeException("not a supported Score value type"
					+ value);
	}

	public void addValue(Object value, Object normValue, int visitID,
			int segmentID, int experimentID, String subjectID, Date date,
			String comments) {
		// assert(value != null);
		if (values.isEmpty())
			findType(value);
		values.add(new AssessmentValue(value, normValue, visitID, experimentID,
				subjectID, segmentID, date, comments));
	}

	public List<AssessmentValue> getValues() {
		return values;
	}

	// ---------------------- setters --------------
	public void setAssessment(Assessment newAssessment) {
		this.assessment = newAssessment;
	}

	public void setAsScore(Assessmentscore newAsScore) {
		this.asScore = newAsScore;
	}

	// ---------------------- getters --------------
	public Assessment getAssessment() {
		return this.assessment;
	}

	public Assessmentscore getAsScore() {
		return this.asScore;
	}

	public int getType() {
		return type;
	}

	public static class AssessmentValue implements java.io.Serializable {
		private static final long serialVersionUID = 7322903192497942323L;
		Object value;
		Object normValue;
		int segmentID; // scan, clinical test at the visit
		int visitID; // componentID in nc_expcomponent
		int experimentID;
		String subjectID; // birnID
		java.util.Date date; // date's granularity is more than good enough
		String comments;

		public AssessmentValue(Object value, Object normValue, int visitID,
				int experimentID, String subjectID, int segmentID, Date date,
				String comments) {
			this.value = value;
			this.normValue = normValue;
			this.visitID = visitID;
			this.experimentID = experimentID;
			this.subjectID = subjectID;
			this.date = date;
			this.comments = comments;
			this.segmentID = segmentID;
		}

		public Object getValue() {
			return this.value;
		}

		public Object getNormValue() {
			return this.normValue;
		}

		public int getVisitID() {
			return this.visitID;
		}

		public int getExperimentID() {
			return this.experimentID;
		}

		public String getSubjectID() {
			return subjectID;
		}

		public Date getDate() {
			return date;
		}

		public String getComments() {
			return comments;
		}

		public int getSegmentID() {
			return segmentID;
		}

		public String toString() {
			StringBuffer buf = new StringBuffer(256);
			buf.append("AssessmentValue::[");
			if (value != null)
				buf.append("value=").append(value).append(',');
			buf.append("visitID=").append(visitID).append(',');
			buf.append("experimentID=").append(experimentID).append(',');
			buf.append("subjectID=").append(subjectID).append(',');
			buf.append("date=").append(date).append(']');
			return buf.toString();
		}
	}

}