package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ConfWebuserPriv;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ConfWebuserPrivDAO implements
		clinical.server.dao.ConfWebuserPrivDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ConfWebuserPrivDAO() {
	}

	public void insert(Connection con, ConfWebuserPriv bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_CONF_WEBUSER_PRIV ");
			buf
					.append(" (UNIQUE_ID,WEBUSER_ID,PRIV_NAME,OWNER,MOD_TIME,MOD_USER) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 6; ++i) {
				buf.append('?');
				if (i < 5)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueId(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getWebuserId(),
					Types.NUMERIC);
			ps.setObject(3, (String) bean.getPrivName(), Types.VARCHAR);
			ps.setObject(4, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(5, bean.getModTime() == null ? null
					: new java.sql.Timestamp(bean.getModTime().getTime()));
			ps.setObject(6, (java.math.BigDecimal) bean.getModUser(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(ConfWebuserPriv bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUE_ID");
		buf.append(',');
		buf.append("WEBUSER_ID");
		buf.append(',');
		buf.append("PRIV_NAME");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MOD_TIME");
		buf.append(',');
		buf.append("MOD_USER");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ConfWebuserPriv bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUE_ID=?");
			qi.values.add(bean.getUniqueId());
			valueSet = true;
		}
		if (bean.getWebuserId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("WEBUSER_ID=?");
			qi.values.add(bean.getWebuserId());
			valueSet = true;
		}
		if (bean.getPrivName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PRIV_NAME=?");
			qi.values.add(bean.getPrivName());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MOD_TIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MOD_USER=?");
			qi.values.add(bean.getModUser());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ConfWebuserPriv bean,
			ConfWebuserPriv criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_CONF_WEBUSER_PRIV SET ");

		if (bean.getUniqueId() != null || bean.isNull("uniqueId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUE_ID=? ");
			uqi.setValues.add(bean.getUniqueId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueId"), uqi);
			valueSet = true;
		}
		if (bean.getWebuserId() != null || bean.isNull("webuserId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("WEBUSER_ID=? ");
			uqi.setValues.add(bean.getWebuserId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("webuserId"), uqi);
			valueSet = true;
		}
		if (bean.getPrivName() != null || bean.isNull("privName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PRIV_NAME=? ");
			uqi.setValues.add(bean.getPrivName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("privName"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModTime() != null || bean.isNull("modTime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MOD_TIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModTime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modTime"), uqi);
			valueSet = true;
		}
		if (bean.getModUser() != null || bean.isNull("modUser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MOD_USER=? ");
			uqi.setValues.add(bean.getModUser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("modUser"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public ConfWebuserPriv createObject(ResultSet rs) throws SQLException {
		ConfWebuserPriv obj = new ConfWebuserPriv();
		obj.setUniqueId((java.math.BigDecimal) rs.getObject(1));
		obj.setWebuserId((java.math.BigDecimal) rs.getObject(2));
		obj.setPrivName((String) rs.getObject(3));
		obj.setOwner((java.math.BigDecimal) rs.getObject(4));
		if (rs.getTimestamp(5) != null) {
			obj.setModTime(new java.util.Date(rs.getTimestamp(5).getTime()));
		}
		obj.setModUser((java.math.BigDecimal) rs.getObject(6));
		return obj;
	}

	public List<ConfWebuserPriv> find(Connection con, ConfWebuserPriv criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ConfWebuserPriv> results = new LinkedList<ConfWebuserPriv>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_CONF_WEBUSER_PRIV ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ConfWebuserPriv item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ConfWebuserPriv bean,
			ConfWebuserPriv criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ConfWebuserPriv criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_CONF_WEBUSER_PRIV ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
