package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Tuplecolumns;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TuplecolumnsDAO implements clinical.server.dao.TuplecolumnsDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TuplecolumnsDAO() {
	}

	public void insert(Connection con, Tuplecolumns bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_TUPLECOLUMNS ");
			buf
					.append(" (EXTENDEDTUPLEID,COLUMNNAME,COLUMNTYPE,TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,DEFAULTVALUE,NULLABLE,COLUMNONTOLOGY,COLUMNCONCEPT,MEASUREMENTSYSTEM,MEASUREMENTUNIT) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 14; ++i) {
				buf.append('?');
				if (i < 13)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getExtendedtupleid(),
					Types.NUMERIC);
			ps.setObject(2, (String) bean.getColumnname(), Types.VARCHAR);
			ps.setObject(3, (String) bean.getColumntype(), Types.VARCHAR);
			ps.setObject(4, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(5, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(7, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(8, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(9, (String) bean.getDefaultvalue(), Types.VARCHAR);
			ps.setObject(10, boolean2Number((Boolean) bean.getNullable()),
					Types.NUMERIC);
			ps.setObject(11, (String) bean.getColumnontology(), Types.VARCHAR);
			ps.setObject(12, (String) bean.getColumnconcept(), Types.VARCHAR);
			ps.setObject(13, (String) bean.getMeasurementsystem(),
					Types.VARCHAR);
			ps.setObject(14, (String) bean.getMeasurementunit(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Tuplecolumns bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("EXTENDEDTUPLEID");
		buf.append(',');
		buf.append("COLUMNNAME");
		buf.append(',');
		buf.append("COLUMNTYPE");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("DEFAULTVALUE");
		buf.append(',');
		buf.append("NULLABLE");
		buf.append(',');
		buf.append("COLUMNONTOLOGY");
		buf.append(',');
		buf.append("COLUMNCONCEPT");
		buf.append(',');
		buf.append("MEASUREMENTSYSTEM");
		buf.append(',');
		buf.append("MEASUREMENTUNIT");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Tuplecolumns bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getExtendedtupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXTENDEDTUPLEID=?");
			qi.values.add(bean.getExtendedtupleid());
			valueSet = true;
		}
		if (bean.getColumnname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COLUMNNAME=?");
			qi.values.add(bean.getColumnname());
			valueSet = true;
		}
		if (bean.getColumntype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COLUMNTYPE=?");
			qi.values.add(bean.getColumntype());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getDefaultvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DEFAULTVALUE=?");
			qi.values.add(bean.getDefaultvalue());
			valueSet = true;
		}
		if (bean.getNullable() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NULLABLE=?");
			qi.values.add(boolean2Number((Boolean) bean.getNullable()));
			valueSet = true;
		}
		if (bean.getColumnontology() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COLUMNONTOLOGY=?");
			qi.values.add(bean.getColumnontology());
			valueSet = true;
		}
		if (bean.getColumnconcept() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COLUMNCONCEPT=?");
			qi.values.add(bean.getColumnconcept());
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MEASUREMENTSYSTEM=?");
			qi.values.add(bean.getMeasurementsystem());
			valueSet = true;
		}
		if (bean.getMeasurementunit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MEASUREMENTUNIT=?");
			qi.values.add(bean.getMeasurementunit());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Tuplecolumns bean,
			Tuplecolumns criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_TUPLECOLUMNS SET ");

		if (bean.getExtendedtupleid() != null || bean.isNull("extendedtupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXTENDEDTUPLEID=? ");
			uqi.setValues.add(bean.getExtendedtupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("extendedtupleid"), uqi);
			valueSet = true;
		}
		if (bean.getColumnname() != null || bean.isNull("columnname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COLUMNNAME=? ");
			uqi.setValues.add(bean.getColumnname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnname"), uqi);
			valueSet = true;
		}
		if (bean.getColumntype() != null || bean.isNull("columntype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COLUMNTYPE=? ");
			uqi.setValues.add(bean.getColumntype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columntype"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getDefaultvalue() != null || bean.isNull("defaultvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DEFAULTVALUE=? ");
			uqi.setValues.add(bean.getDefaultvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("defaultvalue"), uqi);
			valueSet = true;
		}
		if (bean.getNullable() != null || bean.isNull("nullable")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NULLABLE=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getNullable()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("nullable"), uqi);
			valueSet = true;
		}
		if (bean.getColumnontology() != null || bean.isNull("columnontology")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COLUMNONTOLOGY=? ");
			uqi.setValues.add(bean.getColumnontology());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnontology"), uqi);
			valueSet = true;
		}
		if (bean.getColumnconcept() != null || bean.isNull("columnconcept")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COLUMNCONCEPT=? ");
			uqi.setValues.add(bean.getColumnconcept());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnconcept"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null
				|| bean.isNull("measurementsystem")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MEASUREMENTSYSTEM=? ");
			uqi.setValues.add(bean.getMeasurementsystem());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementsystem"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementunit() != null || bean.isNull("measurementunit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MEASUREMENTUNIT=? ");
			uqi.setValues.add(bean.getMeasurementunit());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementunit"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Tuplecolumns createObject(ResultSet rs) throws SQLException {
		Tuplecolumns obj = new Tuplecolumns();
		obj.setExtendedtupleid((java.math.BigDecimal) rs.getObject(1));
		obj.setColumnname((String) rs.getObject(2));
		obj.setColumntype((String) rs.getObject(3));
		obj.setTableid((java.math.BigDecimal) rs.getObject(4));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(5));
		obj.setOwner((java.math.BigDecimal) rs.getObject(6));
		if (rs.getTimestamp(7) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(7).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(8));
		obj.setDefaultvalue((String) rs.getObject(9));
		obj.setNullable(convert2Boolean(rs.getObject(10)));
		obj.setColumnontology((String) rs.getObject(11));
		obj.setColumnconcept((String) rs.getObject(12));
		obj.setMeasurementsystem((String) rs.getObject(13));
		obj.setMeasurementunit((String) rs.getObject(14));
		return obj;
	}

	public List<Tuplecolumns> find(Connection con, Tuplecolumns criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Tuplecolumns> results = new LinkedList<Tuplecolumns>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_TUPLECOLUMNS ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Tuplecolumns item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Tuplecolumns bean, Tuplecolumns criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Tuplecolumns criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_TUPLECOLUMNS ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
