package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.PostgresUtils;
import clinical.server.vo.Brainsegmentdata;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class BrainsegmentdataDAO implements
		clinical.server.dao.BrainsegmentdataDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public BrainsegmentdataDAO() {
	}

	public void insert(Connection con, Brainsegmentdata bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_brainsegmentdata VALUES ");
			buf.append('(');
			for (int i = 0; i < 22; ++i) {
				buf.append('?');
				if (i < 21)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getDataid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getSegmentid(), Types.NUMERIC);

			ps.setObject(4, bean.getComponentid(), Types.NUMERIC);

			ps.setObject(5, bean.getNcExperimentid(), Types.NUMERIC);

			ps.setObject(6, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(7, bean.getBrainregionname(), Types.VARCHAR);

			ps.setObject(8, bean.getLaterality(), Types.VARCHAR);

			ps.setObject(9, PostgresUtils.toDouble(bean.getMeasurement()),
					Types.DOUBLE);

			ps.setObject(10, bean.getMeasurementtype(), Types.VARCHAR);

			ps.setObject(11, bean.getUnit(), Types.VARCHAR);

			ps.setObject(12, bean.getOwner(), Types.NUMERIC);

			ps.setObject(13,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(14, bean.getModuser(), Types.NUMERIC);

			ps.setObject(15, bean.getOntologysource(), Types.VARCHAR);

			ps.setObject(16, bean.getConceptid(), Types.VARCHAR);

			ps.setObject(17, bean.getExtensionname(), Types.VARCHAR);

			ps.setObject(18, bean.getDatauri(), Types.VARCHAR);

			ps.setObject(19, bean.getIsraw());

			ps.setObject(20, bean.getMeasurementsystem(), Types.VARCHAR);

			ps.setObject(21, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(22, bean.getIsbad());

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Brainsegmentdata bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("dataid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("segmentid");
		buf.append(',');
		buf.append("componentid");
		buf.append(',');
		buf.append("nc_experimentid");
		buf.append(',');
		buf.append("subjectid");
		buf.append(',');
		buf.append("brainregionname");
		buf.append(',');
		buf.append("laterality");
		buf.append(',');
		buf.append("measurement");
		buf.append(',');
		buf.append("measurementtype");
		buf.append(',');
		buf.append("unit");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("ontologysource");
		buf.append(',');
		buf.append("conceptid");
		buf.append(',');
		buf.append("extensionname");
		buf.append(',');
		buf.append("datauri");
		buf.append(',');
		buf.append("israw");
		buf.append(',');
		buf.append("measurementsystem");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("isbad");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Brainsegmentdata bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getDataid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("dataid=?");
			qi.values.add(bean.getDataid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getSegmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("segmentid=?");
			qi.values.add(bean.getSegmentid());
			valueSet = true;
		}
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("componentid=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getNcExperimentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("nc_experimentid=?");
			qi.values.add(bean.getNcExperimentid());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("subjectid=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getBrainregionname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("brainregionname=?");
			qi.values.add(bean.getBrainregionname());
			valueSet = true;
		}
		if (bean.getLaterality() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("laterality=?");
			qi.values.add(bean.getLaterality());
			valueSet = true;
		}
		if (bean.getMeasurement() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("measurement=?");
			qi.values.add(PostgresUtils.toDouble(bean.getMeasurement()));
			valueSet = true;
		}
		if (bean.getMeasurementtype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("measurementtype=?");
			qi.values.add(bean.getMeasurementtype());
			valueSet = true;
		}
		if (bean.getUnit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("unit=?");
			qi.values.add(bean.getUnit());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getOntologysource() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ontologysource=?");
			qi.values.add(bean.getOntologysource());
			valueSet = true;
		}
		if (bean.getConceptid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("conceptid=?");
			qi.values.add(bean.getConceptid());
			valueSet = true;
		}
		if (bean.getExtensionname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("extensionname=?");
			qi.values.add(bean.getExtensionname());
			valueSet = true;
		}
		if (bean.getDatauri() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("datauri=?");
			qi.values.add(bean.getDatauri());
			valueSet = true;
		}
		if (bean.getIsraw() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("israw=?");
			qi.values.add(bean.getIsraw());
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("measurementsystem=?");
			qi.values.add(bean.getMeasurementsystem());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getIsbad() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isbad=?");
			qi.values.add(bean.getIsbad());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Brainsegmentdata bean,
			Brainsegmentdata criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_brainsegmentdata SET ");
		if (bean.getDataid() != null || bean.isNull("dataid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("dataid=? ");
			uqi.setValues.add(bean.getDataid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("dataid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getSegmentid() != null || bean.isNull("segmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("segmentid=? ");
			uqi.setValues.add(bean.getSegmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("segmentid"), uqi);
			valueSet = true;
		}
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("componentid=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getNcExperimentid() != null || bean.isNull("ncExperimentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("nc_experimentid=? ");
			uqi.setValues.add(bean.getNcExperimentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncExperimentid"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("subjectid=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getBrainregionname() != null || bean.isNull("brainregionname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("brainregionname=? ");
			uqi.setValues.add(bean.getBrainregionname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("brainregionname"), uqi);
			valueSet = true;
		}
		if (bean.getLaterality() != null || bean.isNull("laterality")) {
			if (valueSet)
				buf.append(", ");
			buf.append("laterality=? ");
			uqi.setValues.add(bean.getLaterality());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("laterality"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurement() != null || bean.isNull("measurement")) {
			if (valueSet)
				buf.append(", ");
			buf.append("measurement=? ");
			uqi.setValues.add(PostgresUtils.toDouble(bean.getMeasurement()));
			uqi.sqlTypes.add(new Integer(Types.DOUBLE));
			prepareNullSetListValue(bean.isNull("measurement"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementtype() != null || bean.isNull("measurementtype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("measurementtype=? ");
			uqi.setValues.add(bean.getMeasurementtype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementtype"), uqi);
			valueSet = true;
		}
		if (bean.getUnit() != null || bean.isNull("unit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("unit=? ");
			uqi.setValues.add(bean.getUnit());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("unit"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getOntologysource() != null || bean.isNull("ontologysource")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ontologysource=? ");
			uqi.setValues.add(bean.getOntologysource());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("ontologysource"), uqi);
			valueSet = true;
		}
		if (bean.getConceptid() != null || bean.isNull("conceptid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("conceptid=? ");
			uqi.setValues.add(bean.getConceptid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conceptid"), uqi);
			valueSet = true;
		}
		if (bean.getExtensionname() != null || bean.isNull("extensionname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("extensionname=? ");
			uqi.setValues.add(bean.getExtensionname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("extensionname"), uqi);
			valueSet = true;
		}
		if (bean.getDatauri() != null || bean.isNull("datauri")) {
			if (valueSet)
				buf.append(", ");
			buf.append("datauri=? ");
			uqi.setValues.add(bean.getDatauri());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("datauri"), uqi);
			valueSet = true;
		}
		if (bean.getIsraw() != null || bean.isNull("israw")) {
			if (valueSet)
				buf.append(", ");
			buf.append("israw=? ");
			uqi.setValues.add(bean.getIsraw());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("israw"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null
				|| bean.isNull("measurementsystem")) {
			if (valueSet)
				buf.append(", ");
			buf.append("measurementsystem=? ");
			uqi.setValues.add(bean.getMeasurementsystem());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementsystem"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getIsbad() != null || bean.isNull("isbad")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isbad=? ");
			uqi.setValues.add(bean.getIsbad());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("isbad"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Brainsegmentdata createObject(ResultSet rs) throws SQLException {
		Brainsegmentdata obj = new Brainsegmentdata();
		obj.setDataid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setSegmentid((rs.getObject(3) != null) ? new java.math.BigDecimal(
				rs.getObject(3).toString()) : null);
		obj
				.setComponentid((rs.getObject(4) != null) ? new java.math.BigDecimal(
						rs.getObject(4).toString())
						: null);
		obj
				.setNcExperimentid((rs.getObject(5) != null) ? new java.math.BigDecimal(
						rs.getObject(5).toString())
						: null);
		obj.setSubjectid((String) rs.getObject(6));
		obj.setBrainregionname((String) rs.getObject(7));
		obj.setLaterality((String) rs.getObject(8));
		obj.setMeasurement(PostgresUtils.toFloat(rs.getObject(9)));
		obj.setMeasurementtype((String) rs.getObject(10));
		obj.setUnit((String) rs.getObject(11));
		obj.setOwner((rs.getObject(12) != null) ? new java.math.BigDecimal(rs
				.getObject(12).toString()) : null);
		obj.setModtime((rs.getObject(13) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(13)).getTime()) : null);
		obj.setModuser((rs.getObject(14) != null) ? new java.math.BigDecimal(rs
				.getObject(14).toString()) : null);
		obj.setOntologysource((String) rs.getObject(15));
		obj.setConceptid((String) rs.getObject(16));
		obj.setExtensionname((String) rs.getObject(17));
		obj.setDatauri((String) rs.getObject(18));
		obj.setIsraw((Boolean) rs.getObject(19));
		obj.setMeasurementsystem((String) rs.getObject(20));
		obj.setUniqueid((rs.getObject(21) != null) ? new java.math.BigDecimal(
				rs.getObject(21).toString()) : null);
		obj.setIsbad((Boolean) rs.getObject(22));
		return obj;
	}

	public List<Brainsegmentdata> find(Connection con, Brainsegmentdata criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Brainsegmentdata> results = new LinkedList<Brainsegmentdata>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_brainsegmentdata ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Brainsegmentdata item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Brainsegmentdata bean,
			Brainsegmentdata criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Brainsegmentdata criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_brainsegmentdata ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	public List<Brainsegmentdata> findDistinctBrainRegions(Connection con)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Brainsegmentdata> results = new LinkedList<Brainsegmentdata>();
		StringBuffer buf = new StringBuffer(200);

		buf
				.append("select distinct brainregionname, laterality, measurementtype, unit from nc_brainsegmentdata ");
		try {
			ps = con.prepareStatement(buf.toString());
			rs = ps.executeQuery();
			while (rs.next()) {
				Brainsegmentdata obj = new Brainsegmentdata();
				obj.setBrainregionname((String) rs.getObject(1));
				obj.setLaterality((String) rs.getObject(2));
				obj.setMeasurementtype((String) rs.getObject(3));
				obj.setUnit((String) rs.getObject(4));

				results.add(obj);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	/* +++ */
}// ;
