package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.DefTupleAccess;
import clinical.web.exception.ValidationException;

public class DefTupleAccessDAO implements clinical.server.dao.DefTupleAccessDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public DefTupleAccessDAO() {
	}

	public void insert(Connection con, DefTupleAccess bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_DEF_TUPLE_ACCESS VALUES ");
			buf.append('(');
			for (int i = 0; i < 7; ++i) {
				buf.append('?');
				if (i < 6)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getTableId());
			ps.setObject(2, bean.getGrantee());
			ps.setObject(3, new java.sql.Date(bean.getModTime().getTime()));
			ps
					.setObject(
							4,
							((Boolean) bean.getCanRead()).booleanValue() ? new java.math.BigDecimal(
									"1")
									: new java.math.BigDecimal("0"));
			ps
					.setObject(
							5,
							((Boolean) bean.getCanWrite()).booleanValue() ? new java.math.BigDecimal(
									"1")
									: new java.math.BigDecimal("0"));
			ps
					.setObject(6, ((Boolean) bean.getCanDelete())
							.booleanValue() ? new java.math.BigDecimal("1")
							: new java.math.BigDecimal("0"));
			ps
					.setObject(
							7,
							((Boolean) bean.getCanAdmin()).booleanValue() ? new java.math.BigDecimal(
									"1")
									: new java.math.BigDecimal("0"));
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(DefTupleAccess bean) {
		StringBuffer buf = new StringBuffer(200);

		buf.append("TABLE_ID");
		buf.append(',');
		buf.append("GRANTEE");
		buf.append(',');
		buf.append("MOD_TIME");
		buf.append(',');
		buf.append("CAN_READ");
		buf.append(',');
		buf.append("CAN_WRITE");
		buf.append(',');
		buf.append("CAN_DELETE");
		buf.append(',');
		buf.append("CAN_ADMIN");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(DefTupleAccess bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getTableId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLE_ID=?");
			qi.values.add(bean.getTableId());
			valueSet = true;
		}
		if (bean.getGrantee() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("GRANTEE=?");
			qi.values.add(bean.getGrantee());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MOD_TIME=?");
			qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getCanRead() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_READ=?");
			qi.values
					.add(((Boolean) bean.getCanRead()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		if (bean.getCanWrite() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_WRITE=?");
			qi.values
					.add(((Boolean) bean.getCanWrite()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		if (bean.getCanDelete() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_DELETE=?");
			qi.values
					.add(((Boolean) bean.getCanDelete()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		if (bean.getCanAdmin() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_ADMIN=?");
			qi.values
					.add(((Boolean) bean.getCanAdmin()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(DefTupleAccess bean,
			DefTupleAccess criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_DEF_TUPLE_ACCESS SET ");

		if (bean.getTableId() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLE_ID=? ");
			uqi.setValues.add(bean.getTableId());
			valueSet = true;
		}
		if (bean.getGrantee() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("GRANTEE=? ");
			uqi.setValues.add(bean.getGrantee());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("MOD_TIME=? ");
			uqi.setValues.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getCanRead() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_READ=? ");
			uqi.setValues
					.add(((Boolean) bean.getCanRead()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		if (bean.getCanWrite() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_WRITE=? ");
			uqi.setValues
					.add(((Boolean) bean.getCanWrite()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		if (bean.getCanDelete() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_DELETE=? ");
			uqi.setValues
					.add(((Boolean) bean.getCanDelete()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		if (bean.getCanAdmin() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_ADMIN=? ");
			uqi.setValues
					.add(((Boolean) bean.getCanAdmin()).booleanValue() ? new java.math.BigDecimal(
							"1")
							: new java.math.BigDecimal("0"));
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	public DefTupleAccess createObject(ResultSet rs) throws SQLException {
		DefTupleAccess obj = new DefTupleAccess();
		obj.setTableId((java.math.BigDecimal) rs.getObject(1));
		obj.setGrantee((java.math.BigDecimal) rs.getObject(2));
		obj.setModTime((java.util.Date) rs.getObject(3));
		obj
				.setCanRead(((java.math.BigDecimal) rs.getObject(4)).intValue() > 0 ? new Boolean(
						true)
						: new Boolean(false));
		obj
				.setCanWrite(((java.math.BigDecimal) rs.getObject(5))
						.intValue() > 0 ? new Boolean(true)
						: new Boolean(false));
		obj
				.setCanDelete(((java.math.BigDecimal) rs.getObject(6))
						.intValue() > 0 ? new Boolean(true)
						: new Boolean(false));
		obj
				.setCanAdmin(((java.math.BigDecimal) rs.getObject(7))
						.intValue() > 0 ? new Boolean(true)
						: new Boolean(false));
		return obj;
	}

	public List find(Connection con, DefTupleAccess criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List results = new LinkedList();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_DEF_TUPLE_ACCESS ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				DefTupleAccess item = createObject(rs);
				results.add(item);
			}
		} finally {
			if (rs != null)
				try {
					rs.close();
				} catch (Exception x) { /* ignore */
				}
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
		return results;
	}

	public void update(Connection con, DefTupleAccess bean,
			DefTupleAccess criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			for (Iterator it = uqi.setValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			// for where part
			for (Iterator it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	public void delete(Connection con, DefTupleAccess criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_DEF_TUPLE_ACCESS ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	public static class QueryInfo {
		String whereClause;
		List values = new LinkedList();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List setValues = new LinkedList();
		List whereValues = new LinkedList();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
