package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Site;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class SiteDAO implements clinical.server.dao.SiteDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public SiteDAO() {
	}

	public void insert(Connection con, Site bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_site VALUES ");
			buf.append('(');
			for (int i = 0; i < 17; ++i) {
				buf.append('?');
				if (i < 16)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getOwner(), Types.NUMERIC);

			ps.setObject(4,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(5, bean.getModuser(), Types.NUMERIC);

			ps.setObject(6, bean.getSiteid(), Types.VARCHAR);

			ps.setObject(7, bean.getSitename(), Types.VARCHAR);

			ps.setObject(8, bean.getIsprimary(), Types.NUMERIC);

			ps.setObject(9, bean.getDatabaseaddress(), Types.VARCHAR);

			ps.setObject(10, bean.getDatabasename(), Types.VARCHAR);

			ps.setObject(11, bean.getDatabasevendor(), Types.VARCHAR);

			ps.setObject(12, bean.getDatabaseversion(), Types.VARCHAR);

			ps.setObject(13, bean.getDatabaseport(), Types.NUMERIC);

			ps.setObject(14, bean.getContactfirstname(), Types.VARCHAR);

			ps.setObject(15, bean.getContactlastname(), Types.VARCHAR);

			ps.setObject(16, bean.getContactemail(), Types.VARCHAR);

			ps.setObject(17, bean.getContactphone(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Site bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("siteid");
		buf.append(',');
		buf.append("sitename");
		buf.append(',');
		buf.append("isprimary");
		buf.append(',');
		buf.append("databaseaddress");
		buf.append(',');
		buf.append("databasename");
		buf.append(',');
		buf.append("databasevendor");
		buf.append(',');
		buf.append("databaseversion");
		buf.append(',');
		buf.append("databaseport");
		buf.append(',');
		buf.append("contactfirstname");
		buf.append(',');
		buf.append("contactlastname");
		buf.append(',');
		buf.append("contactemail");
		buf.append(',');
		buf.append("contactphone");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Site bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getSiteid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("siteid=?");
			qi.values.add(bean.getSiteid());
			valueSet = true;
		}
		if (bean.getSitename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("sitename=?");
			qi.values.add(bean.getSitename());
			valueSet = true;
		}
		if (bean.getIsprimary() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isprimary=?");
			qi.values.add(bean.getIsprimary());
			valueSet = true;
		}
		if (bean.getDatabaseaddress() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("databaseaddress=?");
			qi.values.add(bean.getDatabaseaddress());
			valueSet = true;
		}
		if (bean.getDatabasename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("databasename=?");
			qi.values.add(bean.getDatabasename());
			valueSet = true;
		}
		if (bean.getDatabasevendor() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("databasevendor=?");
			qi.values.add(bean.getDatabasevendor());
			valueSet = true;
		}
		if (bean.getDatabaseversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("databaseversion=?");
			qi.values.add(bean.getDatabaseversion());
			valueSet = true;
		}
		if (bean.getDatabaseport() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("databaseport=?");
			qi.values.add(bean.getDatabaseport());
			valueSet = true;
		}
		if (bean.getContactfirstname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("contactfirstname=?");
			qi.values.add(bean.getContactfirstname());
			valueSet = true;
		}
		if (bean.getContactlastname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("contactlastname=?");
			qi.values.add(bean.getContactlastname());
			valueSet = true;
		}
		if (bean.getContactemail() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("contactemail=?");
			qi.values.add(bean.getContactemail());
			valueSet = true;
		}
		if (bean.getContactphone() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("contactphone=?");
			qi.values.add(bean.getContactphone());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Site bean, Site criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_site SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getSiteid() != null || bean.isNull("siteid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("siteid=? ");
			uqi.setValues.add(bean.getSiteid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("siteid"), uqi);
			valueSet = true;
		}
		if (bean.getSitename() != null || bean.isNull("sitename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("sitename=? ");
			uqi.setValues.add(bean.getSitename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("sitename"), uqi);
			valueSet = true;
		}
		if (bean.getIsprimary() != null || bean.isNull("isprimary")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isprimary=? ");
			uqi.setValues.add(bean.getIsprimary());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isprimary"), uqi);
			valueSet = true;
		}
		if (bean.getDatabaseaddress() != null || bean.isNull("databaseaddress")) {
			if (valueSet)
				buf.append(", ");
			buf.append("databaseaddress=? ");
			uqi.setValues.add(bean.getDatabaseaddress());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databaseaddress"), uqi);
			valueSet = true;
		}
		if (bean.getDatabasename() != null || bean.isNull("databasename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("databasename=? ");
			uqi.setValues.add(bean.getDatabasename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databasename"), uqi);
			valueSet = true;
		}
		if (bean.getDatabasevendor() != null || bean.isNull("databasevendor")) {
			if (valueSet)
				buf.append(", ");
			buf.append("databasevendor=? ");
			uqi.setValues.add(bean.getDatabasevendor());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databasevendor"), uqi);
			valueSet = true;
		}
		if (bean.getDatabaseversion() != null || bean.isNull("databaseversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("databaseversion=? ");
			uqi.setValues.add(bean.getDatabaseversion());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databaseversion"), uqi);
			valueSet = true;
		}
		if (bean.getDatabaseport() != null || bean.isNull("databaseport")) {
			if (valueSet)
				buf.append(", ");
			buf.append("databaseport=? ");
			uqi.setValues.add(bean.getDatabaseport());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("databaseport"), uqi);
			valueSet = true;
		}
		if (bean.getContactfirstname() != null
				|| bean.isNull("contactfirstname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("contactfirstname=? ");
			uqi.setValues.add(bean.getContactfirstname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactfirstname"), uqi);
			valueSet = true;
		}
		if (bean.getContactlastname() != null || bean.isNull("contactlastname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("contactlastname=? ");
			uqi.setValues.add(bean.getContactlastname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactlastname"), uqi);
			valueSet = true;
		}
		if (bean.getContactemail() != null || bean.isNull("contactemail")) {
			if (valueSet)
				buf.append(", ");
			buf.append("contactemail=? ");
			uqi.setValues.add(bean.getContactemail());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactemail"), uqi);
			valueSet = true;
		}
		if (bean.getContactphone() != null || bean.isNull("contactphone")) {
			if (valueSet)
				buf.append(", ");
			buf.append("contactphone=? ");
			uqi.setValues.add(bean.getContactphone());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactphone"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Site createObject(ResultSet rs) throws SQLException {
		Site obj = new Site();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setOwner((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setModtime((rs.getObject(4) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(4)).getTime()) : null);
		obj.setModuser((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setSiteid((String) rs.getObject(6));
		obj.setSitename((String) rs.getObject(7));
		obj.setIsprimary((rs.getObject(8) != null) ? new java.math.BigDecimal(
				rs.getObject(8).toString()) : null);
		obj.setDatabaseaddress((String) rs.getObject(9));
		obj.setDatabasename((String) rs.getObject(10));
		obj.setDatabasevendor((String) rs.getObject(11));
		obj.setDatabaseversion((String) rs.getObject(12));
		obj
				.setDatabaseport((rs.getObject(13) != null) ? new java.math.BigDecimal(
						rs.getObject(13).toString())
						: null);
		obj.setContactfirstname((String) rs.getObject(14));
		obj.setContactlastname((String) rs.getObject(15));
		obj.setContactemail((String) rs.getObject(16));
		obj.setContactphone((String) rs.getObject(17));
		return obj;
	}

	public List<Site> find(Connection con, Site criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Site> results = new LinkedList<Site>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_site ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Site item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Site bean, Site criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Site criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_site ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
