package clinical.storage.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import clinical.storage.IPlugin;
import clinical.storage.StorageUtils;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.JargonUtils;
import clinical.utils.SRBFileSystemAdapter;
import clinical.web.download.FileInfo;
import clinical.web.download.PathWrapper;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SRBPlugin.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SRBPlugin implements IPlugin {
	SRBFileSystemAdapter sfsAdapter = null;
	String cacheDir;

	public SRBPlugin(Map<String, Object> paramMap) {
		cacheDir = (String) paramMap.get("cacheDir");
		Assertion.assertNotNull(cacheDir);
		Assertion.assertTrue(new File(cacheDir).exists());
	}

	@Override
	public List<PathWrapper> load(FileInfo fi) throws Exception {
		if (sfsAdapter == null)
			throw new Exception("The plugin is not initialized!");

		List<PathWrapper> srbFiles = new ArrayList<PathWrapper>();
		if (fi.isDir()) {
			File dir = FileInfo.getFullPathFile(fi, fi.getSourceRootDir());
			String dirPath = dir.getAbsolutePath();

			FileInfo nfi = new FileInfo(dirPath, fi.getFileType(), fi
					.getStorageType(), fi.getSourceRootDir(), false);

			String relDirPath = nfi.getRelativePath();
			String localPath = FileUtils.createFullPath(cacheDir, relDirPath);

			System.out.println("**** from SRB '" + fi.getPath() + "' \nto '"
					+ localPath + "'");

			JargonUtils.copyFromSRB(dir.getAbsolutePath(), localPath, sfsAdapter);

			File localDir = new File(FileUtils
					.createFullPath(cacheDir, relDirPath));
			File[] localFilePaths = localDir.listFiles();
			for (int i = 0; i < localFilePaths.length; i++) {
				if (localFilePaths[i].isFile()) {
					String filePath = localFilePaths[i].getAbsolutePath();
					if (filePath.startsWith(cacheDir)) {
						filePath = filePath.substring(cacheDir.length());
						filePath = filePath.replaceFirst("^\\/+", "");
					}
					srbFiles.add(new PathWrapper(filePath, nfi.getSourceRootDir()));
				} else {
					StorageUtils.recurseDir(srbFiles, localFilePaths[i], cacheDir,
							nfi.getSourceRootDir());
				}
			}
		} else {
			String relPath = fi.getRelativePath();
			if (FileUtils.buildLocalPath(cacheDir, relPath)) {
				String localPath = FileUtils.createFullPath(cacheDir, relPath);
				JargonUtils.copyFromSRB(fi.getPath(), localPath, sfsAdapter);
				srbFiles.add(new PathWrapper(relPath, fi.getSourceRootDir()));
			}
		}
		return srbFiles;
	}

	@Override
	public void shutdown() {
		if (sfsAdapter != null)
			sfsAdapter.shutdown();
	}

	@Override
	public void startup() throws Exception {
		sfsAdapter = new SRBFileSystemAdapter();
	}

	public static String getSupportedType() {
		return "srb";
	}

	@Override
	public boolean isSupported(String storageType) {
		if (storageType == null)
			return false;
		return storageType.equalsIgnoreCase("srb");
	}

	@Override
	public void put(FileInfo localFi, FileInfo remoteFi) throws Exception {
		if (remoteFi.isDir()) {
			throw new Exception("target is not a file!:" + remoteFi.getPath());
		}
		SRBFileSystem srbFileSystem = null;
		try {
			srbFileSystem = new SRBFileSystem();
			File rf = new File(remoteFi.getPath());
			if (!remoteFi.isDir()) {
				SRBFile srbFile = new SRBFile(srbFileSystem, rf.getParent());
				if (srbFile.exists() || srbFile.mkdirs()) {
					LocalFile lf = new LocalFile(localFi.getPath());
					SRBFile srbF = new SRBFile(srbFileSystem, remoteFi.getPath());
					// force overwrite on copy like the normal copy semantics
					lf.copyTo(srbF, true);
				} else {
					throw new Exception("Cannot create collection: " + srbFile);
				}
			}

		} finally {
			if (srbFileSystem != null) {
				try {
					srbFileSystem.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

}
