package clinical.test;

import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestSuite;
import clinical.web.IAppConfigService;
import clinical.web.ImageHandler;
import clinical.web.ServiceFactory;

/**
 * @author I. Burak Ozyurt
 * @version $Id: FileCacheCleanupTest.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class FileCacheCleanupTest extends MyTestCase {

	public FileCacheCleanupTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile);
	}

	public void testCacheCleanup() throws Exception {
		// Properties appProps = GenUtils.loadProperties("clinical.properties");

		IAppConfigService configService = ServiceFactory.getAppConfigService();
		ImageHandler ih = ServiceFactory.getImageHandlerService();
		String cacheRoot = getProperty("mbirn.cacheroot");
		ih.doCacheCleanup(cacheRoot, configService, 100, 10000000, false);
	}

	public static Test suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new FileCacheCleanupTest("testCacheCleanup",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}