package clinical.test;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.utils.JargonUtils;
import clinical.utils.SRBFileSystemAdapter;
import edu.sdsc.grid.io.GeneralFile;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: MiscTests.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class MiscTests extends TestCase {
	public MiscTests(String name) {
		super(name);
	}

	public void rangeCalcTest() {
		int curPage = 11;
		int totNumPages = 16;
		int maxNumPages = 5;
		// 0 based
		int curRange = (curPage - 1) / maxNumPages;
		int rangeStart = curRange * maxNumPages + 1;
		int rangeEnd = rangeStart + maxNumPages - 1;
		if (rangeEnd > totNumPages)
			rangeEnd = totNumPages;
		if ((rangeEnd - rangeStart + 1) < maxNumPages
				&& totNumPages > maxNumPages) {
			rangeStart = rangeEnd - maxNumPages + 1;
		}
		// both ends inclusive

		System.out.println("current Page=" + curPage + " rangeStart="
				+ rangeStart + " rangeEnd=" + rangeEnd);
		assertTrue(rangeStart <= curPage && rangeEnd >= rangeEnd);
	}

	public void numberFormatTest() {
		NumberFormat df = DecimalFormat.getInstance();
		df.setMaximumFractionDigits(2);

		String valueStr = "113.52000000000001";
		String value = null;
		if (GenUtils.isDecimalNumber(valueStr)) {
			value = df.format(GenUtils.toNumber(valueStr));
		}
		System.out.println("value=" + value);
	}

	public void testGetAllFilesUnderDir() {
		String rootDir = "/home/bozyurt/dev/java/branch/BIRN/clinical/conf";
		List<File> files = FileUtils.getAllFilesUnderDir(rootDir);

		assertTrue(!files.isEmpty());
		for (Object element : files) {
			File f = (File) element;
			System.out.println(f);
		}
	}

	public void testGetAllFilesUnderCollection() throws Exception {
		String rootCol = "/home/Projects/fBIRNPhaseII__0010/Data/001200635031/scanVisit__0012__0002/MRI__0001/sm2/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
            long start = System.currentTimeMillis();
			List<GeneralFile> files = JargonUtils.getAllFilesUnderCollection(
					rootCol, sfsAdapter);
			long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
			assertTrue(!files.isEmpty());
			for (GeneralFile f : files) {
				System.out.println(f);
			}
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();

		}
	}


	public void testGetAllFilesUnderCollection2() throws Exception {
		String rootCol = "/home/Projects/fBIRNPhaseII__0010/Data/001200635031/scanVisit__0012__0002/MRI__0001/sm2/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
            long start = System.currentTimeMillis();
			List<String> files = JargonUtils.getAllFilesUnderCollection2(
					rootCol, sfsAdapter);
			long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
			assertTrue(!files.isEmpty());
			for (String f : files) {
				System.out.println(f);
			}
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();

		}
	}

	public void testCollectionCopy()  throws Exception {
		String srbPath = "/home/Projects/fBIRNPhaseII__0010/Data/000900369824/scanVisit__0009__0002/MRI__0001/bh1/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
            long start = System.currentTimeMillis();
            JargonUtils.copyFromSRB(srbPath, "/tmp", sfsAdapter);
            long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();
		}
	}

	public void testIndividualFilesCopy()  throws Exception {
		String rootCol = "/home/Projects/fBIRNPhaseII__0010/Data/000900369824/scanVisit__0009__0002/MRI__0001/bh1/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
			List<String> files = JargonUtils.getAllFilesUnderCollection2(
					rootCol, sfsAdapter);
            long start = System.currentTimeMillis();
            for(String srbPath : files) {
              int idx = srbPath.lastIndexOf('/');
              String filename = srbPath.substring(idx+1);
              JargonUtils.copyFromSRB(srbPath, "/tmp/ANALYZE_7.5/" + filename, sfsAdapter);
            }
            long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();
		}
	}

	public void testDeleteRecursively() {
		String dir = "/home/bozyurt/download_cache/1210011660327";
		FileUtils.deleteRecursively(new File(dir));
	}
	
	public void testSortNumerically() {
	   File[] jpegFiles = new File[] {new File("128.jpeg"),new File("2.jpeg"), new File("8.jpeg")};
	   Arrays.sort(jpegFiles, new Comparator<File>() {
         public int compare(File o1, File o2) {
            String prefix1 = o1.getName();
            prefix1 = prefix1.replaceFirst("\\..+$", "");
            String prefix2 = o2.getName();
            prefix2 = prefix2.replaceFirst("\\..+$", "");
            int num1 = GenUtils.toInt(prefix1, -1);
            int num2 = GenUtils.toInt(prefix2, -1);
            return num1 - num2;
         }
      });
	}


	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		// suite.addTest(new MiscTests("rangeCalcTest"));
		// suite.addTest(new MiscTests("numberFormatTest"));
		//suite.addTest(new MiscTests("testGetAllFilesUnderDir"));
		//suite.addTest(new MiscTests("testGetAllFilesUnderCollection"));
		//suite.addTest( new MiscTests("testCollectionCopy"));
		//suite.addTest( new MiscTests("testIndividualFilesCopy"));
		suite.addTest( new MiscTests("testDeleteRecursively"));
		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}

}