package clinical.test;

import java.io.IOException;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;

import junit.framework.TestSuite;
import clinical.server.vo.Assessmentdata;
import clinical.server.vo.Deriveddata;
import clinical.server.vo.Executedtransformflow;
import clinical.server.vo.Humansubject;
import clinical.web.common.query.OracleSQLDialect;
import clinical.web.common.query.PostgresSQLDialect;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.SearchPredicateList;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.common.query.TSQLQueryBuilder;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: TSQLProcessorTests.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class TSQLProcessorTests extends MyTestCase {

	public TSQLProcessorTests(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile, true);
	}

	public TSQLProcessorTests(String testName, String propsFile,
			boolean skipQueryProcessorCache) throws IOException {
		super(testName, propsFile, skipQueryProcessorCache);
	}

	@SuppressWarnings("unused")
	public void testTSQLProcessor() throws Exception {
		Connection con = null;
		try {
			con = getConnection();
			long start = System.currentTimeMillis();

			TSQLProcessor processor = new TSQLProcessor(new OracleSQLDialect());
			// String s = "select r.* from Rawdata as r where r.subjectid in
			// ('000894468383', '000862323007') order by r.componentid,
			// r.segmentid asc";
		   String s1 = "select a.scorename, a.textvalue from Assessmentdata as a where a.subjectid in ('000894468383', '000862323007') and a.isvalidated = 1 order by a.assessmentid, a.scorename asc";
			String s2 = "select  a.* from Assessmentdata as a, Storedassessment as s "
					+ "where a.ncStoredassessmentUniqueid = s.uniqueid and s.isvalidated = 1 "
					+ "and s.subjectid in ('000894468383', '000862323007') and a.isvalidated = 1 "
					+ "order by a.assessmentid, a.scorename asc";
			List<?> results = processor.executeQuery(con, s2);
			long diff = System.currentTimeMillis() - start;
			assertTrue(!results.isEmpty());
			for (Iterator<?> iter = results.iterator(); iter.hasNext();) {
				Assessmentdata ad = (Assessmentdata) iter.next();
				System.out.println(ad);
			}

			System.out.println("Time elapsed(msecs): " + diff);

		} finally {
			releaseConnection(con);
		}
	}

	public void testTSQLProcessorMultiTableSelect() throws Exception {
		Connection con = null;
		try {
			con = getConnection();
			long start = System.currentTimeMillis();
			String tsql = "select r.*, d.objectsize, d.objecttype from Rawdata as r, Dataobject as d where "
					+ " r.subjectid ='000602155404' and r.uniqueid = d.dataid and  d.objecttype = '3_LOCAL COL DICOM'"
					+ " order by r.ncExperimentUniqueid, r.subjectid, r.componentid, r.segmentid";

			TSQLProcessor processor = new TSQLProcessor(new OracleSQLDialect());
			List<?> results = processor.executeQuery(con, tsql);
			long diff = System.currentTimeMillis() - start;
			assertTrue(!results.isEmpty());
			for (Iterator<?> iter = results.iterator(); iter.hasNext();) {
				Object[] row = (Object[]) iter.next();
				StringBuffer buf = new StringBuffer(256);
				buf.append(row[0].toString()).append("\n");
				buf.append(row[1].toString()).append("\n");
				System.out.println(buf.toString());
			}

			System.out.println("Time elapsed(msecs): " + diff);
		} finally {
			releaseConnection(con);
		}
	}


	public void testTSQLProcessorThetaJoin() throws Exception {
		Connection con = null;
		try {
			con = getConnection();

			TSQLProcessor tsp = new TSQLProcessor(new OracleSQLDialect());
			StringBuffer qBuf = new StringBuffer(128);
			qBuf.append("select w.*, p.* from ConfWebuser as w, ConfWebuserPriv as p where ");
			qBuf.append("w.uniqueId = p.webuserId order by w.name");
			List<?> results = tsp.executeQuery(con, qBuf.toString());
			assertTrue(!results.isEmpty());
			for (Iterator<?> iter = results.iterator(); iter.hasNext();) {
				Object[] row = (Object[]) iter.next();
				StringBuffer buf = new StringBuffer(256);
				buf.append(row[0].toString()).append("\n");
				buf.append(row[1].toString()).append("\n");

				System.out.println(buf.toString());
			}
		} finally {
			releaseConnection(con);
		}
	}

	public void testTSQLProcessorWhereClauseWithIn() throws Exception {
		Connection con = null;
		try {
			con = getConnection();

			TSQLProcessor tsp = new TSQLProcessor(new OracleSQLDialect());
			StringBuffer qBuf = new StringBuffer(128);
			qBuf.append("select h.* from Humansubject as h where ");
			qBuf.append("h.subjectid in ('009015657193','000820711216')");
			List<?> results = tsp.executeQuery(con, qBuf.toString());
			assertTrue(!results.isEmpty());
			for (Iterator<?> iter = results.iterator(); iter.hasNext();) {
				Humansubject hs = (Humansubject) iter.next();
				System.out.println(hs);
			}
		} finally {
			releaseConnection(con);
		}
	}


	public void testQuery1() throws Exception {
		Connection con = null;
		try {
			con = getConnection();
			TSQLProcessor tsp = new TSQLProcessor( new PostgresSQLDialect() );
			StringBuffer qb = new StringBuffer(256);
			qb.append("select f.* from Executedtransformflow as f,");
			qb.append("Analysisflow as a where ");
			qb.append("f.componentid = a.componentid and ");
			qb.append("f.analysisid = a.analysisid and ");
			qb.append("a.analysisid = ").append("19151");
			System.out.println("TSQL:" + qb.toString());
			List<?> results = tsp.executeQuery(con, qb.toString());
			assertTrue(!results.isEmpty());
			for (Iterator<?> iter = results.iterator(); iter.hasNext();) {
				Executedtransformflow et = (Executedtransformflow) iter.next();
				System.out.println(et);
			}

		} finally {
			releaseConnection(con);
		}
	}

	public void testTSQLQueryBuilder() throws Exception {
		String subjectID = "000602155404";
		String projectID = "227";
		SearchPredicate sp = new SearchPredicate("ncExperimentUniqueid",
				projectID, SearchPredicate.EQUAL, SearchPredicate.INTEGER);

		SearchPredicateList spList = new SearchPredicateList();
		spList.addSearchPredicate(sp, SearchPredicateList.NONE);
		SearchPredicate sp2 = new SearchPredicate("subjectID", subjectID,
				SearchPredicate.EQUAL, SearchPredicate.STRING);
		spList.addSearchPredicate(sp2, SearchPredicateList.AND);

		// SearchCriteria sc = new SearchCriteria(spList);

		TSQLQueryBuilder qb = new TSQLQueryBuilder(clinical.server.vo.Subjexperiment.class, spList);

		String tsql = qb.buildQuery();

		System.out.println(tsql);
		Connection con = null;
		try {
			con = getConnection();

			TSQLProcessor tsp = new TSQLProcessor(new PostgresSQLDialect());
			List<?> results = tsp.executeQuery(con, tsql);
			for (Object row : results) {
				System.out.println(row);
			}

		} finally {
			releaseConnection(con);
		}
	}

	public void testTSQLQueryWithFunctions() throws Exception {
		Connection con = null;
		try {
			con = getConnection();
			TSQLProcessor tsp = new TSQLProcessor( new PostgresSQLDialect() );
			StringBuilder qb = new StringBuilder(256);
			qb.append("select d.* from Deriveddata as d where endsWith(d.datauri,'.xml') and d.israw = false");
			System.out.println("TSQL:" + qb.toString());
			List<?> results = tsp.executeQuery(con, qb.toString());
			assertTrue(!results.isEmpty());
			for (Iterator<?> iter = results.iterator(); iter.hasNext();) {
				Deriveddata dd = (Deriveddata) iter.next();
				System.out.println(dd);
			}

		} finally {
			releaseConnection(con);
		}
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		// suite.addTest( new TSQLProcessorTests("testTSQLProcessor",
		// "test.properties") );
		// suite.addTest(new TSQLProcessorTests(
		// 		"testTSQLProcessorMultiTableSelect", "test.properties"));
		// suite.addTest(new TSQLProcessorTests("testTSQLProcessorThetaJoin", "test.properties"));

		// suite.addTest(new TSQLProcessorTests("testTSQLProcessorWhereClauseWithIn", "test.properties"));

		// suite.addTest(new TSQLProcessorTests("testTSQLQueryBuilder", "test.properties"));
		// suite.addTest( new TSQLProcessorTests("testQuery1", "test.properties"));
		suite.addTest( new TSQLProcessorTests("testTSQLQueryWithFunctions", "test.properties"));

		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}
