package clinical.test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author I. Burak Ozyurt
 * @version $Id: TestCaseInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class TestCaseInfo {
	String name;
	Map<String, QueryRequestInfo> queryRequestInfoMap = new HashMap<String, QueryRequestInfo>();
	Map<String, ResponseInfo> responseMap = new HashMap<String, ResponseInfo>();

	public TestCaseInfo() {
	}

	public void addResponse(ResponseInfo ri) {
		responseMap.put(ri.getTitle(), ri);
	}

	public void addQueryRequestInfo(QueryRequestInfo qri, String prevQriName) {
		QueryRequestInfo prevQri = getQueryRequestInfo(prevQriName);
		qri.setPrevious(prevQri);
		queryRequestInfoMap.put(qri.getName(), qri);
	}

	public QueryRequestInfo getQueryRequestInfo(String name) {
		return queryRequestInfoMap.get(name);
	}

	public ResponseInfo getResponseInfo(String title) {
		return (ResponseInfo) responseMap.get(title);
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}
}