package clinical.tools.dbadmin;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import guilib.common.BaseDialog;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import clinical.utils.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AdminController.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class AdminController {
	String scriptDir;
	GroovyObject dbUtils;
	GroovyObject admin;
	Object db;
	Map<?, ?> dbu;
	State state;

	public AdminController(Frame owner, State state) throws Exception {
		this.state = state;
		Properties props = GenUtils.loadProperties("dbadmin.properties");
		scriptDir = props.getProperty("scripts.dir");
		ClassLoader parent = AdminController.class.getClassLoader();
		GroovyClassLoader loader = new GroovyClassLoader(parent);
		
		Class<?> adminClass = loader.parseClass(new File(scriptDir
				+ "/AdminUtils.groovy"));

		Class<?> gClass = loader.parseClass(new File(scriptDir
				+ "/DBUtils.groovy"));
		
		dbUtils = (GroovyObject) gClass.newInstance();
		if (isEmpty(state.getDbHost()) || isEmpty(state.getDbPwd())
				|| isEmpty(state.getDbUser()) || isEmpty(state.getSchema())) {
			DBParamsDialog dlg = new DBParamsDialog(owner,
					"HID Connection Parameters", state);
			int rc = dlg.showDialog();
			if (rc != BaseDialog.OK_PRESSED) {
				System.exit(0);
			}
			dlg.dispose();
		}

		String jdbcURL = "jdbc:postgresql://" + state.getDbHost() + ":"
				+ state.getDbPort() + "/" + state.getSchema();
		System.out.println("jdbcURL:" + jdbcURL);

		Object[] args1 = new Object[] { state.getDbUser(), state.getDbPwd(),
				jdbcURL };

		this.db = dbUtils.invokeMethod("getDb", args1);
		System.out.println(db);

		Map<?, ?> dbu = (Map<?, ?>) dbUtils.invokeMethod("getDatabaseUser",
				new Object[] { db, state.getDatabaseUsername() });

		if (dbu == null) {
			dbu = (Map<?, ?>) dbUtils.invokeMethod("getDatabaseUser",
					new Object[] { db });
		}

		System.out.println(dbu);
		admin = (GroovyObject) adminClass.newInstance();
		admin.invokeMethod("init", new Object[] { db, "postgres", dbu });
	}

	public List<Map<String, Object>> getDataObjectTypes() {
		List<?> list = (List<?>) admin.invokeMethod("getDataObjectTypes",
				new Object[0]);
		List<Map<String, Object>> mlist = new ArrayList<Map<String, Object>>(list
				.size());
		for (Object o : list) {
			Map<?, ?> map = (Map<?, ?>) o;
			Map<String, Object> tmap = new HashMap<String, Object>(17);
			for (Object k : map.keySet()) {
				tmap.put(k.toString(), map.get(k));
			}
			mlist.add(tmap);
		}
		return mlist;
	}

	public static boolean isEmpty(String st) {
		return st == null || st.trim().length() == 0;
	}

	public List<Map<String, Object>> find(String voName) {
		List<?> list = (List<?>) admin.invokeMethod("get" + voName + "s",
				new Object[0]);
		List<Map<String, Object>> mlist = new ArrayList<Map<String, Object>>(list
				.size());
		for (Object o : list) {
			Map<?, ?> map = (Map<?, ?>) o;
			Map<String, Object> tmap = new HashMap<String, Object>(17);
			for (Object k : map.keySet()) {
				tmap.put(k.toString(), map.get(k));
			}
			mlist.add(tmap);
		}
		return mlist;
	}

	public List<Map<String, Object>> find(String voName, String wherePart) {
		List<?> list = (List<?>) admin.invokeMethod("get" + voName + "s",
				new Object[] { wherePart });
		List<Map<String, Object>> mlist = new ArrayList<Map<String, Object>>(list
				.size());
		for (Object o : list) {
			Map<?, ?> map = (Map<?, ?>) o;
			Map<String, Object> tmap = new HashMap<String, Object>(17);
			for (Object k : map.keySet()) {
				tmap.put(k.toString(), map.get(k));
			}
			mlist.add(tmap);
		}
		return mlist;
	}

	public void add(String voName, Map<String, Object> argMap) {
		admin.invokeMethod("add" + voName, new Object[] { argMap });
	}

	public void addUpdate(String voName, Map<String, Object> argMap) {
		admin.invokeMethod("addUpdate" + voName, new Object[] { argMap });
	}

	public void delete(String voName, Map<String, Object> argMap) {
		admin.invokeMethod("delete" + voName, new Object[] { argMap });
	}

	public void update(String voName, Map<String, Object> argMap) {
		admin.invokeMethod("update" + voName, new Object[] { argMap });
	}

	public List<?> getFromSRB(String srbRootPath) {
		return (List<?>) admin.invokeMethod("getFromSRB",
				new Object[] { srbRootPath });
	}

	public long getSizeFromSRB(String srbPath) {
		Long v = (Long) admin.invokeMethod("getSizeFromSRB",
				new Object[] { srbPath });
		return v;
	}

	public void addDataObjectType(Map<String, Object> argMap) {
		admin.invokeMethod("addDataObjectType", new Object[] { argMap });
	}

	public void deleteDataObjectType(Map<String, Object> argMap) {
		admin.invokeMethod("deleteDataObjectType", new Object[] { argMap });
	}

	public void updateDataObjectType(Map<String, Object> argMap) {
		admin.invokeMethod("updateDataObjectType", new Object[] { argMap });
	}

	State getState() {
		return state;
	}
}
