package clinical.tools.dbadmin;

import guilib.common.BaseDialog;
import guilib.common.NameValueField;
import guilib.common.PasswordField;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DBParamsDialog.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class DBParamsDialog extends BaseDialog {
	private static final long serialVersionUID = 1L;
	State state;
	NameValueField dbHostField, dbPortField, dbUserField, dbNameField;

	PasswordField pwdField;

	public DBParamsDialog(Frame owner, String title, State state) {
		super(owner, title, new String[] { "OK", "Cancel" });
		this.state = state;
		init();
		pack();
	}

	protected void init() {
		JPanel labelPanel = new JPanel(new GridLayout(5, 1, 3, 3));
		labelPanel.add(new JLabel("Database Host:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database Port:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database Name:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database User/Schema:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database User Password:", JLabel.RIGHT));

		JPanel panel = new JPanel(new GridLayout(5, 1, 3, 3));

		String host = state.getDbHost();

		panel.add(dbHostField = new NameValueField(null, 10));
		if (host != null)
			dbHostField.setValue(host);
		panel.add(dbPortField = new NameValueField(null, 10));
		dbPortField.setValue("" + state.getDbPort());
		panel.add(dbNameField = new NameValueField(null, 10));
		String dbName = state.getSchema();
		if (dbName != null)
			dbNameField.setValue(dbName);

		panel.add(dbUserField = new NameValueField(null, 10));
		dbUserField.setValue(state.getDbUser());

		panel.add(pwdField = new PasswordField(null, 10));

		JPanel paramPanel = new JPanel(new GridLayout(1, 2));
		paramPanel.add(labelPanel);
		paramPanel.add(panel);
		this.setDefaultButton("OK");

		getContentPane().add(paramPanel);
	}

	private boolean hasUserData(String value) {
		return (value != null && value.trim().length() > 0);
	}

	public void actionPerformed(ActionEvent e) {
		this.returnCode = NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {

				if (hasUserData(dbHostField.getValue())
						&& hasUserData(dbPortField.getValue())
						&& hasUserData(dbNameField.getValue())) {

					state.setDbHost(dbHostField.getValue());
					state.setDbPort(Integer.parseInt(dbPortField.getValue()));
					state.setSchema(dbNameField.getValue());
				}

				if (hasUserData(dbUserField.getValue())) {
					state.setDbUser(dbUserField.getValue());
				}

				if (pwdField.getValue() != null && pwdField.getValue().length() > 0) {
					state.setDbPwd(pwdField.getValue());
					this.returnCode = OK_PRESSED;
				}
			}
		}
		setVisible(false);

	}

}// ;
