package clinical.tools.dbadmin;

import guilib.common.BaseDialog;
import guilib.common.FileNameValueField;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import clinical.tools.dbadmin.GridFtpClient.FileInfoWrapper;
import clinical.utils.FileUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: RDAdminPanel.java 157 2010-01-27 18:13:10Z bozyurt $
 */
public class RDAdminPanel extends JPanel implements ActionListener,
		PropertyChangeListener {
	private static final long serialVersionUID = 1L;
	AdminController ac;
	JComboBox dataURICB;
	JComboBox storageTypeCB;
	JComboBox objectTypeCB;
	JComboBox fileTypeCB;
	FileNameValueField localRootDirField;
	DefaultComboBoxModel duCBModel, otCBModel, ftCBModel, stCBModel;
	JButton activateButton = new JButton("Search");
	JButton registerButton = new JButton("Register");
	JButton helpButton = new JButton("Help");
	List<String> paths;
	PropertyChangeSupport pcs;
	Frame owner;
	List<Map<String, Object>> addedDORows = new ArrayList<Map<String, Object>>();
	Map<String, Map<String, Object>> rdMap = new HashMap<String, Map<String, Object>>();

	Map<String, Map<String, Object>> objectTypeMap = new HashMap<String, Map<String, Object>>(
			37);
	Map<String, Map<String, Object>> expMap = new HashMap<String, Map<String, Object>>(
			37);

	Map<String, String> gridFtpStateMap = new HashMap<String, String>(7);
	Map<String, Long> fileSizeMap = new HashMap<String, Long>();

	public RDAdminPanel(AdminController ac, Frame owner) {
		this.ac = ac;
		this.owner = owner;
		pcs = new PropertyChangeSupport(this);
		setLayout(new BorderLayout(5, 5));
		setBorder(BorderFactory
				.createTitledBorder("Assign Data Types to Raw Data"));
		activateButton.addActionListener(this);
		registerButton.addActionListener(this);
		helpButton.addActionListener(this);
		duCBModel = new DefaultComboBoxModel();
		stCBModel = new DefaultComboBoxModel();
		stCBModel.addElement("GridFTP");
		stCBModel.addElement("Local");
		stCBModel.addElement("SRB");

		List<Map<String, Object>> expList = ac.find("Experiment");
		boolean first = true;
		for (Map<String, Object> row : expList) {
			System.out.println(row);
			String baseuri = (String) row.get("baseuri");
			if (baseuri != null) {
				expMap.put(baseuri, row);
				duCBModel.addElement(baseuri);
				if (first) {
					if (row.containsKey("storagetype")) {
						Object cv = row.get("storagetype");
						if (cv != null) {
							setStorageType(cv.toString());
						}
					}
				}
				first = false;
			}
		}

		otCBModel = new DefaultComboBoxModel();

		List<Map<String, Object>> dotList = ac.find("DataObjectType");
		for (Map<String, Object> row : dotList) {
			String objectType = (String) row.get("objecttype");
			if (objectType != null) {
				if (objectType.startsWith("3") && objectType.indexOf("DICOM") != -1
						&& objectType.indexOf("FILE") != -1) {
					objectTypeMap.put(objectType, row);
					otCBModel.addElement(objectType);
				}
			}
		}
		registerButton.setEnabled(false);
		ftCBModel = new DefaultComboBoxModel();
		storageTypeCB = new JComboBox(stCBModel);

		objectTypeCB = new JComboBox(otCBModel);
		dataURICB = new JComboBox(duCBModel);
		dataURICB.addActionListener(this);
		fileTypeCB = new JComboBox(ftCBModel);

		Dimension size = dataURICB.getSize();
		size.width = 220;
		dataURICB.setSize(size);
		dataURICB.setPreferredSize(size);

		localRootDirField = new FileNameValueField(
				"Local Experiment Root Directory: ", 40,
				FileNameValueField.DIR_ONLY);

		JPanel pane = new JPanel(new GridLayout(2, 1, 5, 5));
		JPanel p = new JPanel();
		BoxLayout bl = new BoxLayout(p, BoxLayout.X_AXIS);
		p.setLayout(bl);
		p.add(Box.createHorizontalStrut(5));
		p.add(new JLabel("Exp:"));
		p.add(Box.createHorizontalStrut(5));
		p.add(dataURICB);
		p.add(Box.createHorizontalStrut(5));
		p.add(new JLabel("Storage:"));
		p.add(Box.createHorizontalStrut(5));
		p.add(storageTypeCB);
		p.add(Box.createHorizontalStrut(5));

		p.add(new JLabel("File Type:"));
		p.add(Box.createHorizontalStrut(5));
		p.add(fileTypeCB);
		p.add(Box.createHorizontalStrut(5));
		p.add(activateButton);
		p.add(Box.createHorizontalStrut(5));
		p.add(helpButton);
		p.add(Box.createHorizontalGlue());

		pane.add(p);

		JPanel p2 = new JPanel();
		bl = new BoxLayout(p2, BoxLayout.X_AXIS);
		p2.setLayout(bl);
		p2.add(Box.createHorizontalGlue());
		p2.add(new JLabel("Object Type:"));
		p2.add(Box.createHorizontalStrut(5));
		p2.add(objectTypeCB);
		p2.add(Box.createHorizontalStrut(5));
		p2.add(registerButton);
		p2.add(Box.createHorizontalStrut(5));
		pane.add(p2);

		add(pane, BorderLayout.NORTH);
	}

	protected void setStorageType(String storageType) {
		if (storageType.equalsIgnoreCase("gridftp")) {
			stCBModel.removeAllElements();
			stCBModel.addElement("GridFTP");
		} else if (storageType.equalsIgnoreCase("local")) {
			stCBModel.removeAllElements();
			stCBModel.addElement("Local");
		}
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == activateButton) {
			String storageType = (String) storageTypeCB.getSelectedItem();
			String selBaseURI = (String) dataURICB.getSelectedItem();
			Map<String, Object> exp = expMap.get(selBaseURI);
			String expID = exp.get("uniqueid").toString();
			List<Map<String, Object>> rdList = ac.find("Rawdata",
					"where nc_experiment_uniqueid = " + expID);
			List<String> dataURIs = new ArrayList<String>();
			for (Map<String, Object> row : rdList) {
				String uri = (String) row.get("datauri");
				if (uri != null) {
					dataURIs.add(uri);
					rdMap.put(uri, row);
					// also register parent dir
					rdMap.put(Utils.getDir(uri), row);
				}
			}

			List<String> filteredPaths = Utils.filterPaths(dataURIs, new String[] {
					"t1", "t2" });

			if (storageType.equalsIgnoreCase("srb")) {
				this.paths = new ArrayList<String>();
				for (String filteredPath : filteredPaths) {
					System.out.println(filteredPath);
					List<?> fromSRB = ac.getFromSRB(filteredPath);
					for (Object o : fromSRB) {
						paths.add((String) o);
					}
				}
			} else if (storageType.equalsIgnoreCase("gridftp")) {
				handleGridFtp(filteredPaths);
			} else if (storageType.equalsIgnoreCase("local")) {
				boolean ok = askForLocalRootDir(selBaseURI);
				if (ok && this.localRootDirField.getValue() != null) {
					this.paths = new ArrayList<String>();
					String localRoot = this.localRootDirField.getValue();
					for (String filteredPath : filteredPaths) {
						// System.out.println(filteredPath);
						// File dir = new File(localRoot, filteredPath);
						File dir = buildPath(localRoot, filteredPath);
						if (dir.exists() && dir.isDirectory()) {
							System.out.println(dir);
							System.out.println("***** checking DICOM files...");
							List<File> allFilesUnderDir = FileUtils
									.getAllFilesUnderDir(dir.getPath());
							for (File f : allFilesUnderDir) {
								paths.add(f.getAbsolutePath());
							}
						} else {
							if (!dir.exists()) {
								System.err.println("-- Not a valid path: " + dir);
							} else if (!dir.isDirectory()) {
								System.err.println("-- Not a directory: " + dir);
							}
						}
					}
				}
			} else {
				throw new RuntimeException("Not a supported storage type:"
						+ storageType);
			}

			if (paths == null) {
				return;
			}

			Set<String> fileNameSets = new HashSet<String>();
			for (Object o : paths) {
				String path = (String) o;
				int idx = path.lastIndexOf('/');
				if (idx != -1) {
					String fpart = path.substring(idx + 1);
					if (fpart.indexOf('.') != -1) {
						fileNameSets.add(fpart);
					}
				}
			}
			List<String> fileNameList = new ArrayList<String>(fileNameSets);
			Collections.sort(fileNameList);
			ftCBModel.removeAllElements();
			for (String fn : fileNameList) {
				ftCBModel.addElement(fn);
			}
			registerButton.setEnabled(true);
		}

		if (e.getSource() == registerButton) {
			handleRegister();
		}

		if (e.getSource() == helpButton) {
			HelpDialog dlg = new HelpDialog(owner, "Help", helpText);
			dlg.showDialog();
			dlg.dispose();
		}

		if (e.getSource() == dataURICB) {
			String selBaseURI = (String) dataURICB.getSelectedItem();
			Map<String, Object> exp = expMap.get(selBaseURI);
			Object cv = exp.get("storagetype");

			stCBModel.removeAllElements();
			stCBModel.addElement("GridFTP");
			stCBModel.addElement("Local");
			stCBModel.addElement("SRB");
			if (cv != null) {
				setStorageType(cv.toString());
			}
		}
	}

	public static File buildPath(String rootDir, String path) {
		if (path.startsWith(rootDir)) {
			return new File(path);
		} else {
			return new File(rootDir, path);
		}
	}

	void handleGridFtp(List<String> filteredPaths) {
		State state = ac.getState();
		GridFtpLoginDialog dlg = new GridFtpLoginDialog(this.owner,
				"GridFTP Login", state.getGridFtpStateMap());
		int rc = dlg.showDialog();
		if (rc == BaseDialog.OK_PRESSED) {
			GridFtpClient client = null;
			try {
				client = new GridFtpClient(dlg.getGridFtpHost(), dlg
						.getMyProxyHost());
				client.connect(dlg.getUsername(), dlg.getPwd());

				this.paths = new ArrayList<String>();
				for (String filteredPath : filteredPaths) {
					System.out.println(filteredPath);
					List<FileInfoWrapper> files = client.getFiles(filteredPath);
					for (FileInfoWrapper fiw : files) {
						if (fiw.getFi().isFile()) {
							paths.add(fiw.getFullPath());
							// System.out.println(fiw.getFullPath());
							Long size = this.fileSizeMap.get(filteredPath);
							if (size == null) {
								size = fiw.getFi().getSize();
							} else {
								size += fiw.getFi().getSize();
							}
							this.fileSizeMap.put(filteredPath, size);
						}
					}
				}

			} catch (Exception x) {
				x.printStackTrace();
			} finally {
				if (client != null)
					client.shutdown();
			}
		}
		dlg.dispose();
	}

	void handleRegister() {
		String fileType = (String) fileTypeCB.getSelectedItem();
		List<String> filteredPaths = new ArrayList<String>();
		for (String path : this.paths) {
			if (path.endsWith(fileType)) {
				filteredPaths.add(path);
			}
		}

		addedDORows.clear();
		for (String fp : filteredPaths) {
			System.out.println(fp);
			String dir = Utils.getDir(fp);
			Map<String, Object> rdRow = rdMap.get(dir);
			if (rdRow == null)
				continue;

			Pattern[] patterns = Utils
					.prepRegexPatterns(new String[] { "t1", "t2" });

			List<Map<String, Object>> rdList = ac.find("Rawdata",
					"where datauri = '" + fp + "'");
			if (rdList == null || rdList.isEmpty()) {
				Map<String, Object> argMap = new HashMap<String, Object>(17);
				argMap.put("extensionname", rdRow.get("extensionname"));
				argMap.put("segmentid", rdRow.get("segmentid"));
				argMap.put("componentid", rdRow.get("componentid"));
				argMap.put("nc_experiment_uniqueid", rdRow
						.get("nc_experiment_uniqueid"));
				argMap.put("subjectid", rdRow.get("subjectid"));
				argMap.put("protocolversion", rdRow.get("protocolversion"));
				argMap.put("protocolid", rdRow.get("protocolid"));
				argMap.put("nc_colequipment_uniqueid", rdRow
						.get("nc_colequipment_uniqueid"));
				argMap.put("datauri", fp);

				argMap = Utils.prepArgMap(argMap, true);

				System.out.println(argMap);
				ac.add("Rawdata", argMap);

				rdList = ac.find("Rawdata", "where datauri = '" + fp + "'");
			}

			if (rdList != null && !rdList.isEmpty()) {
				List<Map<String, Object>> doList = ac.find("DataObject",
						"where dataid = " + rdList.get(0).get("uniqueid"));
				if (doList == null || doList.isEmpty()) {
					// register data object type
					String selObjectType = (String) objectTypeCB.getSelectedItem();
					Map<String, Object> dot = objectTypeMap.get(selObjectType);
					Map<String, Object> argMap = new HashMap<String, Object>(17);
					argMap.put("dataid", rdList.get(0).get("uniqueid"));
					argMap.put("objecttypeid", dot.get("uniqueid"));
					String key = Utils.stripAfterMatch(fp, patterns);
					long fileSize = getSize(key);
					argMap.put("objectsize", new Long(fileSize));

					argMap = Utils.prepArgMap(argMap, true);
					System.out.println("dataobject:" + argMap);

					ac.addUpdate("DataObject", argMap);
					addedDORows.add(argMap);
				}
			}
		}
		System.out.println("Registration is done!");
		pcs.firePropertyChange("updateRO", false, true);
	}

	protected long getSize(String filteredPath) {
		String storageType = (String) storageTypeCB.getSelectedItem();
		if (storageType.equalsIgnoreCase("srb")) {
			return ac.getSizeFromSRB(filteredPath);
		} else if (storageType.equalsIgnoreCase("gridftp")) {
			return this.fileSizeMap.get(filteredPath);
		} else if (storageType.equalsIgnoreCase("local")) {
			String localRootDir = this.localRootDirField.getValue();
			return FileUtils.getTotalSizeUnderDir(filteredPath, localRootDir);
		} else {
			throw new RuntimeException("Unsupported storage type:" + storageType);
		}

	}

	protected boolean askForLocalRootDir(String selBaseURI) {
		localRootDirField.setValue(selBaseURI);
		int rc = JOptionPane.showConfirmDialog(this, localRootDirField,
				"Please enter Local Project Root Directory",
				JOptionPane.OK_CANCEL_OPTION);
		return rc == JOptionPane.OK_OPTION;
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		pcs.addPropertyChangeListener(listener);
	}

	public List<Map<String, Object>> getAddedDORows() {
		return addedDORows;
	}

	public static String helpText = "<html>"
			+ "<p>Registers structural (t1 and t2) DICOM tar files for the selected<p>"
			+ "experiment in your image storage for image previewing via HID web application.<p>"
			+ "First you need to do a search for eligible DICOM tar files in the your storage<p>"
			+ "for the selected experiment.<p><p>"
			+ "To do this;<ol> "
			+ "<li>Select a project root path from <b>Exp</b> dropdown box "
			+ "<li>Select the type of your storage from <b>Storage</b> dropdown box"
			+ "<li>Press the <b>Search</b> button </ol>"
			+ "Now, you should see either <i>DICOM.tar.gz</i> or <i>DICOM.tar</i> in the <b>File Type</b> dropdown<p>"
			+ "if you have eligible DICOM files for previewing you can now register them<p>"
			+ "First select the eligible DICOM file type from <b>File Type</b> dropdown.<p>"
			+ "The <b>Object Type</b> dropdown should only have DICOM entries like;"
			+ "<ul><li>3_LOC FILE DICOM (for local storage type)"
			+ "<li>3_GFTP FILE DICOM (for GRIDFTP storage type)"
			+ "<li>3_SRB FILE DICOM (for SRB storage type)</ul>"
			+ "Select the appropriate one for your storage type and press <b>Register</b> button."
			+ "</html>";
}
