package clinical.tools.dbadmin;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import clinical.utils.FileUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: State.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class State implements Serializable {
	private static final long serialVersionUID = 1L;
	Map<String, String> gridFtpStateMap = new HashMap<String, String>(7);
	String dbUser;
	String dbHost;
	int dbPort = 5432;
	String schema;
	transient String dbPwd;
	String databaseUsername = "ADMIN";

	public State() {}

	public Map<String, String> getGridFtpStateMap() {
		return gridFtpStateMap;
	}

	public String getDbUser() {
		return dbUser;
	}

	public String getDbHost() {
		return dbHost;
	}

	public int getDbPort() {
		return dbPort;
	}

	public String getSchema() {
		return schema;
	}

	public String getDbPwd() {
		return dbPwd;
	}

	public String getDatabaseUsername() {
		return databaseUsername;
	}

	public void serialize(String serFile) {
		try {
			FileUtils.serialize(this, serFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static State deserialize(String serFile) {
		try {
			State state = (State) FileUtils.deserialize(serFile);
			return state;
		} catch (Exception e) {
			// e.printStackTrace();
			return new State();
		}
	}

	void setGridFtpStateMap(Map<String, String> gridFtpStateMap) {
		this.gridFtpStateMap = gridFtpStateMap;
	}

	void setDbUser(String dbUser) {
		this.dbUser = dbUser;
	}

	void setDbHost(String dbHost) {
		this.dbHost = dbHost;
	}

	void setDbPort(int dbPort) {
		this.dbPort = dbPort;
	}

	void setSchema(String schema) {
		this.schema = schema;
	}

	void setDbPwd(String dbPwd) {
		this.dbPwd = dbPwd;
	}

	void setDatabaseUsername(String databaseUsername) {
		this.databaseUsername = databaseUsername;
	}

}
