package clinical.tools.dbadmin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Utils.java 86 2009-08-11 23:18:38Z bozyurt $
 */
public class Utils {
	public static boolean isNumber(String s) {
		try {
			Double.parseDouble(s.trim());
		} catch (NumberFormatException e) {
			return false;
		}
		return true;
	}

	public static int toInt(String s) {
		return Integer.parseInt(s.trim());
	}

	public static List<String> filterPaths(List<String> paths,
			String[] protocolIds) {
		Pattern[] patterns = prepRegexPatterns(protocolIds);
		Set<String> filteredPaths = new HashSet<String>();
		for (String path : paths) {
			if (anyMatch(path, patterns)) {
				String strippedPath = stripAfterMatch(path, patterns);
				filteredPaths.add(strippedPath);
			}
		}
		return new ArrayList<String>(filteredPaths);
	}

	public static Pattern[] prepRegexPatterns(String[] protocolIds) {
		Pattern[] patterns = new Pattern[protocolIds.length];
		for (int i = 0; i < protocolIds.length; i++) {
			patterns[i] = Pattern.compile("\\b" + protocolIds[i] + "\\b");
		}
		return patterns;
	}

	public static String stripAfterMatch(String path, Pattern[] patterns) {
		for (Pattern p : patterns) {
			Matcher m = p.matcher(path);
			if (m.find()) {
				return path.substring(0, m.end());
			}
		}
		return path;
	}

	public static boolean anyMatch(String text, Pattern[] patterns) {
		for (Pattern p : patterns) {
			if (p.matcher(text).find()) {
				return true;
			}
		}
		return false;
	}

	public static String getDir(String path) {
		int idx = path.lastIndexOf('/');
		if (idx != -1) {
			return path.substring(0, idx);
		}
		return path;
	}

	public static Map<String, Object> prepArgMap(Map<String, Object> amap,
			boolean removeDateFields) {
		Map<String, Object> argMap = new HashMap<String, Object>(17);
		for (String key : amap.keySet()) {
			String value = amap.get(key).toString();
			if (removeDateFields && key.indexOf("modtime") != -1) {
				continue;
			} else if (value != null) {
				if (value.startsWith("00") || !Utils.isNumber(value)) {
					argMap.put(key, "'" + value + "'");
				} else {
					argMap.put(key, value);
				}
			}
		}
		return argMap;
	}
}
