package clinical.tools.install;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import clinical.web.helpers.security.UsersXml2DBConverter;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UsersXml2DBConverterTask.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class UsersXml2DBConverterTask extends Task {
	String usersFile;

	public void setUsersFile(String newFile) {
		this.usersFile = newFile;
	}
	
	@Override
	public void execute() throws BuildException {
		UsersXml2DBConverter converter = null;
		try {
			if (usersFile == null) {
				throw new BuildException("The attribute 'usersFile' is not set!");
			}
			converter = new UsersXml2DBConverter( getProject() );
			converter.populateDB(usersFile);
		} catch (Exception x) {
			x.printStackTrace();
			throw new BuildException(x.getMessage());
		} finally {
			if ( converter != null) {
				try {
					converter.shutdown();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}
}
