package clinical.tools.maintenance;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

import clinical.server.dao.ExpsegmentDAO;
import clinical.server.vo.Expsegment;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.exception.BaseException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SegmentHelper.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SegmentHelper extends AbstractHelper {
	int theProtocolVersion;
	String theProtocolID;
	int theExperimentID;

	public SegmentHelper(String dbID, String usersFile) throws BaseException {
		super(dbID, usersFile);
	}

	public Expsegment insert(int visitID, int segmentID, String subjectID,
			Date timeStamp) throws Exception {
		return insert(visitID, segmentID, -1, subjectID, timeStamp, -1, null);
	}

	public Expsegment insert(int visitID, int segmentID, int experimentID,
			String subjectID, Date timeStamp, int protocolVersion,
			String protocolID) throws Exception {
		if (theProtocolID == null && protocolID == null) {
			throw new BaseException("protocolID is not specified!");
		}
		if (theProtocolVersion < 0 && protocolVersion < 0) {
			throw new BaseException("protocolVersion is not specified!");
		}
		if (theExperimentID < 0 && experimentID < 0) {
			throw new BaseException("experimentID is not specified!");
		}

		Expsegment segment = new Expsegment();
		segment.setIstimeinterval(new Boolean(false));
		segment.setOwner(dbHelper.getDatabaseUserID());
		segment.setModuser(dbHelper.getDatabaseUserID());
		segment.setModtime(new Date());
		segment.setUniqueid(dbHelper.getUniqueID(Constants.SEGMENT_DB_TABLE, "uniqueid"));
		segment.setTableid(dbHelper.getTableID(Constants.SEGMENT_DB_TABLE));

		segment.setComponentid(new BigDecimal(String.valueOf(visitID)));
		if (protocolVersion < 0)
			segment.setProtocolversion(new BigDecimal(String
					.valueOf(theProtocolVersion)));
		else
			segment.setProtocolversion(new BigDecimal(String
					.valueOf(protocolVersion)));

		if (experimentID < 0)
			segment.setNcExperimentUniqueid(new BigDecimal(String
					.valueOf(theExperimentID)));
		else
			segment.setNcExperimentUniqueid(new BigDecimal(String
					.valueOf(experimentID)));
		if (protocolID == null)
			segment.setProtocolid(theProtocolID);
		else
			segment.setProtocolid(protocolID);

		segment.setSubjectid(subjectID);
		segment.setSegmentid(new BigDecimal(String.valueOf(segmentID)));
		segment.setTimeStamp(new Timestamp(timeStamp.getTime()));
		segment.setDescription("");

		ExpsegmentDAO dao = DAOFactory.createExpsegmentDAO(this.dbID);
		dao.insert(getConnection(), segment);
		return segment;
	}

	// ---------------------- setters --------------
	public void setTheProtocolVersion(int newTheProtocolVersion) {
		this.theProtocolVersion = newTheProtocolVersion;
	}

	public void setTheProtocolID(String newTheProtocolID) {
		this.theProtocolID = newTheProtocolID;
	}

	public void setTheExperimentID(int newTheExperimentID) {
		this.theExperimentID = newTheExperimentID;
	}

	// ---------------------- getters --------------
	public int getTheProtocolVersion() {
		return this.theProtocolVersion;
	}

	public String getTheProtocolID() {
		return this.theProtocolID;
	}

	public int getTheExperimentID() {
		return this.theExperimentID;
	}

}