package clinical.upload;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ColumnInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ColumnInfo {
	protected String name;
	protected String newName;
	protected TypeInfo type;
	protected String sqlType;
	protected String dateCol;
	protected String visitType;
	protected boolean stored = true;
	protected String comments;
	protected int colIdx;
	protected Map<String, String> valueMap;
	protected ConditionerInfo conditioner;

	public ColumnInfo() {
	}

	// ---------------------- setters --------------
	public void setColIdx(int newColIdx) {
		this.colIdx = newColIdx;
	}

	public void setName(String newName) {
		this.name = newName;
	}

	public void setType(TypeInfo newType) {
		this.type = newType;
	}

	public void setSqlType(String newSqlType) {
		this.sqlType = newSqlType;
	}

	public void setConditioner(ConditionerInfo newConditioner) {
		this.conditioner = newConditioner;
	}

	public void setNewName(String newNewName) {
		this.newName = newNewName;
	}

	public void setDateCol(String newDateCol) {
		this.dateCol = newDateCol;
	}

	public void setVisitType(String newVisitType) {
		this.visitType = newVisitType;
	}

	public void setStored(boolean newStored) {
		this.stored = newStored;
	}

	public void setComments(String newComments) {
		this.comments = newComments;
	}

	// ---------------------- getters --------------
	public String getName() {
		return this.name;
	}

	public TypeInfo getType() {
		return this.type;
	}

	public String getSqlType() {
		return this.sqlType;
	}

	public ConditionerInfo getConditioner() {
		return this.conditioner;
	}

	public int getColIdx() {
		return this.colIdx;
	}

	public String getNewName() {
		return this.newName;
	}

	public String getDateCol() {
		return this.dateCol;
	}

	public String getVisitType() {
		return this.visitType;
	}

	public boolean getStored() {
		return this.stored;
	}

	public boolean hasValueMap() {
		return (valueMap != null && !valueMap.isEmpty());
	}

	public String getComments() {
		return this.comments;
	}

	public void addMap(String from, String to) {
		if (valueMap == null)
			valueMap = new HashMap<String, String>(11);
		valueMap.put(from, to);
	}

	public String getValueMapValue(String from) {
		return valueMap.get(from);
	}

	public String getValue(String[] colValues) {
		return colValues[colIdx];
	}

	public String getValue(List<String> colValues) {
		return (String) colValues.get(colIdx);
	}
}