package clinical.upload;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * 
 * @version $Id: ConditionerInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 * @author I. Burak Ozyurt
 */

public class ConditionerInfo {
	protected String className;
	protected String methodName;
	protected Object conditioner;
	protected Method method;

	public ConditionerInfo() {
	}

	// ---------------------- setters --------------
	public void setClassName(String newClassName) {
		this.className = newClassName;
	}

	public void setMethodName(String newMethodName) {
		this.methodName = newMethodName;
	}

	// ---------------------- getters --------------
	public String getClassName() {
		return this.className;
	}

	public String getMethodName() {
		return this.methodName;
	}

	/**
	 * conditions the value read to be inserted into the corresponding database
	 * table before the SQL type conversion by using the registered conditioning
	 * method
	 */

	public Object conditionValue(String value, Object params)
			throws ClassNotFoundException, InstantiationException,
			IllegalAccessException, NoSuchMethodException,
			InvocationTargetException {
		if (conditioner == null) {
			conditioner = Class.forName(className).newInstance();
		}
		if (method == null) {
			Class<?>[] methodParams = { String.class, Object.class };
			method = conditioner.getClass().getDeclaredMethod(methodName,
					methodParams);
		}

		return method.invoke(conditioner, new Object[] { value, params });
	}
}