package clinical.upload;

import guilib.common.BaseDialog;
import guilib.common.NameValueField;
import guilib.common.PasswordField;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DBParamsDialog.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class DBParamsDialog extends BaseDialog {
	private static final long serialVersionUID = 1L;
	ConfigurationInfo confInfo;
	NameValueField dbHostField, dbPortField, dbSchemaField, dbNameField;

	PasswordField pwdField;

	public DBParamsDialog(Frame owner, String title, ConfigurationInfo confInfo) {
		super(owner, title, new String[] { "OK", "Cancel" });
		this.confInfo = confInfo;
		init();
		pack();
	}

	protected DBURLInfo extractDBHost(String dbURL) {
		if (dbURL == null || dbURL.trim().length() == 0)
			return null;
		int idx = dbURL.indexOf('@');
		int endIdx = dbURL.indexOf(':', idx);
		String host = dbURL.substring(idx + 1, endIdx);
		idx = endIdx + 1;
		endIdx = dbURL.indexOf(':', idx);
		int port = Integer.parseInt(dbURL.substring(idx, endIdx));
		String dbName = dbURL.substring(endIdx + 1);
		DBURLInfo dbURLInfo = new DBURLInfo(host, port, dbName);

		return dbURLInfo;
	}

	class DBURLInfo {
		String host;
		int port;
		String dbName;

		public DBURLInfo(String host, int port, String dbName) {
			this.host = host;
			this.port = port;
			this.dbName = dbName;
		}

		public String toJDBCURL() {
			StringBuffer buf = new StringBuffer();
			buf.append("jdbc:oracle:thin:@").append(host);
			buf.append(':').append(port).append(':').append(dbName);
			return buf.toString();
		}

	}

	protected void init() {
		JPanel labelPanel = new JPanel(new GridLayout(5, 1, 3, 3));
		labelPanel.add(new JLabel("Database Host:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database Port:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database Name:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database User/Schema:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database User Password:", JLabel.RIGHT));

		JPanel panel = new JPanel(new GridLayout(5, 1, 3, 3));

		DBURLInfo dui = extractDBHost(confInfo.getDbURL());

		panel.add(dbHostField = new NameValueField(null, 10));
		if (dui != null)
			dbHostField.setValue(dui.host);
		panel.add(dbPortField = new NameValueField(null, 10));
		if (dui != null)
			dbPortField.setValue("" + dui.port);
		panel.add(dbNameField = new NameValueField(null, 10));
		if (dui != null)
			dbNameField.setValue(dui.dbName);

		panel.add(dbSchemaField = new NameValueField(null, 10));
		dbSchemaField.setValue(confInfo.getDbSchema());

		panel.add(pwdField = new PasswordField(null, 10));

		JPanel paramPanel = new JPanel(new GridLayout(1, 2));
		paramPanel.add(labelPanel);
		paramPanel.add(panel);
		this.setDefaultButton("OK");

		getContentPane().add(paramPanel);
	}

	public ConfigurationInfo getConfInfo() {
		return confInfo;
	}

	private boolean hasUserData(String value) {
		return (value != null && value.trim().length() > 0);
	}

	public void actionPerformed(ActionEvent e) {
		this.returnCode = NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {

				if (hasUserData(dbHostField.getValue())
						&& hasUserData(dbPortField.getValue())
						&& hasUserData(dbNameField.getValue())) {
					DBURLInfo dui = new DBURLInfo(dbHostField.getValue(),
							Integer.parseInt(dbPortField.getValue()),
							dbNameField.getValue());

					confInfo.setDbURL(dui.toJDBCURL());
				}

				if (hasUserData(dbSchemaField.getValue())) {
					confInfo.setDbSchema(dbSchemaField.getValue());
					confInfo.setUser(dbSchemaField.getValue().toLowerCase());
				}

				if (pwdField.getValue() != null
						&& pwdField.getValue().length() > 0) {
					confInfo.setPwd(pwdField.getValue());
					this.returnCode = OK_PRESSED;
					// System.out.println("setting returnCode to " +
					// returnCode);
				}
			}
		}
		setVisible(false);

	}

}// ;
